/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.format.sepa.AmountType3;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.ChargeBearerType2Code;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.PartyIdentification21;
import de.businesslogics.format.sepa.PaymentIdentification1_Ebics23;
import de.businesslogics.format.sepa.PaymentTypeInformation7;
import de.businesslogics.format.sepa.RemittanceInformation3;
import org.xml.sax.SAXException;

public class CreditTransferTransactionInformation5
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private PaymentIdentification1_Ebics23 pmtId;
    private PaymentTypeInformation7 pmtTpInf;
    private AmountType3 amt;
    private ChargeBearerType2Code chrgBr;
    private FinancialInstitution2 cdtrAgt;
    private PartyIdentification21 cdtr;
    private CashAccount8 cdtrAcct;
    private RemittanceInformation3 rmtInf;

    private CreditTransferTransactionInformation5() {
    }

    public CreditTransferTransactionInformation5(PaymentIdentification1_Ebics23 pmtId, AmountType3 amt, FinancialInstitution2 cdtrAgt, PartyIdentification21 cdtr, CashAccount8 cdtrAcct, RemittanceInformation3 rmtInf) {
        this.pmtId = pmtId;
        this.amt = amt;
        this.cdtrAgt = cdtrAgt;
        this.cdtr = cdtr;
        this.cdtrAcct = cdtrAcct;
        this.rmtInf = rmtInf;
    }

    public AmountType3 getAmt() {
        return this.amt;
    }

    public CashAccount8 getCdtrAcct() {
        return this.cdtrAcct;
    }

    public FinancialInstitution2 getCdtrAgt() {
        return this.cdtrAgt;
    }

    public RemittanceInformation3 getRmtInf() {
        return this.rmtInf;
    }

    public void setRmtInf(RemittanceInformation3 rmtInf) {
        this.rmtInf = rmtInf;
    }

    public PartyIdentification21 getCdtr() {
        return this.cdtr;
    }

    public PaymentIdentification1_Ebics23 getPmtId() {
        return this.pmtId;
    }

    public PaymentTypeInformation7 getPmtTpInf() {
        return this.pmtTpInf;
    }

    public void setPmtTpInf(PaymentTypeInformation7 pmtTpInf) {
        this.pmtTpInf = pmtTpInf;
    }

    public ChargeBearerType2Code getChrgBr() {
        return this.chrgBr;
    }

    public void setChrgBr(ChargeBearerType2Code chrgBr) {
        this.chrgBr = chrgBr;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.pmtId.printOut("PmtId", ps);
        ps.printOut("PmtTpInf", this.pmtTpInf);
        this.amt.printOut("Amt", ps);
        ps.printOut("ChrgBr", this.chrgBr);
        this.cdtrAgt.printOut("CdtrAgt", ps);
        this.cdtr.printOut("Cdtr", ps);
        this.cdtrAcct.printOut("CdtrAcct", ps);
        if (this.rmtInf != null) {
            this.rmtInf.printOut("RmtInf", ps);
        }
    }

    public static class Parser
    extends ElementParser {
        final CreditTransferTransactionInformation5 toReturn = new CreditTransferTransactionInformation5();

        public Parser() {
            super(0);
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.001.001.02.grp".equals(uri)) {
                if ("PmtId".equals(localName) && this.allowChild(0)) {
                    return new PaymentIdentification1_Ebics23.Parser(uri);
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(1)) {
                    return new PaymentTypeInformation7.Parser(uri);
                }
                if ("Amt".equals(localName) && this.allowChild(0, 2)) {
                    return new AmountType3.Parser(uri);
                }
                if ("ChrgBr".equals(localName) && this.allowChild(3)) {
                    return ChargeBearerType2Code.SLEV.createParser();
                }
                if ("CdtrAgt".equals(localName) && this.allowChild(2, 4)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("Cdtr".equals(localName) && this.allowChild(5)) {
                    return new PartyIdentification21.Parser(uri);
                }
                if ("CdtrAcct".equals(localName) && this.allowChild(6)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("RmtInf".equals(localName) && this.allowChild(7)) {
                    return new RemittanceInformation3.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtId = (PaymentIdentification1_Ebics23)element;
                    break;
                }
                case 1: {
                    this.toReturn.pmtTpInf = (PaymentTypeInformation7)element;
                    break;
                }
                case 2: {
                    this.toReturn.amt = (AmountType3)element;
                    break;
                }
                case 3: {
                    this.toReturn.chrgBr = (ChargeBearerType2Code)element;
                    break;
                }
                case 4: {
                    this.toReturn.cdtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 5: {
                    this.toReturn.cdtr = (PartyIdentification21)element;
                    break;
                }
                case 6: {
                    this.toReturn.cdtrAcct = (CashAccount8)element;
                    break;
                }
                case 7: {
                    this.toReturn.rmtInf = (RemittanceInformation3)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(6);
            return this.toReturn;
        }
    }
}

