/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAExtractorV3Ch;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.license.License;
import de.businesslogics.util.Currency;
import de.businesslogics.validation.RegularExpressions;
import java.nio.charset.Charset;

public class ConverterConfiguration {
    public static final Currency CONVERTER_CURRENCY;
    public static final String CONVERTER_VERSION = "de.businesslogics.format.sepa.ConverterConfiguration.version";
    public static final String BATCH_BOOKING = "de.businesslogics.format.sepa.ConverterConfiguration.batchBooking";
    public static final String INTERNATIONAL = "de.businesslogics.format.sepa.ConverterConfiguration.international";
    public static final String ENCODING = "de.businesslogics.format.sepa.ConverterConfiguration.encoding";
    public static final String PRETTY_XML = "de.businesslogics.format.sepa.ConverterConfiguration.prettyXML";
    public static final String INVERT_BATCH_BOOKING = "de.businesslogics.format.sepa.ConverterConfiguration.invertBatchBooking";
    public static final String BASE_ID = "de.businesslogics.format.sepa.ConverterConfiguration.baseId";
    @Deprecated
    private static final String CONVERTER_VERSION_OLD = "de.businesslogics.format.sepa.CSVConvertern.version";
    @Deprecated
    private static final String USE_CSV_CONVERTER_CLASSIC = "de.businesslogics.format.sepa.CSVConverter.classic";
    @Deprecated
    private static final String BATCH_BOOKING_OLD = "de.businesslogics.format.sepa.CSVConverter.batchBooking";
    @Deprecated
    private static final String BASE_ID_OLD = "de.businesslogics.format.sepa.CSVConverter.baseId";
    private static final String UNSUPPORTED_VERSION;

    public static GeneralSEPAWriter.Version getSepaVersion() {
        String s = System.getProperty(CONVERTER_VERSION);
        GeneralSEPAWriter.Version version = GeneralSEPAWriter.DEFAULT_VERSION;
        if (s == null) {
            s = System.getProperty(CONVERTER_VERSION_OLD);
        }
        if (s != null) {
            try {
                version = GeneralSEPAWriter.Version.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                System.err.println(UNSUPPORTED_VERSION);
            }
        }
        return version;
    }

    public static SEPAPaymentData setDefaultCurrency(SEPAPaymentData data) {
        if (CONVERTER_CURRENCY == null) {
            return data;
        }
        data.setCurrency(CONVERTER_CURRENCY);
        return data;
    }

    public static void checkLicense() {
        License l = License.getLicense();
        l.checkValid();
    }

    public static String correctBaseId(String baseId) {
        if (!RegularExpressions.SEPA.matches(baseId)) {
            StringBuilder b = new StringBuilder(baseId.length());
            for (int i = 0; i < baseId.length(); ++i) {
                char c = baseId.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ' ' || c == '.' || c == ',' || c == '-' || c == '/' || c == '+' || c == ')' || c == '(' || c == '?') && c != ':') continue;
                b.append(c);
            }
            baseId = b.toString();
        }
        if (baseId.length() > 35) {
            baseId = baseId.substring(0, 35);
        }
        return baseId;
    }

    public static Boolean getDefaultBatchBooking() {
        String s = System.getProperty(BATCH_BOOKING);
        if (s == null) {
            s = System.getProperty(BATCH_BOOKING_OLD);
        }
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return null;
    }

    public static Boolean getInternational() {
        String s = System.getProperty(INTERNATIONAL);
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    public static Charset getEncoding() {
        try {
            return Charset.forName(System.getProperty(ENCODING, Charset.defaultCharset().name()));
        }
        catch (Exception e) {
            return Charset.defaultCharset();
        }
    }

    public static Boolean isInvertBatchBooking() {
        return Boolean.parseBoolean(System.getProperty(INVERT_BATCH_BOOKING, "false"));
    }

    @Deprecated
    public static boolean useClassicConverter() {
        return Boolean.parseBoolean(System.getProperty(USE_CSV_CONVERTER_CLASSIC, "false"));
    }

    public static boolean isPrettyXML() {
        return Boolean.parseBoolean(System.getProperty(PRETTY_XML, "false"));
    }

    public static String getBaseId() {
        String s = System.getProperty(BASE_ID);
        if (s != null) {
            return s;
        }
        return System.getProperty(BASE_ID_OLD);
    }

    public static boolean isCreateInstantPayment() {
        return false;
    }

    static {
        String s = System.getProperty("de.businesslogics.format.sepa.ConverterConfiguration.currency", null);
        if (s == null) {
            CONVERTER_CURRENCY = null;
        } else {
            CONVERTER_CURRENCY = Currency.getInstance(s);
            SEPAExtractorV3Ch.WRITE_CATEGORY = false;
            SEPAExtractorV3Ch.WRITE_CHARGE_BEARER = false;
        }
        UNSUPPORTED_VERSION = "Unsupported SEPA version. Supported are only " + String.valueOf((Object)GeneralSEPAWriter.Version.V24) + ", " + String.valueOf((Object)GeneralSEPAWriter.Version.V25) + ", " + String.valueOf((Object)GeneralSEPAWriter.Version.V27) + ", " + String.valueOf((Object)GeneralSEPAWriter.Version.V30) + ", " + String.valueOf((Object)GeneralSEPAWriter.Version.Iso00100109) + " and " + String.valueOf((Object)GeneralSEPAWriter.Version.Iso00800108);
    }
}

