/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum ChequeType {
    BCHQ,
    CCCH,
    CCHQ,
    DRFT,
    ELDR;

    private static final Map<String, ResourceBundle> BUNDLES;

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = BUNDLES.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.ChequeType", locale);
            BUNDLES.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("ChequeType." + this.name());
        }
        catch (MissingResourceException e) {
            return "!ChequeType." + this.name() + "!";
        }
    }

    public static String getDescription(Locale locale, String name) {
        if (name != null) {
            try {
                ChequeType type = ChequeType.valueOf(name);
                if (type != null) {
                    return type.getDescription();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return name;
        }
        return null;
    }

    static {
        BUNDLES = new HashMap<String, ResourceBundle>();
    }
}

