/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYYYMMDDHHMMSS;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsElementListener;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.ch.pain0010010302.CreditTransferTransactionInformation10_CH;
import de.businesslogics.format.ch.pain0010010302.GroupHeader32_CH;
import de.businesslogics.format.ch.pain0010010302.PaymentInstructionInformation3_CH;
import de.businesslogics.format.ch.pain0010010302.PaymentTypeInformation19_CH;
import de.businesslogics.format.iso20022.pain00100102.CreditTransferTransactionInformation1;
import de.businesslogics.format.iso20022.pain00100102.GroupHeader1;
import de.businesslogics.format.iso20022.pain00100103.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00100103.CreditTransferTransactionInformation10;
import de.businesslogics.format.iso20022.pain00100103.GroupHeader32;
import de.businesslogics.format.iso20022.pain00100103.OrganisationIdentification4;
import de.businesslogics.format.iso20022.pain00100103.Party6Choice;
import de.businesslogics.format.iso20022.pain00100103.PartyIdentification32;
import de.businesslogics.format.iso20022.pain00100103.PaymentTypeInformation19;
import de.businesslogics.format.iso20022.pain00100108.CreditTransferTransaction26;
import de.businesslogics.format.iso20022.pain00100108.DateAndDateTimeChoice;
import de.businesslogics.format.iso20022.pain00100108.GroupHeader48;
import de.businesslogics.format.iso20022.pain00100108.PaymentInstruction22;
import de.businesslogics.format.iso20022.pain00100109.CreditTransferTransaction34;
import de.businesslogics.format.iso20022.pain00100109.DateAndDateTime2Choice;
import de.businesslogics.format.iso20022.pain00100109.GroupHeader85;
import de.businesslogics.format.iso20022.pain00100109.PaymentInstruction30;
import de.businesslogics.format.iso20022.pain00100109.PaymentTypeInformation26;
import de.businesslogics.format.ptk2.XmlDisplayMessage;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.CCTListener;
import de.businesslogics.format.sepa.CCTSingleTicket;
import de.businesslogics.format.sepa.CCTTicketI;
import de.businesslogics.format.sepa.CCTWrapperDocument;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation5;
import de.businesslogics.format.sepa.CurrencyAndAmount;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GroupHeader23;
import de.businesslogics.format.sepa.Pain00100102GrpDocument;
import de.businesslogics.format.sepa.Pain00100102GrpSingleTicket;
import de.businesslogics.format.sepa.PaymentInstructionInformation3;
import de.businesslogics.format.sepa.SEPAExtractorV2Iso;
import de.businesslogics.format.sepa.SEPAExtractorV2Stuzza;
import de.businesslogics.format.sepa.SEPAExtractorV3Ch;
import de.businesslogics.format.sepa.SEPAExtractorV3Iso;
import de.businesslogics.format.sepa.SEPAExtractorV8Iso;
import de.businesslogics.format.sepa.SEPAExtractorV9Iso;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.pain00100202.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.sepa.pain00100202.Document;
import de.businesslogics.format.sepa.pain00100202.GroupHeaderSCT;
import de.businesslogics.format.sepa.pain00100202.PaymentTypeInformationSCT1;
import de.businesslogics.format.sepa.pain00100203.OrganisationIdentificationSEPAChoice;
import de.businesslogics.format.sepa.pain00100203.PaymentInstructionInformationSCT;
import de.businesslogics.format.sepa.pain00100303.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.sepa.pain00100303.BICIdentifier;
import de.businesslogics.format.sepa.pain00100303.CustomerCreditTransferInitiationV03;
import de.businesslogics.format.sepa.pain00100303.GenericOrganisationIdentification1;
import de.businesslogics.format.sepa.pain00100303.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100303.PartySEPAChoice;
import de.businesslogics.format.stuzza.pain00100102at02.CurrencyCode;
import de.businesslogics.format.stuzza.pain00100102at02.PaymentInstructionInformation1;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class CCTTicketWrapper
implements XmlDisplayMessage {
    private static final long serialVersionUID = 1L;
    private final List<CCTTicketI> singleTickets = new ArrayList<CCTTicketI>();
    private String messageIdentification;
    private Date creationDateTime;
    private BigDecimal controlSum;
    private long numberOfTxs;
    private final Set<String> paymentMethods = new HashSet<String>();
    private final Set<String> serviceLevels = new HashSet<String>();
    private final Set<String> localInstruments = new HashSet<String>();
    private boolean containsSalaryPayments = false;
    private String nameSpace;
    private String initiatorName;
    private String initiatorId;

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<CCTTicketI> getSingleTickets() {
        return this.singleTickets;
    }

    @Override
    public EbicsHandler startParsing() {
        return this.startParsing(false);
    }

    public EbicsHandler startParsing(boolean bundesBank) {
        return this.startParsing(bundesBank, false);
    }

    public EbicsHandler startParsing(boolean bundesBank, boolean allowIsoFormats) {
        SwissArmyKnife sak = new SwissArmyKnife();
        sak.bundesBank = bundesBank;
        RootChoiceParser parser = new RootChoiceParser();
        parser.addParser(new CCTWrapperDocument.Parser(sak));
        parser.addPossibleRoot(de.businesslogics.format.sepa.pain00100203.Document.class);
        parser.addPossibleRoot(de.businesslogics.format.sepa.pain00100303.Document.class);
        if (allowIsoFormats) {
            parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00100102.Document.class);
            parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00100103.Document.class);
            parser.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:004:N", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
            parser.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:004", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
            parser.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:003:N", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
            parser.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
        }
        parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00100108.Document.class);
        parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00100109.Document.class);
        parser.addPossibleRoot(de.businesslogics.format.stuzza.pain00100102at02.Document.class);
        parser.addPossibleRoot(de.businesslogics.format.ch.pain0010010302.Document.class);
        EbicsHandler ebicsHandler = new EbicsHandler(parser);
        ebicsHandler.setListener(sak);
        return ebicsHandler;
    }

    protected void appendMost(ResourceBundle bundle, Locale locale, StringBuilder buffer) {
        String paymentMethod = this.paymentMethods.size() == 1 ? this.paymentMethods.iterator().next() : null;
        String serviceLevel = this.serviceLevels.size() == 1 ? this.serviceLevels.iterator().next() : null;
        String localInstrument = this.localInstruments.size() == 1 ? this.localInstruments.iterator().next() : null;
        buffer.append(bundle.getString("MAIN_SEPARATOR")).append("\r\n");
        if (SEPALocalInstrument.INST.name().equals(localInstrument)) {
            buffer.append(bundle.getString("ECHTZEIT_UEBERWEISUNGEN"));
        } else if (GeneralSEPAExtractor.URGP.equals(serviceLevel)) {
            buffer.append(bundle.getString("EIL_UEBERWEISUNGEN"));
        } else if (GeneralSEPAExtractor.SEPA.equals(serviceLevel)) {
            buffer.append(bundle.getString("SEPA_UEBERWEISUNGEN"));
        } else if (SEPAPaymentMethod.CHK.name().equals(paymentMethod)) {
            buffer.append(bundle.getString("SCHECK_ZAHLUNGEN"));
        } else {
            buffer.append(bundle.getString("UEBERWEISUNGEN"));
        }
        buffer.append("\r\n").append(bundle.getString("FILE_ID")).append(this.messageIdentification).append("\r\n").append(bundle.getString("TIMESTAMP")).append(new SimpleDateFormat(bundle.getString("TIMESTAMP_FORMAT")).format(this.creationDateTime)).append("\r\n");
        if (this.initiatorName != null) {
            buffer.append(bundle.getString("INITIATOR_NAME"));
            buffer.append(this.initiatorName);
            buffer.append("\r\n");
        }
        if (this.initiatorId != null) {
            buffer.append(bundle.getString("INITIATOR_ID"));
            buffer.append(this.initiatorId);
            buffer.append("\r\n");
        }
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            buffer.append(bundle.getString("MINOR_SEPARATOR"));
            buffer.append("\r\n");
            buffer.append(bundle.getString("TOTAL_ANZAHL"));
            buffer.append(this.getTotalNumberOfPayments());
            buffer.append("\r\n");
            buffer.append(bundle.getString("TOTOAL_AMOUNT"));
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(locale));
            buffer.append(df.format(this.getTotalAmount()));
            buffer.append("\r\n");
        }
        for (CCTTicketI t : this.singleTickets) {
            t.appendMost(bundle, locale, buffer);
        }
    }

    @Override
    public void appendText(Locale locale, StringBuilder buffer) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.Sepa", locale);
        this.appendMost(bundle, locale, buffer);
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
        buffer.append("\r\n");
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (CCTTicketI t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (CCTTicketI t : this.singleTickets) {
            totalNumber += (long)t.getNumberOfPayments();
        }
        return totalNumber;
    }

    public BigDecimal getControlSum() {
        return this.controlSum;
    }

    public long getNumberOfTxs() {
        return this.numberOfTxs;
    }

    private void setPaymentMethod(CCTSingleTicket ticket, String value) {
        ticket.setPaymentMethod(value);
        this.paymentMethods.add(StringUtils.checkNullAndTrim(value));
    }

    public String[] getPaymentMethods() {
        return this.paymentMethods.toArray(new String[this.paymentMethods.size()]);
    }

    private void setServiceLevel(CCTSingleTicket ticket, String value) {
        ticket.setServiceLevel(value);
        this.serviceLevels.add(StringUtils.checkNullAndTrim(value));
    }

    public String[] getServiceLevels() {
        return this.serviceLevels.toArray(new String[this.serviceLevels.size()]);
    }

    private void setLocalInstrument(CCTSingleTicket ticket, String value) {
        ticket.setLocalInstrument(value);
        this.localInstruments.add(StringUtils.checkNullAndTrim(value));
    }

    public String[] getLocalInstruments() {
        return this.localInstruments.toArray(new String[this.localInstruments.size()]);
    }

    public boolean containsSalaryPayments() {
        return this.containsSalaryPayments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendText(Locale.getDefault(), sb);
        return sb.toString();
    }

    private void checkPurposeCodeForSalary(String value) {
        if (value != null && SEPAUtil.isSalaryPayment(null, value)) {
            this.containsSalaryPayments = true;
        }
    }

    private void checkPaymentCategoryForSalary(String value) {
        if (value != null && SEPAUtil.isSalaryPayment(value, null)) {
            this.containsSalaryPayments = true;
        }
    }

    public class SwissArmyKnife
    implements CCTListener,
    EbicsElementListener {
        private Pain00100102GrpSingleTicket currentTicket1;
        private CCTSingleTicket currentTicket2;
        private List<?> list1ToClear;
        private List<?> list2ToClear;
        private boolean bundesBank;

        @Override
        public void endDocument(Pain00100102GrpDocument document) {
            GroupHeader23 grpHdr = document.getPain00100102().getGrpHdr();
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm();
            CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum();
            CCTTicketWrapper.this.numberOfTxs = grpHdr.getNbOfTxs();
            if (grpHdr.getInitgPty() != null) {
                CCTTicketWrapper.this.initiatorName = grpHdr.getInitgPty().getNm();
            }
        }

        @Override
        public void handleTransaction(CreditTransferTransactionInformation5 crdt) {
            this.currentTicket1.handleTransaction(crdt);
        }

        @Override
        public void startDocument(Pain00100102GrpDocument document) {
        }

        @Override
        public void endPaymentInstructionInformation(PaymentInstructionInformation3 pmtInf) {
            this.currentTicket1.endPaymentInstructionInformation(pmtInf);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket1);
        }

        @Override
        public void startPaymentInstructionInformation(PaymentInstructionInformation3 pmtInf) {
            this.currentTicket1 = new Pain00100102GrpSingleTicket();
            this.currentTicket1.startPaymentInstructionInformation(pmtInf);
        }

        @Override
        public void endDocument(Document document) {
            GroupHeaderSCT grpHdr = document.getPain_001_001_02().getGrpHdr();
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Long.parseLong(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
            if (grpHdr.getInitgPty() != null && grpHdr.getInitgPty().getNm() != null) {
                CCTTicketWrapper.this.initiatorName = grpHdr.getInitgPty().getNm().getValue();
            }
        }

        @Override
        public void handleTransaction(CreditTransferTransactionInformationSCT crdt) {
            this.currentTicket2.handleTransaction(crdt);
            if (crdt.getPurp() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(crdt.getPurp().getCd().getValue());
            }
        }

        @Override
        public void startDocument(Document document) {
        }

        @Override
        public void endPaymentInstructionInformation(de.businesslogics.format.sepa.pain00100202.PaymentInstructionInformationSCT pmtInf) {
            this.currentTicket2.endPaymentInstructionInformation(pmtInf);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            if (pmtInf.getPmtTpInf() != null) {
                PaymentTypeInformationSCT1 pmtTpInf = pmtInf.getPmtTpInf();
                CCTTicketWrapper.this.serviceLevels.add(StringUtils.checkNullAndTrim(pmtTpInf.getSvcLvl().getCd().getValue()));
                if (pmtTpInf.getCtgyPurp() != null) {
                    CCTTicketWrapper.this.checkPaymentCategoryForSalary(pmtTpInf.getCtgyPurp().getValue());
                }
            }
        }

        @Override
        public void startPaymentInstructionInformation(de.businesslogics.format.sepa.pain00100202.PaymentInstructionInformationSCT pmtInf) {
            this.currentTicket2 = new CCTSingleTicket();
            this.currentTicket2.startPaymentInstructionInformation(pmtInf);
        }

        @Override
        public void endGroupHeader(GroupHeaderSCT gh) {
        }

        @Override
        public void startGroupHeader(GroupHeaderSCT gh) {
        }

        @Override
        public void endGroupHeader(GroupHeader23 gh) {
        }

        @Override
        public void startGroupHeader(GroupHeader23 gh) {
        }

        @Override
        public void endElement(EbicsElement element) {
            if (element instanceof PaymentInstructionInformationSCT) {
                de.businesslogics.format.sepa.pain00100203.GenericOrganisationIdentification1 goic;
                OrganisationIdentificationSEPAChoice oic;
                de.businesslogics.format.sepa.pain00100203.PartySEPAChoice pc;
                de.businesslogics.format.sepa.pain00100203.PartyIdentificationSEPA1 p;
                String accCurrency;
                de.businesslogics.format.sepa.pain00100203.PaymentTypeInformationSCT1 pmtTpInf;
                PaymentInstructionInformationSCT sct = (PaymentInstructionInformationSCT)element;
                BigDecimal ctrlSum = null;
                if (sct.getCtrlSum() != null) {
                    ctrlSum = sct.getCtrlSum().getValue();
                }
                int nbOfTxs = -1;
                if (sct.getNbOfTxs() != null) {
                    try {
                        nbOfTxs = Integer.parseInt(sct.getNbOfTxs().getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((pmtTpInf = sct.getPmtTpInf()) != null) {
                    CCTTicketWrapper.this.serviceLevels.add(StringUtils.checkNullAndTrim(pmtTpInf.getSvcLvl().getCd().getValue()));
                    if (pmtTpInf.getCtgyPurp() != null) {
                        CCTTicketWrapper.this.checkPaymentCategoryForSalary(pmtTpInf.getCtgyPurp().getCd().getValue());
                    }
                }
                String bic = sct.getDbtrAgt().getFinInstnId().getBIC().getValue();
                String iban = sct.getDbtrAcct().getId().getIBAN().getValue();
                de.businesslogics.format.sepa.pain00100203.ActiveOrHistoricCurrencyCode cc = sct.getDbtrAcct().getCcy();
                String string = accCurrency = cc == null ? null : cc.getValue();
                if (this.bundesBank && (p = sct.getUltmtDbtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && (goic = oic.getChoice1().getOthr()) != null) {
                    iban = goic.getId().getValue();
                    bic = null;
                }
                this.currentTicket2.endPaymentInstructionInformation(sct.getPmtInfId().getValue(), bic, iban, accCurrency, sct.getDbtr().getNm().getValue(), sct.getReqdExctnDt().getDate(), ctrlSum, nbOfTxs);
                CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
                this.list2ToClear = null;
            } else if (element instanceof de.businesslogics.format.sepa.pain00100203.CreditTransferTransactionInformationSCT) {
                de.businesslogics.format.sepa.pain00100203.CreditTransferTransactionInformationSCT sct = (de.businesslogics.format.sepa.pain00100203.CreditTransferTransactionInformationSCT)element;
                this.currentTicket2.handleTransaction(sct.getAmt().getInstdAmt().getValue());
                if (sct.getPurp() != null) {
                    CCTTicketWrapper.this.checkPurposeCodeForSalary(sct.getPurp().getCd().getValue());
                }
                this.list2ToClear.clear();
            } else if (element instanceof de.businesslogics.format.sepa.pain00100203.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                de.businesslogics.format.sepa.pain00100203.GroupHeaderSCT grpHdr = ((de.businesslogics.format.sepa.pain00100203.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
                CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
                if (grpHdr.getCtrlSum() != null) {
                    CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
                }
                try {
                    CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
                }
                catch (Exception e) {
                    CCTTicketWrapper.this.numberOfTxs = -1L;
                }
                if (grpHdr.getInitgPty() != null) {
                    de.businesslogics.format.sepa.pain00100203.GenericOrganisationIdentification1 gId;
                    OrganisationIdentificationSEPAChoice org;
                    de.businesslogics.format.sepa.pain00100203.PartySEPAChoice id;
                    if (grpHdr.getInitgPty().getNm() != null) {
                        CCTTicketWrapper.this.initiatorName = grpHdr.getInitgPty().getNm().getValue();
                    }
                    if ((id = grpHdr.getInitgPty().getId()) != null && (org = id.getChoice1().getOrgId()) != null && (gId = org.getChoice1().getOthr()) != null && gId.getId() != null) {
                        CCTTicketWrapper.this.initiatorId = gId.getId().getValue();
                    }
                }
            } else if (element instanceof de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT) {
                GenericOrganisationIdentification1 goic;
                de.businesslogics.format.sepa.pain00100303.OrganisationIdentificationSEPAChoice oic;
                PartySEPAChoice pc;
                PartyIdentificationSEPA1 p;
                String accCurrency;
                de.businesslogics.format.sepa.pain00100303.PaymentTypeInformationSCT1 pmtTpInf;
                de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT sct = (de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT)element;
                BigDecimal ctrlSum = null;
                if (sct.getCtrlSum() != null) {
                    ctrlSum = sct.getCtrlSum().getValue();
                }
                int nbOfTxs = -1;
                if (sct.getNbOfTxs() != null) {
                    try {
                        nbOfTxs = Integer.parseInt(sct.getNbOfTxs().getValue());
                    }
                    catch (Exception gId) {
                        // empty catch block
                    }
                }
                if ((pmtTpInf = sct.getPmtTpInf()) != null) {
                    CCTTicketWrapper.this.serviceLevels.add(StringUtils.checkNullAndTrim(pmtTpInf.getSvcLvl().getCd().getValue()));
                    if (pmtTpInf.getCtgyPurp() != null) {
                        CCTTicketWrapper.this.checkPaymentCategoryForSalary(pmtTpInf.getCtgyPurp().getCd().getValue());
                    }
                }
                String sctBic = null;
                BICIdentifier bic = sct.getDbtrAgt().getFinInstnId().getChoice1().getBIC();
                if (bic != null) {
                    sctBic = bic.getValue();
                }
                String iban = sct.getDbtrAcct().getId().getIBAN().getValue();
                ActiveOrHistoricCurrencyCode cc = sct.getDbtrAcct().getCcy();
                String string = accCurrency = cc == null ? null : cc.getValue();
                if (this.bundesBank && (p = sct.getUltmtDbtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && (goic = oic.getChoice1().getOthr()) != null) {
                    iban = goic.getId().getValue();
                    sctBic = null;
                }
                this.currentTicket2.endPaymentInstructionInformation(sct.getPmtInfId().getValue(), sctBic, iban, accCurrency, sct.getDbtr().getNm().getValue(), sct.getReqdExctnDt().getDate(), ctrlSum, nbOfTxs);
                CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
                this.list2ToClear = null;
            } else if (element instanceof de.businesslogics.format.sepa.pain00100303.CreditTransferTransactionInformationSCT) {
                de.businesslogics.format.sepa.pain00100303.CreditTransferTransactionInformationSCT sct = (de.businesslogics.format.sepa.pain00100303.CreditTransferTransactionInformationSCT)element;
                this.currentTicket2.handleTransaction(sct.getAmt().getInstdAmt().getValue());
                if (sct.getPurp() != null) {
                    CCTTicketWrapper.this.checkPurposeCodeForSalary(sct.getPurp().getCd().getValue());
                }
                this.list2ToClear.clear();
            } else if (element instanceof de.businesslogics.format.sepa.pain00100303.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                de.businesslogics.format.sepa.pain00100303.GroupHeaderSCT grpHdr = ((de.businesslogics.format.sepa.pain00100303.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
                CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
                if (grpHdr.getCtrlSum() != null) {
                    CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
                }
                try {
                    CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
                }
                catch (Exception e) {
                    CCTTicketWrapper.this.numberOfTxs = -1L;
                }
                if (grpHdr.getInitgPty() != null) {
                    GenericOrganisationIdentification1 gId;
                    de.businesslogics.format.sepa.pain00100303.OrganisationIdentificationSEPAChoice org;
                    PartySEPAChoice id;
                    if (grpHdr.getInitgPty().getNm() != null) {
                        CCTTicketWrapper.this.initiatorName = grpHdr.getInitgPty().getNm().getValue();
                    }
                    if ((id = grpHdr.getInitgPty().getId()) != null && (org = id.getChoice1().getOrgId()) != null && (gId = org.getChoice1().getOthr()) != null && gId.getId() != null) {
                        CCTTicketWrapper.this.initiatorId = gId.getId().getValue();
                    }
                }
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1) {
                this.evaluateLogicalFile((de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1)element);
            } else if (element instanceof CreditTransferTransactionInformation1) {
                this.evaluateTransaction((CreditTransferTransactionInformation1)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100102.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                GroupHeader1 grpHdr = ((de.businesslogics.format.iso20022.pain00100102.Document)element).getPain_001_001_02().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3) {
                this.evaluateLogicalFileISO113((de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3)element);
            } else if (element instanceof CreditTransferTransactionInformation10) {
                this.evaluateTransactionISO113((CreditTransferTransactionInformation10)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100103.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                GroupHeader32 grpHdr = ((de.businesslogics.format.iso20022.pain00100103.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstructionInformation1) {
                this.evaluateLogicalFile((PaymentInstructionInformation1)element);
            } else if (element instanceof de.businesslogics.format.stuzza.pain00100102at02.CreditTransferTransactionInformation1) {
                this.evaluateTransaction((de.businesslogics.format.stuzza.pain00100102at02.CreditTransferTransactionInformation1)element);
            } else if (element instanceof de.businesslogics.format.stuzza.pain00100102at02.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                de.businesslogics.format.stuzza.pain00100102at02.GroupHeader1 grpHdr = ((de.businesslogics.format.stuzza.pain00100102at02.Document)element).getPain_001_001_02().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstructionInformation3_CH) {
                this.evaluateLogicalFileCH((PaymentInstructionInformation3_CH)element);
            } else if (element instanceof CreditTransferTransactionInformation10_CH) {
                this.evaluateTransactionCH((CreditTransferTransactionInformation10_CH)element);
            } else if (element instanceof de.businesslogics.format.ch.pain0010010302.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                GroupHeader32_CH grpHdr = ((de.businesslogics.format.ch.pain0010010302.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstruction22) {
                this.evaluateLogicalFileISO118((PaymentInstruction22)element);
            } else if (element instanceof CreditTransferTransaction26) {
                this.evaluateTransactionISO118((CreditTransferTransaction26)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100108.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                GroupHeader48 grpHdr = ((de.businesslogics.format.iso20022.pain00100108.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstruction30) {
                this.evaluateLogicalFileISO119((PaymentInstruction30)element);
            } else if (element instanceof CreditTransferTransaction34) {
                this.evaluateTransactionISO119((CreditTransferTransaction34)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100109.Document) {
                CCTTicketWrapper.this.nameSpace = element.namespace();
                GroupHeader85 grpHdr = ((de.businesslogics.format.iso20022.pain00100109.Document)element).getCstmrCdtTrfInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            }
        }

        @Override
        public void startElement(String uri, String localName, EbicsElement element) {
            if (element instanceof de.businesslogics.format.sepa.pain00100203.CustomerCreditTransferInitiationV03) {
                de.businesslogics.format.sepa.pain00100203.CustomerCreditTransferInitiationV03 v03 = (de.businesslogics.format.sepa.pain00100203.CustomerCreditTransferInitiationV03)element;
                this.list1ToClear = v03.getPmtInfs();
            } else if (element instanceof PaymentInstructionInformationSCT) {
                PaymentInstructionInformationSCT sct = (PaymentInstructionInformationSCT)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
                this.list1ToClear.clear();
            } else if (element instanceof CustomerCreditTransferInitiationV03) {
                CustomerCreditTransferInitiationV03 v03 = (CustomerCreditTransferInitiationV03)element;
                this.list1ToClear = v03.getPmtInfs();
            } else if (element instanceof de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT) {
                de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT sct = (de.businesslogics.format.sepa.pain00100303.PaymentInstructionInformationSCT)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
                this.list1ToClear.clear();
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1) {
                de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1 sct = (de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            } else if (element instanceof PaymentInstructionInformation1) {
                PaymentInstructionInformation1 sct = (PaymentInstructionInformation1)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3) {
                de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3 sct = (de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            } else if (element instanceof PaymentInstructionInformation3_CH) {
                PaymentInstructionInformation3_CH sct = (PaymentInstructionInformation3_CH)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            } else if (element instanceof PaymentInstruction22) {
                PaymentInstruction22 sct = (PaymentInstruction22)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            } else if (element instanceof PaymentInstruction30) {
                PaymentInstruction30 sct = (PaymentInstruction30)element;
                this.list2ToClear = sct.getCdtTrfTxInfs();
                this.currentTicket2 = new CCTSingleTicket();
                this.currentTicket2.startPaymentInstructionInformation(null);
            }
        }

        private void evaluateTransaction(CreditTransferTransactionInformation1 t) {
            de.businesslogics.format.iso20022.pain00100102.CurrencyAndAmount ccyAndAmt = SEPAExtractorV2Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            }
            if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getChoice1().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateTransaction(de.businesslogics.format.stuzza.pain00100102at02.CreditTransferTransactionInformation1 t) {
            CurrencyAndAmount ccyAndAmt = SEPAExtractorV2Stuzza.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), ccyAndAmt.getCcy());
            }
            if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getChoice1().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateTransactionCH(CreditTransferTransactionInformation10_CH t) {
            de.businesslogics.format.ch.pain0010010302.ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV3Ch.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            }
            if (t.getPurp() != null && t.getPurp().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateTransactionISO113(CreditTransferTransactionInformation10 t) {
            ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV3Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            }
            if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getChoice1().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateTransactionISO118(CreditTransferTransaction26 t) {
            de.businesslogics.format.iso20022.pain00100108.ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV8Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            }
            if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getChoice1().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateTransactionISO119(CreditTransferTransaction34 t) {
            de.businesslogics.format.iso20022.pain00100109.ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV9Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
            if (ccyAndAmt != null) {
                this.currentTicket2.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            }
            if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
                CCTTicketWrapper.this.checkPurposeCodeForSalary(t.getPurp().getChoice1().getCd().getValue());
            }
            this.list2ToClear.clear();
        }

        private void evaluateLogicalFile(de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1 lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV2Iso.getBankIdentifier(lf.getDbtrAgt().getFinInstnId().getChoice1());
            String accNumber = SEPAExtractorV2Iso.getAccountIdentifier(lf.getDbtrAcct().getId().getChoice1());
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            de.businesslogics.format.iso20022.pain00100102.CurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdExctnDt().getDate(), null, -1);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFile(PaymentInstructionInformation1 lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV2Stuzza.getBankIdentifier(lf.getDbtrAgt().getFinInstnId().getChoice1());
            String accNumber = SEPAExtractorV2Stuzza.getAccountIdentifier(lf.getDbtrAcct().getId());
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            CurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdExctnDt().getDate(), null, -1);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFileCH(PaymentInstructionInformation3_CH lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV3Ch.getBankIdentifier(lf.getDbtrAgt().getFinInstnId());
            AccountNumberInfo accountNumberInfo = SEPAExtractorV3Ch.getAccountNumberInfo(lf.getDbtrAcct().getId().getChoice1());
            String accNumber = accountNumberInfo != null ? accountNumberInfo.getAccountNumber() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            de.businesslogics.format.ch.pain0010010302.ActiveOrHistoricCurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String serviceLevel = null;
            String localInstrument = null;
            String instructionPriority = null;
            String paymentCategory = null;
            PaymentTypeInformation19_CH pmtTpInf = lf.getPmtTpInf();
            if (pmtTpInf != null) {
                serviceLevel = SEPAExtractorV3Ch.getServiceLevel(pmtTpInf.getSvcLvl());
                localInstrument = SEPAExtractorV3Ch.getLocalInstrument(pmtTpInf.getLclInstrm());
                instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInf.getInstrPrty());
                paymentCategory = SEPAExtractorV3Ch.getPaymentCategory(pmtTpInf.getCtgyPurp());
                CCTTicketWrapper.this.checkPaymentCategoryForSalary(paymentCategory);
            }
            CCTTicketWrapper.this.setPaymentMethod(this.currentTicket2, lf.getPmtMtd().getValue());
            CCTTicketWrapper.this.setServiceLevel(this.currentTicket2, serviceLevel);
            CCTTicketWrapper.this.setLocalInstrument(this.currentTicket2, localInstrument);
            this.currentTicket2.setInstructionPriority(instructionPriority);
            this.currentTicket2.setPaymentCategory(paymentCategory);
            this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdExctnDt().getDate(), ctrlSum, nbOfTxs);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFileISO113(de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3 lf) {
            OrganisationIdentification4 oic;
            Party6Choice pc;
            PartyIdentification32 p;
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV3Iso.getBankIdentifier(lf.getDbtrAgt().getFinInstnId());
            AccountNumberInfo accountNumberInfo = SEPAExtractorV3Iso.getAccountNumberInfo(lf.getDbtrAcct().getId().getChoice1());
            String accNumber = accountNumberInfo != null ? accountNumberInfo.getAccountNumber() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            de.businesslogics.format.iso20022.pain00100103.ActiveOrHistoricCurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String serviceLevel = null;
            String localInstrument = null;
            String instructionPriority = null;
            String paymentCategory = null;
            PaymentTypeInformation19 pmtTpInf = lf.getPmtTpInf();
            if (pmtTpInf != null) {
                serviceLevel = SEPAExtractorV3Iso.getServiceLevel(pmtTpInf.getSvcLvl());
                localInstrument = SEPAExtractorV3Iso.getLocalInstrument(pmtTpInf.getLclInstrm());
                instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInf.getInstrPrty());
                paymentCategory = SEPAExtractorV3Iso.getPaymentCategory(pmtTpInf.getCtgyPurp());
                CCTTicketWrapper.this.checkPaymentCategoryForSalary(paymentCategory);
            }
            CCTTicketWrapper.this.setPaymentMethod(this.currentTicket2, lf.getPmtMtd().getValue());
            CCTTicketWrapper.this.setServiceLevel(this.currentTicket2, serviceLevel);
            CCTTicketWrapper.this.setLocalInstrument(this.currentTicket2, localInstrument);
            this.currentTicket2.setInstructionPriority(instructionPriority);
            this.currentTicket2.setPaymentCategory(paymentCategory);
            if (this.bundesBank && (p = lf.getUltmtDbtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && oic.getOthrs().size() > 0) {
                de.businesslogics.format.iso20022.pain00100103.GenericOrganisationIdentification1 goic = oic.getOthrs().get(0);
                accNumber = goic.getId().getValue();
                bankCode = null;
            }
            this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdExctnDt().getDate(), ctrlSum, nbOfTxs);
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFileISO118(PaymentInstruction22 lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV8Iso.getBankIdentifier(lf.getDbtrAgt().getFinInstnId());
            AccountNumberInfo accountNumberInfo = SEPAExtractorV8Iso.getAccountNumberInfo(lf.getDbtrAcct().getId().getChoice1());
            String accNumber = accountNumberInfo != null ? accountNumberInfo.getAccountNumber() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            de.businesslogics.format.iso20022.pain00100108.ActiveOrHistoricCurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String serviceLevel = null;
            String localInstrument = null;
            String paymentCategory = null;
            de.businesslogics.format.iso20022.pain00100108.PaymentTypeInformation19 pmtTpInf = lf.getPmtTpInf();
            if (pmtTpInf != null) {
                if (pmtTpInf.getSvcLvl() != null && pmtTpInf.getSvcLvl().getChoice1().getCd() != null) {
                    serviceLevel = pmtTpInf.getSvcLvl().getChoice1().getCd().getValue();
                }
                if (pmtTpInf.getLclInstrm() != null && pmtTpInf.getLclInstrm().getChoice1().getCd() != null) {
                    localInstrument = pmtTpInf.getLclInstrm().getChoice1().getCd().getValue();
                }
                if (pmtTpInf.getCtgyPurp() != null && pmtTpInf.getCtgyPurp().getChoice1().getCd() != null) {
                    paymentCategory = pmtTpInf.getCtgyPurp().getChoice1().getCd().getValue();
                    CCTTicketWrapper.this.checkPaymentCategoryForSalary(paymentCategory);
                }
            }
            CCTTicketWrapper.this.setPaymentMethod(this.currentTicket2, lf.getPmtMtd().getValue());
            CCTTicketWrapper.this.setServiceLevel(this.currentTicket2, serviceLevel);
            CCTTicketWrapper.this.setLocalInstrument(this.currentTicket2, localInstrument);
            this.currentTicket2.setPaymentCategory(paymentCategory);
            DateAndDateTimeChoice.DateAndDateTimeChoice_C1 choice = lf.getReqdExctnDt().getChoice1();
            if (choice.getDt() != null) {
                this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, choice.getDt().getDate(), ctrlSum, nbOfTxs);
            } else {
                YYYYMMDDHHMMSS timeStamp = new YYYYMMDDHHMMSS(choice.getDtTm().getDate().getTime());
                this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, timeStamp, ctrlSum, nbOfTxs);
            }
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFileISO119(PaymentInstruction30 lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPAExtractorV9Iso.getBankIdentifier(lf.getDbtrAgt().getFinInstnId());
            AccountNumberInfo accNumberInfo = SEPAExtractorV9Iso.getAccountNumberInfo(lf.getDbtrAcct().getId().getChoice1());
            String accNumber = accNumberInfo != null ? accNumberInfo.getAccountNumber() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getDbtr().getNm());
            de.businesslogics.format.iso20022.pain00100109.ActiveOrHistoricCurrencyCode cc = lf.getDbtrAcct().getCcy();
            String accCurrency = cc == null ? null : cc.getValue();
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String serviceLevel = null;
            String localInstrument = null;
            String instructionPriority = null;
            String paymentCategory = null;
            PaymentTypeInformation26 pmtTpInf = lf.getPmtTpInf();
            if (pmtTpInf != null) {
                serviceLevel = SEPAExtractorV9Iso.getServiceLevel(pmtTpInf.getSvcLvls());
                localInstrument = SEPAExtractorV9Iso.getLocalInstrument(pmtTpInf.getLclInstrm());
                instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInf.getInstrPrty());
                paymentCategory = SEPAExtractorV9Iso.getPaymentCategory(pmtTpInf.getCtgyPurp());
                CCTTicketWrapper.this.checkPaymentCategoryForSalary(paymentCategory);
            }
            CCTTicketWrapper.this.setPaymentMethod(this.currentTicket2, lf.getPmtMtd().getValue());
            CCTTicketWrapper.this.setServiceLevel(this.currentTicket2, serviceLevel);
            CCTTicketWrapper.this.setLocalInstrument(this.currentTicket2, localInstrument);
            this.currentTicket2.setInstructionPriority(instructionPriority);
            this.currentTicket2.setPaymentCategory(paymentCategory);
            DateAndDateTime2Choice.DateAndDateTime2Choice_C1 choice = lf.getReqdExctnDt().getChoice1();
            if (choice.getDt() != null) {
                this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, choice.getDt().getDate(), ctrlSum, nbOfTxs);
            } else {
                YYYYMMDDHHMMSS timeStamp = new YYYYMMDDHHMMSS(choice.getDtTm().getDate().getTime());
                this.currentTicket2.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, timeStamp, ctrlSum, nbOfTxs);
            }
            CCTTicketWrapper.this.singleTickets.add(this.currentTicket2);
            this.list2ToClear = null;
        }

        private void evaluateGroupHeader(GroupHeader1 grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader32 grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader48 grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader85 grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(de.businesslogics.format.stuzza.pain00100102at02.GroupHeader1 grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader32_CH grpHdr) {
            CCTTicketWrapper.this.messageIdentification = grpHdr.getMsgId().getValue();
            CCTTicketWrapper.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                CCTTicketWrapper.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                CCTTicketWrapper.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                CCTTicketWrapper.this.numberOfTxs = -1L;
            }
        }
    }
}

