/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.bcs.core.YYYYMMDDHHMMSS;
import de.businesslogics.format.sepa.CCTTicketI;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.format.sepa.pain00100202.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.sepa.pain00100202.CurrencyCode;
import de.businesslogics.format.sepa.pain00100202.PaymentInstructionInformationSCT;
import de.businesslogics.format.sepa.pain00100202.RestrictedIdentification2;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class CCTSingleTicket
implements CCTTicketI {
    private static final long serialVersionUID = 1L;
    private String paymentInformationIdentification;
    private String debitorBIC;
    private String debitorAccount;
    private transient String debitorAccountCcy;
    private String debitorName;
    private YYMMDD requestedExecutionDate;
    private YYYYMMDDHHMMSS requestedExecutionDateTime;
    private BigDecimal ctrlSum;
    private int numberOfPayments;
    private Currency currency = null;
    private boolean hasUniqueCurrency = true;
    private BigDecimal givenCtrlSum;
    private int givenNumberOfPayments;
    private String paymentMethod;
    private String serviceLevel;
    private String localInstrument;
    private String instructionPriority;
    private String paymentCategory;

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setServiceLevel(String serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public void setInstructionPriority(String instructionPriority) {
        this.instructionPriority = instructionPriority;
    }

    public void setPaymentCategory(String paymentCategory) {
        this.paymentCategory = paymentCategory;
    }

    public void startPaymentInstructionInformation(PaymentInstructionInformationSCT pmtInf) {
        this.ctrlSum = BigDecimal.ZERO;
        this.numberOfPayments = 0;
    }

    public void endPaymentInstructionInformation(PaymentInstructionInformationSCT pmtInf) {
        RestrictedIdentification2 r = pmtInf.getPmtInfId();
        if (r != null) {
            this.paymentInformationIdentification = r.getValue();
        }
        this.debitorBIC = pmtInf.getDbtrAgt().getFinInstnId().getBIC().getValue();
        this.debitorAccount = pmtInf.getDbtrAcct().getId().getIBAN().getValue();
        CurrencyCode cc = pmtInf.getDbtrAcct().getCcy();
        this.debitorAccountCcy = cc != null ? cc.getValue() : null;
        this.debitorName = pmtInf.getDbtr().getNm().getValue();
        this.requestedExecutionDate = pmtInf.getReqdExctnDt().getDate();
    }

    public void endPaymentInstructionInformation(String paymentInformationIdentification, String debitorBIC, String debitorAccount, String debitorAccountCcy, String debitorName, YYMMDD requestedExecutionDate) {
        this.endPaymentInstructionInformation(paymentInformationIdentification, debitorBIC, debitorAccount, debitorAccountCcy, debitorName, requestedExecutionDate, null, -1);
    }

    public void endPaymentInstructionInformation(String paymentInformationIdentification, String debitorBIC, String debitorAccount, String debitorAccountCcy, String debitorName, YYMMDD requestedExecutionDate, BigDecimal givenCtrlSum, int givenNumberOfPayments) {
        this.paymentInformationIdentification = paymentInformationIdentification;
        this.debitorBIC = debitorBIC;
        this.debitorAccount = debitorAccount;
        this.debitorAccountCcy = debitorAccountCcy;
        this.debitorName = debitorName;
        this.requestedExecutionDate = requestedExecutionDate;
        this.givenCtrlSum = givenCtrlSum;
        this.givenNumberOfPayments = givenNumberOfPayments;
    }

    public void endPaymentInstructionInformation(String paymentInformationIdentification, String debitorBIC, String debitorAccount, String debitorAccountCcy, String debitorName, YYYYMMDDHHMMSS requestedExecutionDateTime, BigDecimal givenCtrlSum, int givenNumberOfPayments) {
        this.paymentInformationIdentification = paymentInformationIdentification;
        this.debitorBIC = debitorBIC;
        this.debitorAccount = debitorAccount;
        this.debitorAccountCcy = debitorAccountCcy;
        this.debitorName = debitorName;
        this.requestedExecutionDateTime = requestedExecutionDateTime;
        this.givenCtrlSum = givenCtrlSum;
        this.givenNumberOfPayments = givenNumberOfPayments;
    }

    @Override
    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    @Override
    public String getDebitorAccount() {
        return this.debitorAccount;
    }

    @Override
    @Deprecated
    public Currency getDebitorAccountCcy() {
        if (this.debitorAccountCcy != null) {
            return Currency.getInstance(this.debitorAccountCcy);
        }
        return null;
    }

    @Override
    public String getDebitorBIC() {
        return this.debitorBIC;
    }

    @Override
    public String getDebitorName() {
        return this.debitorName;
    }

    @Override
    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    @Override
    public BigDecimal getGivenCtrlSum() {
        return this.givenCtrlSum;
    }

    @Override
    public int getGivenNumberOfPayments() {
        return this.givenNumberOfPayments;
    }

    public void handleTransaction(CreditTransferTransactionInformationSCT crdt) {
        this.handleTransaction(crdt.getAmt().getInstdAmt().getValue());
    }

    public void handleTransaction(BigDecimal amount) {
        this.ctrlSum = this.ctrlSum.add(amount);
        ++this.numberOfPayments;
    }

    public void handleTransaction(BigDecimal amount, Currency c) {
        this.handleTransaction(amount);
        if (this.currency == null) {
            this.currency = c;
        }
        if (this.currency != null && !this.currency.equals(c)) {
            this.hasUniqueCurrency = false;
        }
    }

    @Override
    public void appendText(Locale locale, StringBuilder buffer) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.Sepa", locale);
        this.appendMost(bundle, locale, buffer);
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
    }

    @Override
    public void appendMost(ResourceBundle bundle, Locale locale, StringBuilder buffer) {
        Object s;
        buffer.append(bundle.getString("MINOR_SEPARATOR"));
        buffer.append("\r\n");
        if (this.paymentInformationIdentification != null) {
            buffer.append(bundle.getString("SAMMLERREFERENZ"));
            buffer.append(this.paymentInformationIdentification);
            buffer.append("\r\n");
        }
        boolean isChequePayment = SEPAPaymentMethod.CHK.name().equals(this.paymentMethod);
        String value = StringUtils.checkNullAndTrim(this.serviceLevel);
        if (!(value.length() <= 0 || GeneralSEPAExtractor.SEPA.equals(value) || GeneralSEPAExtractor.URGP.equals(value) || isChequePayment)) {
            buffer.append(bundle.getString("SERVICE_LEVEL"));
            buffer.append(value);
            buffer.append("\r\n");
        }
        if ((value = StringUtils.checkNullAndTrim(this.localInstrument)).length() > 0) {
            buffer.append(bundle.getString("LOCAL_INSTRUMENT"));
            buffer.append(value);
            buffer.append("\r\n");
        }
        if ((value = StringUtils.checkNullAndTrim(this.instructionPriority)).length() > 0) {
            buffer.append(bundle.getString("INSTRUCTION_PRIORITY"));
            buffer.append(value);
            buffer.append("\r\n");
        }
        if ((value = StringUtils.checkNullAndTrim(this.paymentCategory)).length() > 0) {
            buffer.append(bundle.getString("PAYMENT_CATEGORY"));
            buffer.append(value);
            buffer.append("\r\n");
        }
        if (this.debitorBIC != null) {
            buffer.append(bundle.getString("BANK_CODE"));
            buffer.append(this.debitorBIC);
            buffer.append("\r\n");
        }
        buffer.append(bundle.getString("KONTONUMMER"));
        buffer.append(this.debitorAccount);
        buffer.append("\r\n");
        if (this.debitorAccountCcy != null) {
            buffer.append(bundle.getString("KONTOWAEHRUNG"));
            buffer.append(this.debitorAccountCcy);
            buffer.append("\r\n");
        }
        if (((String)(s = bundle.getString("AUFTRAGGEBERDATEN") + this.debitorName)).length() > 72) {
            s = ((String)s).substring(0, 72);
        }
        buffer.append((String)s);
        buffer.append("\r\n");
        buffer.append(bundle.getString("ANZAHL_DER_ZAHLUNGSSAETZE"));
        buffer.append(this.numberOfPayments);
        buffer.append("\r\n");
        if (this.hasUniqueCurrency) {
            if (this.currency != null && !this.currency.getCurrencyCode().equals("EUR")) {
                buffer.append(MessageFormat.format(bundle.getString("SUMME_DER_BETRAEGE_AW"), this.currency.getCurrencyCode()));
            } else {
                buffer.append(bundle.getString("SUMME_DER_BETRAEGE"));
            }
        } else {
            buffer.append(bundle.getString("SUMME_DER_BETRAEGE_OW"));
        }
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(locale));
        buffer.append(df.format(this.ctrlSum));
        buffer.append("\r\n");
        if (this.requestedExecutionDate != null) {
            buffer.append(bundle.getString("AUSFUEHRUNGSTERMIN"));
            buffer.append(new SimpleDateFormat(bundle.getString("DATE_FORMAT")).format(this.requestedExecutionDate));
        } else if (this.requestedExecutionDateTime != null) {
            buffer.append(bundle.getString("AUSFUEHRUNGSZEIT"));
            buffer.append(new SimpleDateFormat(bundle.getString("TIMESTAMP_FORMAT")).format(this.requestedExecutionDateTime));
        }
        buffer.append("\r\n");
    }

    @Override
    public String getPaymentInformationIdentification() {
        return this.paymentInformationIdentification;
    }

    @Override
    public YYMMDD getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public boolean hasUniqueCurrency() {
        return this.hasUniqueCurrency;
    }

    public Currency getCurrency() {
        return this.currency;
    }
}

