/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.CustomerInfo;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import java.util.ResourceBundle;

public class VPKResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final CustomerInfo customerInfo;
    private final UserInfo userInfo;
    private final Result result;

    public VPKResult(Result result, CustomerInfo customerInfo, UserInfo userInfo) {
        this.result = result;
        this.userInfo = userInfo;
        this.customerInfo = customerInfo;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{this.result};
    }

    @Override
    public boolean isSuccess() {
        return this.result.equals(Result.INITIALIZE_OK);
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        sb.append(bundle.getString("CUSTOMER"));
        sb.append(this.customerInfo);
        sb.append("\r\n");
        sb.append(bundle.getString("USER"));
        sb.append(this.userInfo);
        sb.append("\r\n");
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }
}

