/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.ProtocolMessage;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.UserInfo;
import java.util.ResourceBundle;

public class UserSignatureMessage
implements ProtocolMessage {
    private static final long serialVersionUID = 1L;
    private static final char[] BLANKS = "        ".toCharArray();
    private Result result;
    private String user;
    private UserInfo userInfo;
    private String bankcode;
    private String accountNumber;

    public UserSignatureMessage(String user, Result result) {
        this.user = user;
        this.result = result;
    }

    @Override
    public void appendText(StringBuilder buffer, ResourceBundle bundle) {
        buffer.append("\r\n");
        buffer.append(bundle.getString("EU_OF"));
        buffer.append(this.user);
        if (this.user.length() < 8) {
            buffer.append(BLANKS, 0, 8 - this.user.length());
        }
        buffer.append(": ");
        if (this.result != null) {
            buffer.append(this.result.toString(bundle.getLocale()));
        } else {
            buffer.append("UNKNOWN");
        }
        if (this.userInfo != null) {
            buffer.append("\r\n");
            buffer.append(bundle.getString("USER"));
            buffer.append(this.userInfo);
        }
        if (this.bankcode != null) {
            buffer.append("\r\n");
            buffer.append(bundle.getString("BANKCODE"));
            buffer.append(this.bankcode);
        }
        if (this.accountNumber != null) {
            buffer.append("\r\n");
            buffer.append(bundle.getString("ACCOUNTNUMBER"));
            buffer.append(this.accountNumber);
        }
    }

    public Result getResult() {
        return this.result;
    }

    public String getUser() {
        return this.user;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getBankcode() {
        return this.bankcode;
    }

    public void setBankcode(String bankcode) {
        this.bankcode = bankcode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }
}

