/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.SimpleTicket;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnparsedResultInfo
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private static final Result[] MY_RESULTS = new Result[]{Result.OK2};
    private final SimpleTicket ticket;

    UnparsedResultInfo(SimpleTicket ticket) {
        this.ticket = ticket;
    }

    @Override
    public Result getResult() {
        return Result.OK2;
    }

    @Override
    public Result[] getResults() {
        return MY_RESULTS;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public void appendText(StringBuilder buffer, ResourceBundle bundle) {
        buffer.append(this.ticket.toString());
    }

    public String toString() {
        return this.ticket.toString();
    }

    public static OrderInfo guessOrderInfo(String input) {
        Pattern p = Pattern.compile(".*Auftrag\\s+: (.*)([A-Z0-9]{3}?) ([A-Z0-9]{4}?).*", 32);
        Matcher m = p.matcher(input);
        if (m.matches()) {
            OrderInfo info = new OrderInfo(m.group(2), m.group(3));
            info.setOrderTypeDescription(m.group(1));
            return info;
        }
        return null;
    }

    public static void main(String[] args) {
        String s = "09.09.08 10:57:03     Weiterverarbeitung HOST\n     Hostname   : COMBAFFM\n     Auftrag    : Eilauftrag Inlandszahlungsverkehr senden   DTE A0TI\n     Dies ist keine Bestaetigung einer evtl. notwendigen Disposition\n     durch Ihre kontofuehrende Geschaeftsstelle und/oder Ausfuehrung\n     des Auftrages.";
        OrderInfo info = UnparsedResultInfo.guessOrderInfo(s);
        if (info == null) {
            System.out.println("null");
        } else {
            System.out.println(info.toString());
        }
    }
}

