/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import java.util.Locale;
import java.util.ResourceBundle;

public class TransferResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final boolean compression;
    private final boolean encryption;
    private final OrderInfo reference;
    private final Result result;
    private final UserInfo userInfo;
    private final String customerId;
    private Result additionalResult = null;
    private String filename = null;
    private DisplayMessage ticket;
    private boolean hideComEnc = false;

    public TransferResult(Result mainResult, OrderInfo reference, String customerId, UserInfo userInfo, boolean encryption, boolean compression) {
        this.result = mainResult;
        this.reference = reference;
        this.customerId = customerId;
        this.userInfo = userInfo;
        this.encryption = encryption;
        this.compression = compression;
    }

    public TransferResult(Result mainResult, OrderInfo reference, String customerId, UserInfo userInfo, Boolean encryption, Boolean compression) {
        this.result = mainResult;
        this.reference = reference;
        this.customerId = customerId;
        this.userInfo = userInfo;
        this.encryption = encryption != null ? encryption : false;
        this.compression = compression != null ? compression : false;
        this.hideComEnc = compression == null && encryption == null;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.OK;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public Result getAdditionalResult() {
        return this.additionalResult;
    }

    public void setAdditionalResult(Result additionalResult) {
        this.additionalResult = additionalResult;
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    public void setTicket(DisplayMessage ticket) {
        this.ticket = ticket;
    }

    public OrderInfo getReference() {
        return this.reference;
    }

    @Override
    public Result[] getResults() {
        Result[] r = null;
        if (this.hideComEnc) {
            r = new Result[this.additionalResult == null ? 1 : 2];
            r[0] = this.result;
            if (this.additionalResult != null) {
                r[1] = this.additionalResult;
            }
        } else {
            r = new Result[this.additionalResult == null ? 3 : 4];
            r[0] = this.result;
            r[1] = this.encryption ? Result.ENCRYPTED : Result.UNENCRYPTED;
            Result result = r[2] = this.compression ? Result.COMPRESSED : Result.UNCOMPRESSED;
            if (this.additionalResult != null) {
                r[3] = this.additionalResult;
            }
        }
        return r;
    }

    public boolean isFinalSuccess() {
        return this.isSuccess() && Result.FINISHED_MANUAL_RELEASE.equals(this.additionalResult);
    }

    public boolean isEncrypted() {
        return this.encryption;
    }

    public boolean isCompressed() {
        return this.compression;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        Locale locale = bundle.getLocale();
        if (this.reference != null) {
            sb.append(bundle.getString("REFERENCE"));
            this.reference.append(sb);
            sb.append("\r\n");
        }
        if (this.customerId != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.customerId);
            sb.append("\r\n");
        }
        if (this.userInfo.toString().length() > 0) {
            sb.append(bundle.getString("USER"));
            sb.append(this.userInfo);
            sb.append("\r\n");
        }
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (!this.hideComEnc) {
            sb.append("\r\n                      ");
            sb.append((this.encryption ? Result.ENCRYPTED : Result.UNENCRYPTED).toString(locale));
            sb.append("\r\n                      ");
            sb.append((this.compression ? Result.COMPRESSED : Result.UNCOMPRESSED).toString(locale));
        }
        if (this.additionalResult != null) {
            sb.append("\r\n                      ");
            sb.append(this.additionalResult.toString(locale));
        }
        if (this.filename != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("FILENAME"));
            DisplayResult.appendFilename(sb, this.filename);
        }
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }

    public void setHideComEnc(boolean hideComEnc) {
        this.hideComEnc = hideComEnc;
    }
}

