/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import de.businesslogics.format.ptk2.UserSignatureMessage;
import java.util.ResourceBundle;

public class SignatureResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;
    private final String filename;
    private final DisplayMessage ticket;
    private final UserInfo[] userInfos;
    private final UserSignatureMessage[] messages;
    private final boolean ds;
    private Result[] additionalResults = null;
    static final UserSignatureMessage[] EMPTY_MESSAGES = new UserSignatureMessage[0];

    public SignatureResult(UserInfo[] userInfos, Result result, UserSignatureMessage[] messages, String filename, DisplayMessage ticket, boolean ds) {
        this.userInfos = userInfos;
        this.result = result;
        this.messages = messages == null ? EMPTY_MESSAGES : messages;
        this.filename = filename;
        this.ticket = ticket;
        this.ds = ds;
    }

    public boolean isDSRequired() {
        return this.ds;
    }

    public UserSignatureMessage[] getMessages() {
        return this.messages;
    }

    public UserInfo[] getUserInfos() {
        return this.userInfos;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        int i;
        int l = this.messages.length + 1;
        if (this.additionalResults != null) {
            l += this.additionalResults.length;
        }
        Result[] r = new Result[l];
        r[0] = this.result;
        l = 1;
        if (this.additionalResults != null) {
            for (i = 0; i < this.additionalResults.length; ++i) {
                r[l] = this.additionalResults[i];
                ++l;
            }
        }
        for (i = 0; i < this.messages.length; ++i) {
            UserSignatureMessage msg = this.messages[i];
            r[l] = msg.getResult();
            ++l;
        }
        return r;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isSuccess() {
        return Result.SIGNATURES_OK.equals(this.result) || Result.FINISHED_MANUAL_RELEASE.equals(this.result);
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    public Result[] getAdditionalResults() {
        return this.additionalResults;
    }

    public void setAdditionalResults(Result[] additionalResults) {
        this.additionalResults = additionalResults;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        if (this.userInfos != null && this.userInfos.length > 0) {
            String USER = bundle.getString("USER");
            for (int i = 0; i < this.userInfos.length; ++i) {
                sb.append(USER);
                sb.append(this.userInfos[i]);
                sb.append("\r\n");
            }
        }
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (this.additionalResults != null) {
            for (int i = 0; i < this.additionalResults.length; ++i) {
                sb.append("\r\n");
                sb.append("         ");
                sb.append(this.additionalResults[i].toString(bundle.getLocale()));
            }
        }
        for (int i = 0; i < this.messages.length; ++i) {
            this.messages[i].appendText(sb, bundle);
        }
        if (this.filename != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("FILENAME"));
            DisplayResult.appendFilename(sb, this.filename);
        }
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }
}

