/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.util.LocalizableString;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Result
implements Serializable,
LocalizableString {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Result> instances = new HashMap<Integer, Result>();
    public static final Result OK = new Result(1, "OK");
    public static final Result CANCEL = new Result(2, "CANCEL");
    public static final Result UNENCRYPTED = new Result(3, "UNENCRYPTED");
    public static final Result ENCRYPTED = new Result(4, "ENCRYPTED");
    public static final Result UNCOMPRESSED = new Result(6, "UNCOMPRESSED");
    public static final Result COMPRESSED = new Result(5, "COMPRESSED");
    public static final Result NO_DATA_AVAILABLE = new Result(7, "NO_DATA_AVAILABLE");
    public static final Result DATAFILE_NOT_AVAILABLE = new Result(22, "DATAFILE_NOT_AVAILABLE");
    public static final Result SIGFILE_NOT_AVAILABLE = new Result(23, "SIGFILE_NOT_AVAILABLE");
    public static final Result SIGNATURES_OK = new Result(24, "SIGNATURES_OK");
    public static final Result SIGNATURES_NOK = new Result(25, "SIGNATURES_NOK");
    public static final Result MULTIPLE_SIGNATURE = new Result(26, "MULTIPLE_SIGNATURE");
    public static final Result NO_SIGN_PERMISSION = new Result(27, "NO_SIGN_PERMISSION");
    public static final Result SIGNATURE_WRONG = new Result(28, "SIGNATURE_WRONG");
    public static final Result IDENTICAL_SIGNATURE = new Result(29, "IDENTICAL_SIGNATURE");
    public static final Result WRONG_PK_VERSION = new Result(30, "WRONG_PK_VERSION");
    public static final Result NO_PK = new Result(31, "NO_PK");
    public static final Result PK_NOT_RELEASED = new Result(32, "PK_NOT_RELEASED");
    public static final Result MISSING_EU = new Result(33, "MISSING_EU");
    public static final Result ORIGFILE_DIFFER = new Result(34, "ORIGFILE_DIFFER");
    public static final Result FATAL_ERROR = new Result(35, "FATAL_ERROR");
    public static final Result WRONG_EU_FILE = new Result(36, "WRONG_EU_FILE");
    public static final Result INSUFFICIENT_PERMISSION = new Result(37, "INSUFFICIENT_PERMISSION");
    @Deprecated
    public static final Result DS_ENTRY = new Result(38, "DS_ENTRY");
    public static final Result PROCESSING_DENIED = new Result(44, "PROCESSING_DENIED");
    public static final Result ERROR_DECOMPRESSION = new Result(51, "ERROR_DECOMPRESSION");
    public static final Result FILE_NOT_DISPLAYABLE = new Result(52, "FILE_NOT_DISPLAYABLE");
    public static final Result ERROR_DECRYPTION = new Result(53, "ERROR_DECRYPTION");
    public static final Result WRONG_CONTENT = new Result(54, "WRONG_CONTENT");
    public static final Result FINISHED_MANUAL_RELEASE = new Result(57, "FINISHED_MANUAL_RELEASE");
    public static final Result TRANSMISSION_INCORRECT = new Result(58, "TRANSMISSION_INCORRECT");
    public static final Result ORDER_DELETED = new Result(56, "ORDER_DELETED");
    public static final Result NO_ACCOUNT_PERMISSION = new Result(71, "NO_ACCOUNT_PERMISSION");
    public static final Result LIMIT_EXCEEDED = new Result(72, "LIMIT_EXCEEDED");
    public static final Result OK2 = new Result(100, "OK2");
    public static final Result USER_NOT_INITIALIZED = new Result(101, "USER_NOT_INITIALIZED");
    public static final Result USER_NOT_RELEASED = new Result(102, "USER_NOT_RELEASED");
    public static final Result USER_LOCKED = new Result(103, "USER_LOCKED");
    public static final Result USER_UNKNOWN = new Result(104, "USER_UNKNOWN");
    public static final Result INITIALIZE_OK = new Result(105, "INITIALIZE_OK");
    public static final Result DS_ENTRY_OK = new Result(47, "DS_ENTRY_OK");
    public static final Result DS_ENTRY_HANDOVER = new Result(46, "DS_ENTRY_HANDOVER");
    @Deprecated
    public static final Result DS_ENTRY_HANDOVER_OK = new Result(106, "DS_ENTRY_HANDOVER_OK");
    public static final Result DS_FINISH_OK = new Result(107, 45, "DS_FINISH_OK");
    public static final Result DS_CANCEL_OK = new Result(108, 42, "DS_CANCEL_OK");
    public static final Result DS_CANCEL_NOK = new Result(43, 43, "DS_CANCEL_NOK");
    public static final Result INITIALIZE_CANCELED = new Result(109, "INITIALIZE_CANCELED");
    public static final Result ORDER_CLEANUP = new Result(110, "ORDER_CLEANUP");
    public static final Result MANUALLY_RELEASED = new Result(111, "MANUALLY_RELEASED");
    public static final Result MANUALLY_DEACTIVATED = new Result(112, "MANUALLY_DEACTIVATED");
    public static final Result WRONG_CONTENT_OR_SIZE = new Result(113, "WRONG_CONTENT_OR_SIZE");
    public static final Result UNKNOWN_CURRENCY = new Result(114, "UNKNOWN_CURRENCY");
    @Deprecated
    public static final Result INVALID_ORDER_TYPE = new Result(115, "INVALID_ORDER_TYPE");
    public static final Result DUPLICATED_FILE = new Result(116, "DUPLICATED_FILE");
    public static final Result SRZ_SPLITTED = new Result(117, "SRZ_SPLITTED");
    public static final Result CERTIFICATE_NOT_VALID_YET = new Result(118, "CERTIFICATE_NOT_VALID_YET");
    public static final Result CERTIFICATE_UNKNOWN_CA = new Result(119, "CERTIFICATE_UNKNOWN_CA");
    public static final Result CERTIFICATE_EXPIRED = new Result(120, "CERTIFICATE_EXPIRED");
    public static final Result CERTIFICATE_REVOKED = new Result(121, "CERTIFICATE_REVOKED");
    public static final Result VOP_PRELIMINARY_SIGNATURE = new Result(122, "VOP_PRELIMINARY_SIGNATURE");
    private transient String rbkey;
    private int id;
    private transient int ptkId;

    private Result(int id, String rbkey) {
        this(id, id, rbkey);
    }

    private Result(int id, int ptkId, String rbkey) {
        this.id = id;
        this.ptkId = ptkId;
        this.rbkey = rbkey;
        if (instances.put(id, this) != null) {
            throw new RuntimeException("Duplicate instance " + id);
        }
    }

    public static Result getInstance(int id) {
        return instances.get(id);
    }

    private Object readResolve() {
        return Result.getInstance(this.id);
    }

    public int getId() {
        return this.id;
    }

    public int getPTKId() {
        return this.ptkId;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    @Override
    public String toString(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("de.businesslogics.format.ptk2.Result", locale);
        String toReturn = rb.getString(this.rbkey);
        if (toReturn != null && toReturn.length() > 63) {
            return toReturn.substring(0, 63);
        }
        return toReturn;
    }

    public static Collection<Result> getInstances() {
        return instances.values();
    }
}

