/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.bcs.core.YYYYMMDDHHMMSS;
import de.businesslogics.format.ptk2.AccountCheckResult;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.AdditionalInfoResult;
import de.businesslogics.format.ptk2.CustomerInfo;
import de.businesslogics.format.ptk2.DSCancelResult;
import de.businesslogics.format.ptk2.DSEntryResult;
import de.businesslogics.format.ptk2.DSFinishResult;
import de.businesslogics.format.ptk2.DSSignatureResult;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.ExpirationResult;
import de.businesslogics.format.ptk2.INIResult;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.PTKEnumeration;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.SignatureResult;
import de.businesslogics.format.ptk2.SimpleTicket;
import de.businesslogics.format.ptk2.TransferResult;
import de.businesslogics.format.ptk2.UnparsedAction;
import de.businesslogics.format.ptk2.UnparsedResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import de.businesslogics.format.ptk2.UserSignatureMessage;
import de.businesslogics.format.ptk2.VPKResult;
import de.businesslogics.license.UnsignedJarLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PTKParser
implements PTKEnumeration {
    private static final Logger LOGGER;
    private static final boolean TRACE_RESULTINFO = true;
    private static Pattern ACCOUNTNUMBER;
    private static Pattern BANKCODE;
    private static Pattern TIMESTAMP;
    private static Pattern NUMBER;
    private static Pattern HOSTNAME;
    private static Pattern ORDERINFO;
    private static Pattern ORDERINFO2;
    private static Pattern SUBMITTER;
    private static Pattern USER;
    private static Pattern USER_SIGNATURE_MESSAGE;
    private static Pattern USER_SIGNATURE_MESSAGE2;
    private static Pattern RESULT;
    private static Pattern NEXT_RESULT;
    private static Pattern FILENAME;
    private static Pattern REFERENCE;
    private static Pattern CUSTOMER;
    private static Pattern BCS_ID;
    private static Pattern SEP_LINE;
    private static String NEWLINE;
    private static Pattern TO_IGNORE;
    private LineNumberReader reader;
    private String nextStartLine = null;

    public PTKParser() {
    }

    public PTKParser(InputStream in) throws IOException {
        this.reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
    }

    public PTKParser(Reader reader) {
        this.reader = new LineNumberReader(reader);
    }

    @Deprecated
    public PTKEntry PTKEntry() throws IOException, ParseException {
        return this.nextEntry();
    }

    @Override
    public PTKEntry nextEntry() throws IOException, ParseException {
        LinkedList<String> copy;
        ResultInfo result;
        OrderInfo orderInfo;
        String host;
        Action a;
        YYYYMMDDHHMMSS ts;
        LinkedList<String> block;
        while (true) {
            String line;
            boolean found;
            block = new LinkedList<String>();
            if (this.nextStartLine == null) {
                found = false;
                do {
                    if ((line = this.reader.readLine()) == null) {
                        found = true;
                        continue;
                    }
                    if (TIMESTAMP.matcher(line).matches()) {
                        found = true;
                        block.add(line);
                        continue;
                    }
                    if (line.trim().length() == 0) continue;
                    LOGGER.info("unknown line: \n" + line);
                } while (!found);
            } else {
                block.add(this.nextStartLine);
                this.nextStartLine = null;
            }
            found = false;
            do {
                if ((line = this.reader.readLine()) == null) {
                    found = true;
                    continue;
                }
                if (TIMESTAMP.matcher(line).matches()) {
                    found = true;
                    this.nextStartLine = line;
                    continue;
                }
                block.add(line);
            } while (!found);
            if (block.isEmpty()) {
                this.reader.close();
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
            ts = new YYYYMMDDHHMMSS(sdf.parse(((String)block.get(0)).substring(0, 17)).getTime());
            a = PTKParser.getAction(((String)block.get(0)).substring(17).trim());
            if (a == null) continue;
            host = null;
            orderInfo = null;
            result = null;
            copy = new LinkedList<String>(block);
            copy.remove(0);
            if (!a.equals(Action.ADDITIONAL_INFO)) {
                host = this.getHost(block, a, copy);
                orderInfo = this.getOrderInfo(a, block, orderInfo, copy);
            }
            if ((result = this.findResult(a, copy)) != null || a instanceof UnparsedAction && host != null && orderInfo != null) break;
        }
        if (result == null) {
            StringBuilder b = new StringBuilder();
            for (String s : copy) {
                PTKParser.appendTicketLine(b, s);
            }
            result = new UnparsedResultInfo(PTKParser.getTicket(b));
        }
        return new PTKEntry(ts, a, host, orderInfo, result, block);
    }

    public PTKEntry getEntry(String[] sArr) throws ParseException {
        LinkedList<String> block = new LinkedList<String>();
        for (String s : sArr) {
            block.add(s);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
        YYYYMMDDHHMMSS ts = new YYYYMMDDHHMMSS(sdf.parse(((String)block.get(0)).substring(0, 17)).getTime());
        Action a = PTKParser.getAction(((String)block.get(0)).substring(17).trim());
        if (a == null) {
            return null;
        }
        String host = null;
        OrderInfo orderInfo = null;
        ResultInfo result = null;
        LinkedList<String> copy = new LinkedList<String>(block);
        copy.remove(0);
        if (!a.equals(Action.ADDITIONAL_INFO)) {
            host = this.getHost(block, a, copy);
            orderInfo = this.getOrderInfo(a, block, orderInfo, copy);
        }
        if ((result = this.findResult(a, copy)) != null || a instanceof UnparsedAction && host != null && orderInfo != null) {
            if (result == null) {
                StringBuilder b = new StringBuilder();
                for (String s : copy) {
                    PTKParser.appendTicketLine(b, s);
                }
                result = new UnparsedResultInfo(PTKParser.getTicket(b));
            }
            return new PTKEntry(ts, a, host, orderInfo, result, block);
        }
        return null;
    }

    private OrderInfo getOrderInfo(Action a, LinkedList<String> block, OrderInfo orderInfo, LinkedList<String> copy) throws ParseException {
        Matcher m = PTKParser.getMatcher(copy, ORDERINFO);
        if (m != null) {
            orderInfo = PTKParser.getOrderInfo(m);
        } else {
            m = PTKParser.getMatcher(copy, ORDERINFO2);
            if (m != null) {
                orderInfo = PTKParser.getOrderInfo2(m);
            } else {
                if (a instanceof UnparsedAction) {
                    return null;
                }
                throw new ParseException("ORDER line not found\n" + PTKParser.getAll(block), this.reader.getLineNumber());
            }
        }
        return orderInfo;
    }

    private String getHost(LinkedList<String> block, Action a, LinkedList<String> copy) throws ParseException {
        Matcher m = PTKParser.getMatcher(copy, HOSTNAME);
        if (m == null) {
            if (!(a instanceof UnparsedAction)) {
                throw new ParseException("HOST line not found\n" + PTKParser.getAll(block), this.reader.getLineNumber());
            }
            return null;
        }
        String host = m.group(1).trim();
        return host;
    }

    private static Matcher getMatcher(List<String> in, Pattern p) {
        while (!in.isEmpty()) {
            String s = in.get(0);
            Matcher m = p.matcher(s);
            if (m.matches()) {
                in.remove(0);
                return m;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return null;
            }
            in.remove(0);
        }
        return null;
    }

    private static INIResult getINIResult(List<String> in) {
        UserInfo user = null;
        Result result = Result.OK2;
        for (String s : in) {
            Matcher m = USER.matcher(s);
            if (m.matches()) {
                user = PTKParser.getUser(m.group(1));
                continue;
            }
            m = RESULT.matcher(s);
            if (!m.matches()) continue;
            result = PTKParser.getResult(m.group(1).trim());
        }
        return new INIResult(result, user);
    }

    private static TransferResult getTransferResult(List<String> in) {
        int l;
        String s2;
        UserInfo user = null;
        Result result = null;
        Boolean encrypted = null;
        Boolean compressed = null;
        String customer = null;
        Result additionalResult = null;
        OrderInfo reference = null;
        StringBuilder ticket = null;
        String filename = null;
        Matcher m = REFERENCE.matcher(in.get(0));
        if (m.matches()) {
            reference = new OrderInfo(m.group(2), m.group(4));
            reference.setOrderTypeDescription(m.group(1));
            in.remove(0);
        }
        if ((m = CUSTOMER.matcher(in.get(0))).matches()) {
            customer = m.group(1).trim();
            in.remove(0);
        }
        if ((m = USER.matcher(in.get(0))).matches()) {
            user = PTKParser.getUser(m.group(1));
            in.remove(0);
        } else {
            user = new UserInfo("");
        }
        m = RESULT.matcher(in.get(0));
        if (m.matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            in.remove(0);
        }
        for (String s2 : in) {
            if (ticket != null) {
                PTKParser.appendTicketLine(ticket, s2);
                continue;
            }
            if (s2.trim().length() == 0) continue;
            if (s2.contains("===")) {
                ticket = new StringBuilder();
                PTKParser.appendTicketLine(ticket, s2);
                continue;
            }
            if (s2.trim().equals("--------------------")) continue;
            m = FILENAME.matcher(s2);
            if (m.matches()) {
                filename = m.group(1);
                continue;
            }
            Result r = PTKParser.getResult(s2.trim());
            if (r == null) {
                LOGGER.info("unknown line in TransferResult: " + s2);
                continue;
            }
            if (Result.COMPRESSED.equals(r)) {
                compressed = true;
                continue;
            }
            if (Result.UNCOMPRESSED.equals(r)) {
                compressed = false;
                continue;
            }
            if (Result.ENCRYPTED.equals(r)) {
                encrypted = true;
                continue;
            }
            if (Result.UNENCRYPTED.equals(r)) {
                encrypted = false;
                continue;
            }
            additionalResult = r;
        }
        if (result == null && additionalResult != null) {
            result = additionalResult;
            additionalResult = null;
        } else if (result == null) {
            result = Result.OK;
        } else if (additionalResult != null && result.getId() == additionalResult.getId()) {
            additionalResult = null;
        }
        if (ticket != null && (l = PTKParser.trimRight(ticket)) >= (s2 = "Weitergereicht zur Freigabe mittels Begleitzettel [57]").length() && s2.equals(ticket.substring(l - s2.length()))) {
            additionalResult = Result.FINISHED_MANUAL_RELEASE;
            ticket.setLength(l - s2.length());
        }
        TransferResult t = new TransferResult(result, reference, customer, user, encrypted, compressed);
        t.setAdditionalResult(additionalResult);
        if (ticket != null) {
            t.setTicket(PTKParser.getTicket(ticket));
        }
        if (filename != null) {
            t.setFilename(filename);
        }
        return t;
    }

    private static AdditionalInfoResult getAdditionalInfoResult(List<String> in) {
        int j;
        String s;
        int start;
        StringBuilder b = new StringBuilder();
        int end = in.size();
        for (start = 0; start < end; ++start) {
            s = in.get(start);
            j = s.length();
            while (--j >= 0 && Character.isWhitespace(s.charAt(j))) {
            }
            if (j >= 0) break;
        }
        while (end > 0) {
            s = in.get(end - 1);
            j = s.length();
            while (--j >= 0 && Character.isWhitespace(s.charAt(j))) {
            }
            if (j >= 0) break;
            --end;
        }
        if (start < end && SEP_LINE.matcher(in.get(start)).matches()) {
            ++start;
        }
        if (start < end && SEP_LINE.matcher(in.get(end - 1)).matches()) {
            --end;
        }
        for (int l = start; l < end; ++l) {
            int i;
            String s2 = in.get(l);
            for (i = s2.length(); i > 0 && Character.isWhitespace(s2.charAt(i - 1)); --i) {
            }
            if (l > start) {
                b.append(NEWLINE);
            }
            b.append(s2, 0, i);
        }
        return new AdditionalInfoResult(b.toString());
    }

    private DSEntryResult getDSEntryResult(List<String> in) throws ParseException {
        Result result = null;
        int i = 0;
        Matcher m = RESULT.matcher(in.get(i));
        while (!m.matches() && i < in.size()) {
            m = RESULT.matcher(in.get(++i));
        }
        if (m.matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            while (++i < in.size() && (m = NEXT_RESULT.matcher(in.get(i))).matches()) {
                Result r2 = PTKParser.getResult(m.group(1).trim());
                if (!Result.DS_ENTRY_OK.equals(r2)) continue;
                result = r2;
                break;
            }
        } else {
            throw new ParseException("RESULT line not found in DSEntryResult.\n" + PTKParser.getAll(in), this.reader.getLineNumber());
        }
        return new DSEntryResult(result);
    }

    private static ExpirationResult getExpirationResult(List<String> in) {
        Result result = null;
        String customer = null;
        Matcher m = CUSTOMER.matcher(in.get(0));
        if (m.matches()) {
            customer = m.group(1);
            in.remove(0);
        }
        m = USER.matcher(in.get(0));
        while (m.matches()) {
            in.remove(0);
            m = USER.matcher(in.get(0));
        }
        m = RESULT.matcher(in.get(0));
        if (m.matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            in.remove(0);
        }
        StringBuilder b = new StringBuilder();
        for (String s : in) {
            PTKParser.appendTicketLine(b, s);
        }
        return new ExpirationResult(result, customer, PTKParser.getTicket(b));
    }

    private static void appendTicketLine(StringBuilder b, String s) {
        int i;
        for (i = s.length(); i > 0 && Character.isWhitespace(s.charAt(i - 1)); --i) {
        }
        if (i == 0) {
            if (b.length() == 0) {
                return;
            }
            b.append("    ");
        } else {
            b.append(s, 0, i);
        }
        b.append(NEWLINE);
    }

    private static int trimRight(StringBuilder b) {
        int i;
        for (i = b.length(); i > 0 && Character.isWhitespace(b.charAt(i - 1)); --i) {
        }
        b.setLength(i);
        return i;
    }

    private static SimpleTicket getTicket(StringBuilder b) {
        int i = PTKParser.trimRight(b);
        if (i == 0) {
            return null;
        }
        return new SimpleTicket(b.substring(0, i), true);
    }

    private static DisplayResult getDisplayResult(List<String> in) {
        Result result = null;
        String filename = null;
        String customerId = null;
        if (in.isEmpty()) {
            return null;
        }
        Matcher m = RESULT.matcher(in.get(0));
        while (!m.matches()) {
            Matcher m2 = CUSTOMER.matcher(in.get(0));
            if (m2.matches()) {
                customerId = m2.group(1).trim();
            }
            in.remove(0);
            if (in.isEmpty()) {
                return null;
            }
            m = RESULT.matcher(in.get(0));
        }
        result = PTKParser.getResult(m.group(1).trim());
        in.remove(0);
        m = PTKParser.getMatcher(in, TO_IGNORE);
        if (!in.isEmpty() && (m = FILENAME.matcher(in.get(0))).matches()) {
            filename = m.group(1).trim();
            in.remove(0);
        }
        StringBuilder b = new StringBuilder();
        for (String s : in) {
            PTKParser.appendTicketLine(b, s);
        }
        DisplayResult res = new DisplayResult(result, filename, PTKParser.getTicket(b));
        res.setCustomerId(customerId);
        return res;
    }

    private static SignatureResult getSignatureResult(List<String> in) {
        Object r;
        String user;
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        Result result = null;
        ArrayList<UserSignatureMessage> messages = null;
        String filename = null;
        SimpleTicket ticket = null;
        ArrayList<Result> additionalResults = new ArrayList<Result>();
        boolean ds = false;
        Matcher m = PTKParser.getMatcher(in, CUSTOMER);
        while (m != null) {
            m = PTKParser.getMatcher(in, CUSTOMER);
        }
        m = PTKParser.getMatcher(in, USER);
        while (m != null) {
            userInfos.add(PTKParser.getUser(m.group(1)));
            m = PTKParser.getMatcher(in, USER);
        }
        m = PTKParser.getMatcher(in, RESULT);
        while (m == null) {
            m = USER_SIGNATURE_MESSAGE2.matcher(in.get(0));
            if (m.matches()) {
                user = m.group(1);
                r = PTKParser.getResult(m.group(2).trim());
                if (messages == null) {
                    messages = new ArrayList<UserSignatureMessage>();
                }
                messages.add(new UserSignatureMessage(user, (Result)r));
            } else {
                System.err.println("unknown line added to user-name: " + in.get(0));
                if (!userInfos.isEmpty()) {
                    UserInfo i = (UserInfo)userInfos.get(userInfos.size() - 1);
                    i.setLongName(i.getLongName() + in.get(0).trim());
                }
            }
            in.remove(0);
            m = PTKParser.getMatcher(in, RESULT);
        }
        result = PTKParser.getResult(m.group(1).trim());
        if (result == null) {
            return null;
        }
        while ((m = PTKParser.getMatcher(in, NEXT_RESULT)) != null) {
            Result r2 = PTKParser.getResult(m.group(1));
            if (r2 == null) {
                in.add(0, m.group());
                break;
            }
            additionalResults.add(r2);
        }
        m = PTKParser.getMatcher(in, TO_IGNORE);
        m = PTKParser.getMatcher(in, FILENAME);
        if (m != null) {
            filename = m.group(1).trim();
        }
        if ((m = PTKParser.getMatcher(in, USER_SIGNATURE_MESSAGE)) != null) {
            if (messages == null) {
                messages = new ArrayList();
            }
            do {
                user = m.group(1);
                r = PTKParser.getResult(m.group(2).trim());
                messages.add(new UserSignatureMessage(user, (Result)r));
            } while ((m = PTKParser.getMatcher(in, USER_SIGNATURE_MESSAGE)) != null);
        }
        StringBuilder b = new StringBuilder();
        for (String s : in) {
            PTKParser.appendTicketLine(b, s);
        }
        ticket = PTKParser.getTicket(b);
        SignatureResult sr = new SignatureResult(userInfos.toArray(new UserInfo[userInfos.size()]), result, messages == null ? null : messages.toArray(new UserSignatureMessage[messages.size()]), filename, ticket, ds);
        if (!additionalResults.isEmpty()) {
            sr.setAdditionalResults(additionalResults.toArray(new Result[additionalResults.size()]));
        }
        return sr;
    }

    private static AccountCheckResult getAccountCheckResult(List<String> in) {
        CustomerInfo customerInfo = null;
        Result result = null;
        String bankcode = null;
        String accountNumber = null;
        Matcher m = CUSTOMER.matcher(in.get(0));
        if (m.matches()) {
            customerInfo = PTKParser.getCustomerInfo(m.group(1));
            in.remove(0);
        }
        m = USER.matcher(in.get(0));
        while (!m.matches()) {
            in.remove(0);
            m = USER.matcher(in.get(0));
        }
        UserInfo userInfo = PTKParser.getUser(m.group(1));
        in.remove(0);
        m = RESULT.matcher(in.get(0));
        if (m.matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            in.remove(0);
        }
        if ((m = PTKParser.getMatcher(in, BANKCODE)) != null) {
            bankcode = m.group(1).trim();
        }
        if ((m = PTKParser.getMatcher(in, ACCOUNTNUMBER)) != null) {
            accountNumber = m.group(1).trim();
        }
        StringBuilder b = new StringBuilder();
        for (String s : in) {
            PTKParser.appendTicketLine(b, s);
        }
        AccountCheckResult toReturn = new AccountCheckResult(result, customerInfo, userInfo, PTKParser.getTicket(b));
        toReturn.setAccount(bankcode, accountNumber);
        return toReturn;
    }

    private static DSSignatureResult getDSSignatureResult(List<String> in) {
        UserInfo userInfo = null;
        Result result = null;
        UserSignatureMessage message = null;
        String filename = null;
        String customer = null;
        Matcher m = PTKParser.getMatcher(in, CUSTOMER);
        if (m != null) {
            customer = m.group(1);
        }
        m = PTKParser.getMatcher(in, SUBMITTER);
        m = PTKParser.getMatcher(in, USER);
        while (m != null) {
            if (userInfo == null) {
                userInfo = PTKParser.getUser(m.group(1));
            }
            m = PTKParser.getMatcher(in, USER);
        }
        m = PTKParser.getMatcher(in, RESULT);
        if (m != null) {
            result = PTKParser.getResult(m.group(1).trim());
        }
        if ((m = PTKParser.getMatcher(in, FILENAME)) != null) {
            filename = m.group(1).trim();
        }
        if ((m = PTKParser.getMatcher(in, USER_SIGNATURE_MESSAGE)) != null) {
            String user = m.group(1);
            Result r = PTKParser.getResult(m.group(2).trim());
            message = new UserSignatureMessage(user, r);
            m = PTKParser.getMatcher(in, USER);
            if (m != null) {
                message.setUserInfo(PTKParser.getUser(m.group(1)));
                m = PTKParser.getMatcher(in, BANKCODE);
                if (m != null) {
                    message.setBankcode(m.group(1).trim());
                }
                if ((m = PTKParser.getMatcher(in, ACCOUNTNUMBER)) != null) {
                    message.setAccountNumber(m.group(1).trim());
                }
            }
        }
        return new DSSignatureResult(result, customer, userInfo, filename, message);
    }

    private static DSFinishResult getDSFinishResult(List<String> in) {
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        Result result = null;
        String customerId = null;
        Matcher m = CUSTOMER.matcher(in.get(0));
        if (m.matches()) {
            customerId = m.group(1);
            in.remove(0);
        }
        m = USER.matcher(in.get(0));
        while (m.matches()) {
            userInfos.add(PTKParser.getUser(m.group(1)));
            in.remove(0);
            m = USER.matcher(in.get(0));
        }
        m = RESULT.matcher(in.get(0));
        if (m.matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            in.remove(0);
        }
        ArrayList<UserSignatureMessage> messages = null;
        m = PTKParser.getMatcher(in, USER_SIGNATURE_MESSAGE);
        if (m != null) {
            messages = new ArrayList<UserSignatureMessage>();
            do {
                String user = m.group(1);
                Result r = PTKParser.getResult(m.group(2).trim());
                messages.add(new UserSignatureMessage(user, r));
            } while ((m = PTKParser.getMatcher(in, USER_SIGNATURE_MESSAGE)) != null);
        }
        StringBuilder b = new StringBuilder();
        for (String s : in) {
            PTKParser.appendTicketLine(b, s);
        }
        return new DSFinishResult(result, customerId, userInfos, messages, (DisplayMessage)PTKParser.getTicket(b));
    }

    private static DSCancelResult getDSCancelResult(List<String> in) {
        UserInfo userInfo = null;
        Result result = null;
        OrderInfo reference = null;
        String filename = null;
        String customerId = null;
        Matcher m = PTKParser.getMatcher(in, REFERENCE);
        if (m != null) {
            reference = PTKParser.getOrderInfo(m);
        }
        if ((m = PTKParser.getMatcher(in, CUSTOMER)) != null) {
            customerId = m.group(1);
        }
        PTKParser.getMatcher(in, SUBMITTER);
        m = PTKParser.getMatcher(in, USER);
        while (m != null) {
            if (userInfo == null) {
                userInfo = PTKParser.getUser(m.group(1));
            }
            m = PTKParser.getMatcher(in, USER);
        }
        m = PTKParser.getMatcher(in, RESULT);
        if (m != null) {
            result = PTKParser.getResult(m.group(1).trim());
        }
        if ((m = PTKParser.getMatcher(in, FILENAME)) != null) {
            filename = m.group(1).trim();
        }
        return new DSCancelResult(result, reference, customerId, userInfo, filename);
    }

    private static VPKResult getVPKResult(List<String> in) {
        UserInfo userInfo = null;
        Result result = null;
        CustomerInfo customerInfo = null;
        Matcher m = CUSTOMER.matcher(in.get(0));
        if (m.matches()) {
            customerInfo = PTKParser.getCustomerInfo(m.group(1));
            in.remove(0);
        }
        if ((m = USER.matcher(in.get(0))).matches()) {
            userInfo = PTKParser.getUser(m.group(1));
            in.remove(0);
        }
        if ((m = RESULT.matcher(in.get(0))).matches()) {
            result = PTKParser.getResult(m.group(1).trim());
            in.remove(0);
        }
        return new VPKResult(result, customerInfo, userInfo);
    }

    private ResultInfo findResult(Action a, List<String> in) throws ParseException {
        switch (a.getId()) {
            case 0: {
                return PTKParser.getINIResult(in);
            }
            case 1: 
            case 2: 
            case 3: {
                return PTKParser.getTransferResult(in);
            }
            case 4: {
                return PTKParser.getSignatureResult(in);
            }
            case 7: {
                return PTKParser.getDisplayResult(in);
            }
            case 8: {
                return this.getDSEntryResult(in);
            }
            case 9: {
                return PTKParser.getDSSignatureResult(in);
            }
            case 10: {
                return PTKParser.getDSFinishResult(in);
            }
            case 11: {
                return PTKParser.getDSCancelResult(in);
            }
            case 12: {
                return PTKParser.getTransferResult(in);
            }
            case 13: {
                return PTKParser.getVPKResult(in);
            }
            case 14: {
                return PTKParser.getAccountCheckResult(in);
            }
            case 15: {
                return PTKParser.getAdditionalInfoResult(in);
            }
            case 16: {
                return PTKParser.getExpirationResult(in);
            }
        }
        LOGGER.info("No resultInfo found in block: " + a.toString());
        return null;
    }

    private static Result getResult(String in) {
        Matcher m = NUMBER.matcher(in);
        if (m.matches()) {
            int i = Integer.parseInt(m.group(1));
            switch (i) {
                case 1: {
                    return Result.OK;
                }
                case 2: {
                    return Result.CANCEL;
                }
                case 3: {
                    return Result.UNENCRYPTED;
                }
                case 4: {
                    return Result.ENCRYPTED;
                }
                case 5: {
                    return Result.COMPRESSED;
                }
                case 6: {
                    return Result.UNCOMPRESSED;
                }
                case 7: {
                    return Result.NO_DATA_AVAILABLE;
                }
                case 22: {
                    return Result.DATAFILE_NOT_AVAILABLE;
                }
                case 23: {
                    return Result.SIGFILE_NOT_AVAILABLE;
                }
                case 24: {
                    return Result.SIGNATURES_OK;
                }
                case 25: {
                    return Result.SIGNATURES_NOK;
                }
                case 26: {
                    return Result.MULTIPLE_SIGNATURE;
                }
                case 27: {
                    return Result.NO_SIGN_PERMISSION;
                }
                case 28: {
                    return Result.SIGNATURE_WRONG;
                }
                case 29: {
                    return Result.IDENTICAL_SIGNATURE;
                }
                case 30: {
                    return Result.WRONG_PK_VERSION;
                }
                case 31: {
                    return Result.NO_PK;
                }
                case 32: {
                    return Result.PK_NOT_RELEASED;
                }
                case 33: {
                    return Result.MISSING_EU;
                }
                case 34: {
                    return Result.ORIGFILE_DIFFER;
                }
                case 35: {
                    return Result.FATAL_ERROR;
                }
                case 36: {
                    return Result.WRONG_EU_FILE;
                }
                case 37: {
                    return Result.INSUFFICIENT_PERMISSION;
                }
                case 38: {
                    return Result.DS_ENTRY;
                }
                case 42: {
                    return Result.DS_CANCEL_OK;
                }
                case 43: {
                    return Result.DS_CANCEL_NOK;
                }
                case 44: {
                    return Result.PROCESSING_DENIED;
                }
                case 45: {
                    return Result.DS_FINISH_OK;
                }
                case 46: {
                    return Result.DS_ENTRY_HANDOVER;
                }
                case 47: {
                    return Result.DS_ENTRY_OK;
                }
                case 51: {
                    return Result.ERROR_DECOMPRESSION;
                }
                case 53: {
                    return Result.ERROR_DECRYPTION;
                }
                case 52: {
                    return Result.FILE_NOT_DISPLAYABLE;
                }
                case 54: {
                    return Result.WRONG_CONTENT;
                }
                case 56: {
                    return Result.ORDER_DELETED;
                }
                case 57: {
                    return Result.FINISHED_MANUAL_RELEASE;
                }
                case 58: {
                    return Result.TRANSMISSION_INCORRECT;
                }
                case 71: {
                    return Result.NO_ACCOUNT_PERMISSION;
                }
                case 72: {
                    return Result.LIMIT_EXCEEDED;
                }
                case 90: {
                    return Result.USER_LOCKED;
                }
                case 91: {
                    return Result.DS_ENTRY;
                }
                case 92: {
                    return Result.DS_FINISH_OK;
                }
            }
        } else {
            if ((in = in.trim()).startsWith("OK") || in.startsWith("Ok")) {
                return Result.OK2;
            }
            if (in.startsWith("Uebertragung in Ordnung") || in.startsWith("Transmission OK")) {
                return Result.OK;
            }
            if (in.startsWith("Teilnehmer initialisieren in Ordnung") || in.startsWith("Verschluesselung initialisieren in Ordnung")) {
                return Result.INITIALIZE_OK;
            }
            if (in.startsWith("Teilnehmer initialisieren abgebrochen")) {
                return Result.INITIALIZE_CANCELED;
            }
            if (in.startsWith("Unterschrift(en) in Ordnung") || in.startsWith("Unterschrift in Ordnung")) {
                return Result.SIGNATURES_OK;
            }
            if (in.startsWith("Auftrag uebergeben, Bearbeitung in Ordnung") || in.startsWith("Auftrag \u00fcbergeben, Bearbeitung in Ordnung")) {
                return Result.DS_ENTRY_HANDOVER_OK;
            }
            if (in.startsWith("Stornierung in Ordnung")) {
                return Result.DS_CANCEL_OK;
            }
            if (in.startsWith("Auftrag weitergegeben zur Verarbeitung")) {
                return Result.DS_FINISH_OK;
            }
            if (in.startsWith("Weitergereicht zur Freigabe mittels Begleitzettel")) {
                return Result.FINISHED_MANUAL_RELEASE;
            }
            if (in.startsWith("Zur EU gehoerige Original-Datei noch nicht uebertragen") || in.startsWith("Zur EU gehoerige Originaldatei noch nicht uebertragen")) {
                return Result.DATAFILE_NOT_AVAILABLE;
            }
            if (in.startsWith("Unterschrift(en) noch nicht uebertragen") || in.startsWith("Uebertragung der EU-Datei steht noch aus")) {
                return Result.SIGFILE_NOT_AVAILABLE;
            }
            if (in.startsWith("Abbruch der Uebertragung")) {
                return Result.CANCEL;
            }
            if (in.startsWith("Unterschrift(en) fehlerhaft")) {
                return Result.SIGNATURES_NOK;
            }
            if (in.startsWith("Datei manuell deaktiviert")) {
                return Result.MANUALLY_DEACTIVATED;
            }
            if (in.startsWith("Datei manuell aktiviert") || in.startsWith("Datei manuell freigegeben")) {
                return Result.MANUALLY_RELEASED;
            }
            if (in.startsWith("Datenuebertragung verschluesselt")) {
                return Result.ENCRYPTED;
            }
            if (in.startsWith("Datenuebertragung unverschluesselt")) {
                return Result.UNENCRYPTED;
            }
            if (in.startsWith("Datenuebertragung komprimiert")) {
                return Result.COMPRESSED;
            }
            if (in.startsWith("Datenuebertragung unkomprimiert")) {
                return Result.UNCOMPRESSED;
            }
            if (in.startsWith("Aufbewahrungsfrist abgelaufen, Vorgang abgebrochen") || in.startsWith("Unvollst\u00e4ndiger Auftrag nach Ablauf der Aufbewahrungsfrist gel\u00f6scht.") || in.startsWith("Unvollstaendigen Auftrag geloescht") || in.startsWith("Unvollstaendige Uebertragung wurde geloescht")) {
                return Result.ORDER_CLEANUP;
            }
            if (in.startsWith("Keine Unterschriftsberechtigung")) {
                return Result.NO_SIGN_PERMISSION;
            }
            if (in.startsWith("User-ID noch nicht freigegeben")) {
                return Result.USER_NOT_RELEASED;
            }
            if (in.startsWith("Teilnehmereintrag nicht vorhanden")) {
                return Result.USER_UNKNOWN;
            }
            if (in.startsWith("Uebertragung abgebrochen, wiederholen")) {
                return Result.CANCEL;
            }
            if (in.startsWith("Unbekannte W\u00e4hrung")) {
                return Result.UNKNOWN_CURRENCY;
            }
            if (in.startsWith("Fehler bei Weiterverarbeitung") || in.startsWith("???")) {
                return Result.FILE_NOT_DISPLAYABLE;
            }
            if (in.startsWith("Aufbau bzw. Groesse der Originaldatei falsch")) {
                return Result.FILE_NOT_DISPLAYABLE;
            }
            if (in.startsWith("Keine Kontoberechtigung")) {
                return Result.NO_ACCOUNT_PERMISSION;
            }
            if (in.startsWith("Keine Berechtigung fuer Auftragsart") || in.startsWith("Keine Berechtigung f. diese Auftragsart") || in.startsWith("Keine Berechtigung f. Auftragsart")) {
                return Result.NO_SIGN_PERMISSION;
            }
            if (in.startsWith("Auftrag wegen zeitlicher Beschraenkung abgelehnt")) {
                return Result.PROCESSING_DENIED;
            }
            if (in.startsWith("Annahme nur zwischen ") && in.endsWith(" Uhr moeglich")) {
                return Result.PROCESSING_DENIED;
            }
            if (in.startsWith("Signaturschl\u00fcssel liegt nicht vor") || in.startsWith("Teilnehmer hat sich noch nicht initialisiert")) {
                return Result.USER_NOT_INITIALIZED;
            }
            if (in.startsWith("User nicht EU-berechtigt")) {
                return Result.NO_SIGN_PERMISSION;
            }
            if (in.startsWith("Unterschrift ist falsch")) {
                return Result.SIGNATURE_WRONG;
            }
            if (in.startsWith("Unzulaessige Auftragsart")) {
                return Result.INVALID_ORDER_TYPE;
            }
            if (in.startsWith("Formalfehler - Doppeleinreichung")) {
                return Result.DUPLICATED_FILE;
            }
            if (in.startsWith("SRZ-Sammelauftrag in Einzelauftraege zerlegt")) {
                return Result.SRZ_SPLITTED;
            }
        }
        Collection<Result> all = Result.getInstances();
        for (Result result : all) {
            if (!in.equals(result.toString(Locale.GERMAN))) continue;
            return result;
        }
        LOGGER.warning("unknown result:" + in);
        return null;
    }

    private static OrderInfo getOrderInfo(Matcher m) {
        OrderInfo toReturn = new OrderInfo(m.group(2), m.group(4));
        toReturn.setOrderTypeDescription(m.group(1));
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OrderInfo getOrderInfo2(Matcher m) {
        String o = m.group(1).trim();
        int pos1 = o.lastIndexOf(32);
        if (pos1 < 0) {
            if (o.length() == 4) {
                return new OrderInfo("   ", o);
            }
            if (o.length() != 3) return null;
            return new OrderInfo(o, "");
        }
        int pos2 = o.lastIndexOf(32, pos1 - 1);
        String orderType = o.substring(pos1 + 1);
        String orderNumber = "";
        String description = null;
        if (pos2 > 0) {
            orderNumber = orderType;
            orderType = o.substring(pos2 + 1, pos1);
            if (orderType.length() != 3 || orderNumber.length() != 4) return null;
            description = o.substring(0, pos2);
        } else if (pos1 == 3) {
            orderType = o.substring(0, pos1);
            orderNumber = o.substring(pos1 + 1);
        } else {
            description = o.substring(0, pos1);
        }
        OrderInfo toReturn = new OrderInfo(orderType, orderNumber);
        toReturn.setOrderTypeDescription(description);
        return toReturn;
    }

    private static CustomerInfo getCustomerInfo(String customer) {
        String c = customer.trim();
        int i = c.indexOf(32);
        if (i < 0) {
            return new CustomerInfo(c, null);
        }
        return new CustomerInfo(c.substring(0, i), c.substring(i));
    }

    private static UserInfo getUser(String user) {
        int i1 = (user = user.trim()).indexOf(32);
        if (i1 < 0) {
            return new UserInfo(user);
        }
        String userId = user.substring(0, i1);
        String customerId = null;
        String longName = null;
        while (i1 + 1 < user.length() && Character.isWhitespace(user.charAt(i1 + 1))) {
            ++i1;
        }
        int i2 = user.indexOf(32, i1 + 1);
        if (i2 >= 0) {
            second = user.substring(i1 + 1, i2);
            if (BCS_ID.matcher(second).matches()) {
                customerId = userId;
                userId = second;
                while (i2 + 1 < user.length() && Character.isWhitespace(user.charAt(i2 + 1))) {
                    ++i2;
                }
                longName = user.substring(i2 + 1).trim();
            }
        } else {
            second = user.substring(i1 + 1);
            if (BCS_ID.matcher(second).matches()) {
                customerId = userId;
                userId = second;
                longName = "";
            }
        }
        if (longName == null) {
            longName = user.substring(i1 + 1).trim();
        }
        UserInfo r = new UserInfo(userId);
        r.setCustomerId(customerId);
        if (longName.length() > 0) {
            r.setLongName(longName);
        }
        return r;
    }

    private static Action getAction(String action) {
        Matcher m = NUMBER.matcher(action);
        Action a = null;
        if (m.matches()) {
            int i = Integer.parseInt(m.group(1));
            switch (i) {
                case 21: {
                    a = Action.SIGNATURE_CHECK;
                    break;
                }
                case 51: {
                    break;
                }
                case 53: {
                    break;
                }
                case 41: {
                    a = Action.DS_CANCEL;
                    break;
                }
                case 38: {
                    a = Action.DS_ENTRY;
                    break;
                }
                case 39: {
                    a = Action.DS_SIGNATURE;
                    break;
                }
                case 40: {
                    a = Action.DS_FINISH;
                    break;
                }
                case 55: {
                    a = Action.ORDER_EXPIRATION;
                    break;
                }
                default: {
                    a = new UnparsedAction(action);
                    break;
                }
            }
        } else if (action.startsWith("Datei zur Bank uebertragen") || action.startsWith("Datei zur Bank \u00fcbertragen") || action.startsWith("File submitted to the bank") || action.startsWith("File transmitted to financial institution") || action.startsWith("File was sent to bank") || action.startsWith("Initialies Senden Public Key") || action.startsWith("Senden Public Key")) {
            a = Action.SEND_FILE;
        } else if (action.startsWith("Datei von Bank abgeholt") || action.startsWith("File collected from the bank") || action.startsWith("File downloaded from the bank") || action.startsWith("Abholen Public Keys der Bank")) {
            a = Action.FETCHED_FILE;
        } else if (action.startsWith("Anzeige Dateiinhalt") || action.startsWith("ANZEIGE DATEIINHALT") || action.startsWith("Dateianzeige") || action.startsWith("Pruefung der Transport-EU") || action.startsWith("Display of the file content")) {
            a = Action.DISPLAY_CONTENT;
        } else if (action.startsWith("ZUSATZINFORMATION") || action.startsWith("Zusatzinformationen") || action.startsWith("Weiterverarbeitung HOST") || action.startsWith("ADDITIONAL INFORMATION") || action.startsWith("Additional Information")) {
            a = Action.ADDITIONAL_INFO;
        } else if (action.startsWith("Unterschrift zur Bank uebertragen") || action.startsWith("Electronic signature submitted to the bank") || action.startsWith("Signature was sent to bank")) {
            a = Action.SEND_SIGNATURE;
        } else if (!action.startsWith("Weiterverarbeitung HOST")) {
            a = action.startsWith("Unterschriftspruefung") || action.startsWith("Signature verification") || action.startsWith("Validierung fehlgeschlagen") ? Action.SIGNATURE_CHECK : (action.startsWith("Abschlu\u00df Unterschriftspr\u00fcfung Verteilte EU") ? Action.DS_FINISH : (action.startsWith("Teilnehmer initialisieren") || action.startsWith("Initiales Senden Public Key") ? Action.INITIALIZE_USER : (action.startsWith("Kunden initialisieren") ? Action.INITIALIZE_CUSTOMER : (action.startsWith("Kontopruefung") ? Action.ACCOUNT_CHECK : (action.startsWith("Weiterleitung zur Verteilten EU") || action.startsWith("Weitergabe zur Verteilten EU") ? Action.DS_ENTRY : (action.startsWith("Unterschrift zu VEU Auftrag") || action.startsWith("Online-Unterschriftspr\u00fcfung zur Verteilten EU") ? Action.DS_SIGNATURE : (action.startsWith("Datei mit EU zur Bank uebertragen") ? Action.SEND_FILE_AND_SIGNATURE : (action.startsWith("Stornierung VEU Auftrag") ? Action.DS_CANCEL : new UnparsedAction(action)))))))));
        }
        if (a == null || a instanceof UnparsedAction) {
            LOGGER.info("unknown action:" + action);
        }
        return a;
    }

    private static String getAll(List<String> in) {
        StringBuffer b = new StringBuffer();
        for (String s : in) {
            b.append(s);
            b.append(NEWLINE);
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File[] f = null;
        f = new File(args[0]).isDirectory() ? new File(args[0]).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".PTK");
            }
        }) : new File[]{new File(args[0])};
        PrintStream out = System.out;
        PrintStream toClose = null;
        if (args.length > 1) {
            toClose = out = new PrintStream(args[1]);
        }
        int count = 0;
        try {
            for (int i = 0; i < f.length; ++i) {
                File file = f[i];
                try (FileInputStream fis = new FileInputStream(file);){
                    PTKParser p = new PTKParser(fis);
                    File fo = new File(file.getParent(), file.getName() + ".txt");
                    try (FileOutputStream fout = new FileOutputStream(fo);){
                        PTKEntry e = p.nextEntry();
                        while (e != null) {
                            ++count;
                            List<String> b = e.getBlock();
                            for (String s : b) {
                                out.println(s);
                            }
                            fout.write(e.toString().getBytes("ISO-8859-1"));
                            fout.write(NEWLINE.getBytes());
                            e = p.nextEntry();
                        }
                        continue;
                    }
                }
            }
        }
        finally {
            if (toClose != null) {
                toClose.close();
            }
        }
        System.out.println("found " + count + " blocks");
    }

    static {
        InputStream in = PTKParser.class.getResourceAsStream("/de/businesslogics/format/ptk2/license");
        if (in != null) {
            new UnsignedJarLicense(in);
        }
        LOGGER = Logger.getLogger(PTKParser.class.getName());
        ACCOUNTNUMBER = Pattern.compile("\\s*(?:Kontonummer|Account)\\s*:\\s(.*)");
        BANKCODE = Pattern.compile("\\s*(?:Bank-Code|Bankcode)\\s*:\\s(.*)");
        TIMESTAMP = Pattern.compile("^[0-3][0-9]\\.[0-1][0-9]\\.[0-9][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9] .*");
        NUMBER = Pattern.compile(".*\\[([0-9][0-9])\\].*");
        HOSTNAME = Pattern.compile("\\s*(?:Hostname|HOSTNAME|Host name|Host Name)\\s*:\\s(.*)");
        ORDERINFO = Pattern.compile("\\s*(?:Auftrag|AUFTRAG|Application|Order|Job)\\s*:\\s(.{42}\\s?)([A-Z0-9]{3})(\\s([A-Z0-9]{4}))?\\s*");
        ORDERINFO2 = Pattern.compile("\\s*(?:Auftrag|AUFTRAG|Application|Order|Job|Assignment)\\s*:\\s(.*)");
        SUBMITTER = Pattern.compile("\\s*Einreicher\\s*:\\s*(.*)");
        USER = Pattern.compile("\\s*(?:Teilnehmer|TEILNEHMER|Einreicher|Participant|User|Attendees|\\s+)\\s*:\\s(.*)");
        USER_SIGNATURE_MESSAGE = Pattern.compile("\\s+EU von ([A-Z0-9]{1,8})\\s*:\\s*(.*)");
        USER_SIGNATURE_MESSAGE2 = Pattern.compile("\\s+([A-Z0-9]{1,8})\\s*:\\s*(.*)");
        RESULT = Pattern.compile("\\s*(?:Ergebnis|ERGEBNIS|Hinweis|Result)\\s*:\\s(.*)");
        NEXT_RESULT = Pattern.compile("(?:            |\\s*(?:Ergebnis|ERGEBNIS|Hinweis|Result)\\s*:\\s)(.*)");
        FILENAME = Pattern.compile("\\s*(?:Dateiname|DATEINAME|File name)\\s*:\\s(.*)");
        REFERENCE = Pattern.compile("\\s*(?:Referenz|Reference)\\s*:\\s(.{42}\\s?)([A-Z0-9]{3})(\\s([A-Z0-9]{4}))?\\s*");
        CUSTOMER = Pattern.compile("\\s*(?:Kunde|Customer)\\s*:\\s(.*)");
        BCS_ID = Pattern.compile("[A-Z0-9]{1,8}");
        SEP_LINE = Pattern.compile("=+");
        NEWLINE = "\r\n";
        TO_IGNORE = Pattern.compile("\\s*ESCHBORN\\s*");
    }
}

