/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.bcs.core.YYYYMMDDHHMMSS;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.util.LocalizableString;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class PTKEntry
implements LocalizableString,
Comparable<PTKEntry>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final YYYYMMDDHHMMSS date;
    private final Action action;
    private final String hostname;
    private final OrderInfo orderInfo;
    private final ResultInfo result;
    private final List<String> block;

    public PTKEntry(YYYYMMDDHHMMSS date, Action action, String hostname, OrderInfo orderInfo, ResultInfo result) {
        this(date, action, hostname, orderInfo, result, null);
    }

    public PTKEntry(YYYYMMDDHHMMSS date, Action action, String hostname, OrderInfo orderInfo, ResultInfo result, List<String> block) {
        this.date = date;
        this.action = action;
        this.hostname = hostname;
        this.orderInfo = orderInfo;
        this.result = result;
        this.block = block;
    }

    public YYYYMMDDHHMMSS getDate() {
        return this.date;
    }

    public Action getAction() {
        return this.action;
    }

    public OrderInfo getOrderInfo() {
        return this.orderInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ResultInfo getResult() {
        return this.result;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    @Override
    public String toString(Locale locale) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, locale);
        return sb.toString();
    }

    public void append(StringBuilder sb, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.ptk2.Protocol", locale);
        SimpleDateFormat df = new SimpleDateFormat(bundle.getString("PTK_ENTRY_DATE"));
        sb.append(df.format(this.date));
        sb.append(this.action.toString(locale));
        sb.append("\r\n");
        if (this.hostname != null) {
            sb.append(bundle.getString("HOSTNAME"));
            sb.append(this.hostname);
            sb.append("\r\n");
            sb.append(bundle.getString("ORDER"));
            this.orderInfo.append(sb);
            sb.append("\r\n");
        }
        if (this.result != null) {
            this.result.appendText(sb, bundle);
            sb.append("\r\n");
        }
    }

    @Override
    public int compareTo(PTKEntry o) {
        int i = this.date.compareTo(o.date);
        if (i == 0) {
            return this.action.getId() - o.action.getId();
        }
        return i;
    }

    public List<String> getBlock() {
        return this.block;
    }
}

