/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import java.io.Serializable;

public class OrderInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String orderNumber;
    private final String orderType;
    private String orderTypeDescription = null;

    public OrderInfo(String orderType, String orderNumber) {
        this.orderNumber = orderNumber;
        this.orderType = orderType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getOrderTypeDescription() {
        return this.orderTypeDescription;
    }

    public void setOrderTypeDescription(String orderTypeDescription) {
        this.orderTypeDescription = orderTypeDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OrderInfo)) {
            return false;
        }
        OrderInfo oi = (OrderInfo)o;
        if (!this.orderType.equals(oi.orderType)) {
            return false;
        }
        if (this.orderNumber == null) {
            return oi.orderNumber == null;
        }
        return this.orderNumber.equals(oi.orderNumber);
    }

    public int hashCode() {
        int toReturn = this.orderType.hashCode();
        if (this.orderNumber != null) {
            toReturn ^= this.orderNumber.hashCode();
        }
        return toReturn;
    }

    void append(StringBuilder sb) {
        Object txt = this.orderTypeDescription;
        if (txt == null) {
            txt = "Beschreibung fuer " + this.orderType;
        }
        if (((String)txt).length() > 41) {
            txt = ((String)txt).substring(0, 41);
        }
        sb.append((String)txt);
        for (int i = ((String)txt).length(); i < 42; ++i) {
            sb.append(' ');
        }
        sb.append(this.orderType);
        if (this.orderNumber != null) {
            sb.append(" ");
            sb.append(this.orderNumber);
        }
    }
}

