/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import java.util.ResourceBundle;

public class ExpirationResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;
    private final String customerId;
    private final DisplayMessage ticket;

    public ExpirationResult(Result result, String customerId, DisplayMessage ticket) {
        this.result = result;
        this.ticket = ticket;
        this.customerId = customerId;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{this.result};
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        if (this.customerId != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.customerId);
            sb.append("\r\n");
        }
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }

    public String getCustomerId() {
        return this.customerId;
    }
}

