/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import java.util.ResourceBundle;

public class DisplayResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;
    private final String filename;
    private final DisplayMessage ticket;
    private String customerId;

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public DisplayResult(Result result, String filename, DisplayMessage ticket) {
        this.result = result;
        this.filename = filename;
        this.ticket = ticket;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{this.result};
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.OK2 || this.result == Result.FINISHED_MANUAL_RELEASE || this.result == Result.MANUALLY_RELEASED || this.result == Result.DS_FINISH_OK || this.result == Result.SIGNATURES_OK || this.result == Result.SRZ_SPLITTED;
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (this.filename != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("FILENAME"));
            DisplayResult.appendFilename(sb, this.filename);
        }
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }

    public static void appendFilename(StringBuilder sb, String filename) {
        while (filename.length() > 50) {
            sb.append(filename.substring(0, 50));
            sb.append("\r\n                      ");
            filename = filename.substring(50);
        }
        sb.append(filename);
    }

    public String getCustomerId() {
        return this.customerId;
    }
}

