/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import de.businesslogics.format.ptk2.UserSignatureMessage;
import java.util.ResourceBundle;

public class DSSignatureResult
implements ResultInfo {
    private static final long serialVersionUID = 2L;
    private final Result result;
    private final UserInfo userInfo;
    private final String filename;
    private final String customerId;
    private final UserSignatureMessage message;

    public DSSignatureResult(Result result, String customerId, UserInfo userInfo, String filename, UserSignatureMessage message) {
        this.result = result;
        this.customerId = customerId;
        this.userInfo = userInfo;
        this.filename = filename;
        this.message = message;
    }

    public DSSignatureResult(Result result, String customerId, UserInfo userInfo, String filename) {
        this.customerId = customerId;
        this.userInfo = userInfo;
        this.filename = filename;
        if (!Result.SIGNATURES_OK.equals(result) && !Result.VOP_PRELIMINARY_SIGNATURE.equals(result)) {
            this.result = Result.SIGNATURES_NOK;
            this.message = new UserSignatureMessage(userInfo.getUserId(), result);
        } else {
            this.message = null;
            this.result = result;
        }
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        if (this.message == null || this.message.getResult() == null) {
            return new Result[]{this.result};
        }
        return new Result[]{this.result, this.message.getResult()};
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.SIGNATURES_OK;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        if (this.customerId != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.customerId);
            sb.append("\r\n");
        }
        sb.append(bundle.getString("USER"));
        sb.append(this.userInfo);
        sb.append("\r\n");
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (this.filename != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("FILENAME"));
            DisplayResult.appendFilename(sb, this.filename);
        }
        if (this.message != null) {
            this.message.appendText(sb, bundle);
        }
    }

    public String getCustomerId() {
        return this.customerId;
    }
}

