/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.SignatureResult;
import de.businesslogics.format.ptk2.UserInfo;
import de.businesslogics.format.ptk2.UserSignatureMessage;
import java.util.List;
import java.util.ResourceBundle;

public class DSFinishResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;
    private final UserInfo[] userInfos;
    private final String customerId;
    private final UserSignatureMessage[] messages;
    private final DisplayMessage ticket;

    public DSFinishResult(Result result, String customerId, UserInfo[] userInfos, UserSignatureMessage[] messages, DisplayMessage ticket) {
        this.result = result;
        this.userInfos = userInfos;
        this.messages = messages == null ? SignatureResult.EMPTY_MESSAGES : messages;
        this.ticket = ticket;
        this.customerId = customerId;
    }

    public DSFinishResult(Result result, String customerId, List userInfos, List<UserSignatureMessage> messages, DisplayMessage ticket) {
        this.result = result;
        this.userInfos = new UserInfo[userInfos.size()];
        userInfos.toArray(this.userInfos);
        this.messages = messages == null || messages.isEmpty() ? SignatureResult.EMPTY_MESSAGES : messages.toArray(new UserSignatureMessage[messages.size()]);
        this.ticket = ticket;
        this.customerId = customerId;
    }

    public UserSignatureMessage[] getMessages() {
        return this.messages;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        Result[] toReturn = new Result[1 + this.messages.length];
        toReturn[0] = this.result;
        for (int i = 0; i < this.messages.length; ++i) {
            toReturn[i + 1] = this.messages[i].getResult();
        }
        return toReturn;
    }

    public UserInfo[] getUserInfos() {
        return this.userInfos;
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.DS_FINISH_OK;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        int i;
        boolean outputNextLine = false;
        if (this.customerId != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.customerId);
            outputNextLine = true;
        }
        String USER = bundle.getString("USER");
        for (i = 0; i < this.userInfos.length; ++i) {
            if (outputNextLine) {
                sb.append("\r\n");
            }
            outputNextLine = true;
            sb.append(USER);
            sb.append(this.userInfos[i]);
        }
        if (this.result != null) {
            if (outputNextLine) {
                sb.append("\r\n");
            }
            sb.append(bundle.getString("RESULT"));
            sb.append(this.result.toString(bundle.getLocale()));
        }
        if (this.messages != null) {
            for (i = 0; i < this.messages.length; ++i) {
                this.messages[i].appendText(sb, bundle);
            }
        }
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }

    public String getCustomerId() {
        return this.customerId;
    }
}

