/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import java.util.ResourceBundle;

public class DSEntryResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;

    public DSEntryResult(Result result) {
        this.result = result;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        if (this.result.equals(Result.DS_ENTRY_OK)) {
            return new Result[]{Result.DS_ENTRY_HANDOVER, Result.DS_ENTRY_OK};
        }
        return new Result[]{this.result};
    }

    @Override
    public boolean isSuccess() {
        return Result.DS_ENTRY_OK.equals(this.result) || Result.DS_ENTRY_HANDOVER_OK.equals(this.result);
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        sb.append(bundle.getString("RESULT"));
        if (this.result.equals(Result.DS_ENTRY_OK)) {
            sb.append(Result.DS_ENTRY_HANDOVER.toString(bundle.getLocale()));
            sb.append("\r\n                      ");
        }
        sb.append(this.result.toString(bundle.getLocale()));
    }
}

