/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import java.util.ResourceBundle;

public class DSCancelResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final OrderInfo reference;
    private final Result result;
    private final UserInfo userInfo;
    private final String filename;
    private final String customerId;

    public DSCancelResult(Result result, OrderInfo reference, String customerId, UserInfo userInfo, String filename) {
        this.result = result;
        this.reference = reference;
        this.customerId = customerId;
        this.userInfo = userInfo;
        this.filename = filename;
    }

    public OrderInfo getReference() {
        return this.reference;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{this.result};
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.DS_CANCEL_OK;
    }

    @Override
    public void appendText(StringBuilder buffer, ResourceBundle bundle) {
        if (this.reference != null) {
            buffer.append(bundle.getString("REFERENCE"));
            this.reference.append(buffer);
            buffer.append("\r\n");
        }
        if (this.customerId != null) {
            buffer.append(bundle.getString("CUSTOMER"));
            buffer.append(this.customerId);
            buffer.append("\r\n");
        }
        buffer.append(bundle.getString("USER"));
        buffer.append(this.userInfo);
        buffer.append("\r\n");
        buffer.append(bundle.getString("RESULT"));
        buffer.append(this.result.toString(bundle.getLocale()));
        if (this.filename != null) {
            buffer.append("\r\n");
            buffer.append(bundle.getString("FILENAME"));
            DisplayResult.appendFilename(buffer, this.filename);
        }
    }
}

