/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import java.util.Locale;
import java.util.ResourceBundle;

public class AdditionalInfoResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final String lang;
    private final String message;

    public AdditionalInfoResult(String message) {
        this.lang = null;
        this.message = message;
    }

    public AdditionalInfoResult(Locale locale, String message) {
        this.lang = locale == null ? null : locale.getLanguage().toUpperCase(locale);
        this.message = message;
    }

    public String getLang() {
        return this.lang;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public Result getResult() {
        return Result.OK2;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{Result.OK2};
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    public static AdditionalInfoResult format(Locale locale, StringBuilder message) {
        AdditionalInfoResult.format(message, 72);
        return new AdditionalInfoResult(locale, message.toString());
    }

    public static void format(StringBuilder message, int maxLength) {
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) != '\n' || i != 0 && message.charAt(i - 1) == '\r') continue;
            message.insert(i, '\r');
            ++i;
        }
        if (message.length() > 1 && message.charAt(message.length() - 1) == '\n') {
            message.delete(message.length() - 2, message.length());
        }
        int currentLength = 0;
        int lastSpace = -1;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '\r') {
                currentLength = 0;
                lastSpace = -1;
                ++i;
                continue;
            }
            if (message.charAt(i) == ' ') {
                lastSpace = i;
            }
            if (currentLength == maxLength) {
                if (lastSpace >= 0) {
                    message.setCharAt(lastSpace, '\n');
                    message.insert(lastSpace, '\r');
                    currentLength = i - lastSpace;
                } else {
                    message.insert(i, "\r\n");
                    currentLength = 0;
                }
                lastSpace = -1;
                ++i;
                continue;
            }
            ++currentLength;
        }
    }

    @Override
    public void appendText(StringBuilder buffer, ResourceBundle bundle) {
        int i;
        int size = this.findLength();
        for (i = 0; i < size; ++i) {
            buffer.append('=');
        }
        buffer.append("\r\n");
        buffer.append(this.message);
        buffer.append("\r\n");
        for (i = 0; i < size; ++i) {
            buffer.append('=');
        }
    }

    private int findLength() {
        if (this.message == null || this.message.length() == 0) {
            return 72;
        }
        String[] lines = this.message.split("\r\n");
        int max = 0;
        for (int i = 0; i < lines.length; ++i) {
            max = Math.max(max, lines[i].length());
        }
        return max;
    }
}

