/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ptk2;

import de.businesslogics.format.ptk2.CustomerInfo;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.UserInfo;
import java.util.ResourceBundle;

public class AccountCheckResult
implements ResultInfo {
    private static final long serialVersionUID = 1L;
    private final Result result;
    private final UserInfo userInfo;
    private final DisplayMessage ticket;
    private CustomerInfo customerInfo;
    private String bankcode;
    private String accountNumber;

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public AccountCheckResult(Result result, CustomerInfo customerInfo, UserInfo userInfo, DisplayMessage ticket) {
        this.result = result;
        this.customerInfo = customerInfo;
        this.userInfo = userInfo;
        this.ticket = ticket;
    }

    public String getBankcode() {
        return this.bankcode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccount(String bankcode, String accountNumber) {
        this.bankcode = bankcode;
        this.accountNumber = accountNumber;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public Result[] getResults() {
        return new Result[]{this.result};
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public boolean isSuccess() {
        return this.result == Result.OK2;
    }

    public DisplayMessage getTicket() {
        return this.ticket;
    }

    @Override
    public void appendText(StringBuilder sb, ResourceBundle bundle) {
        if (this.customerInfo != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.customerInfo);
            sb.append("\r\n");
        }
        sb.append(bundle.getString("USER"));
        sb.append(this.userInfo);
        sb.append("\r\n");
        sb.append(bundle.getString("RESULT"));
        sb.append(this.result.toString(bundle.getLocale()));
        if (this.bankcode != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("BANKCODE"));
            sb.append(this.bankcode);
        }
        if (this.accountNumber != null) {
            sb.append("\r\n");
            sb.append(bundle.getString("ACCOUNTNUMBER"));
            sb.append(this.accountNumber);
        }
        if (this.ticket != null) {
            sb.append("\r\n");
            sb.append("\r\n");
            this.ticket.appendText(bundle.getLocale(), sb);
        }
    }
}

