/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.printer;

import de.businesslogics.account.BankInfo;
import de.businesslogics.account.BankInfoCache;
import de.businesslogics.format.printer.PaymentPrinterMessages;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class BasePaymentPrinter {
    protected static final Color GREY = new Color(200, 200, 200);
    protected static final BLFont FONT = BLFont.FONT_NORMAL;
    protected static final BLFont BOLD_FONT = BLFont.FONT_BOLD;
    protected final Locale locale;

    protected BasePaymentPrinter(Locale l) {
        this.locale = l;
    }

    protected final String getTextOriginatorData(boolean isCredit) {
        if (isCredit) {
            return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.originatorData", new Object[0]);
        }
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.payeeData", new Object[0]);
    }

    protected final String getTextRecipientData(boolean isCredit) {
        if (isCredit) {
            return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.recipientData", new Object[0]);
        }
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.payerData", new Object[0]);
    }

    protected final String getTextName() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.name", new Object[0]);
    }

    protected final String getTextIban() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.iban", new Object[0]);
    }

    protected final String getTextAccountNumber() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.accountNumber", new Object[0]);
    }

    protected final String getTextBic() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.bic", new Object[0]);
    }

    protected final String getTextBlz() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.blz", new Object[0]);
    }

    protected final String getTextPaymentData() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.paymentData", new Object[0]);
    }

    protected final String getTextOrderData() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderData", new Object[0]);
    }

    protected final String getTextAmount() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.amount", new Object[0]);
    }

    protected final String getTextExecutionDate(boolean isCredit) {
        if (isCredit) {
            return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.executionDate", new Object[0]);
        }
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.paymentDate", new Object[0]);
    }

    protected final String getTextOrderType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderType", new Object[0]);
    }

    protected final String getTextBTF() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.btf", new Object[0]);
    }

    protected final String getTextOrderNumber() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderNumber", new Object[0]);
    }

    protected final String getTextMsgId() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.msgId", new Object[0]);
    }

    protected final String getTextPmtInfId() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.pmtInfId", new Object[0]);
    }

    protected final String getTextSendTime() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.sendTime", new Object[0]);
    }

    protected final String getTextState() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.state", new Object[0]);
    }

    protected final String getTextReference() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.reference", new Object[0]);
    }

    protected final String getTextPurpose() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.purpose", new Object[0]);
    }

    protected final String getTextStreet() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.street", new Object[0]);
    }

    protected final String getTextTown() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.town", new Object[0]);
    }

    protected final String getTextFederalState() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.federalState", new Object[0]);
    }

    protected final String getTextCountry() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.country", new Object[0]);
    }

    protected final String getTextBank() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.bank", new Object[0]);
    }

    protected final String getTextCompanyNumber() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.companyNumber", new Object[0]);
    }

    protected final String getTextContact() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.contact", new Object[0]);
    }

    protected final String getTextCustomerNumber() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.customerNumber", new Object[0]);
    }

    protected final String getTextCounterValuePayment(String currency) {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.counterValuePayment", currency);
    }

    protected final String getTextPaymentType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.paymentType", new Object[0]);
    }

    protected final String getTextOrderComment() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderComment", new Object[0]);
    }

    protected final String getTextFeeAccount() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.feeAccount", new Object[0]);
    }

    protected final String getTextFeeType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.feeType", new Object[0]);
    }

    protected final String getTextInstructionCode1() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.instrCode1", new Object[0]);
    }

    protected final String getTextInstructionCode2() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.instrCode2", new Object[0]);
    }

    protected final String getTextInstructionCode3() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.instrCode3", new Object[0]);
    }

    protected final String getTextInstructionCode4() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.instrCode4", new Object[0]);
    }

    protected final String getTextInstructions() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.instructions", new Object[0]);
    }

    protected final String getTextIntermediaryInstitution() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.intermediaryInstitution", new Object[0]);
    }

    protected final String getTextMessages() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.messages", new Object[0]);
    }

    protected final String getTextMessageDescription() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.messageDescription", new Object[0]);
    }

    protected final String getTextType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.type", new Object[0]);
    }

    protected final String getTextCapitalType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.capitalType", new Object[0]);
    }

    protected final String getTextTransitType() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.transitType", new Object[0]);
    }

    protected final String getTextTextKey() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.textKey", new Object[0]);
    }

    protected final String getTextCurrency() {
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.currency", new Object[0]);
    }

    protected final void addEmptyCell(BLTable<?> table) throws PDFException {
        table.addCell("", FONT);
    }

    protected final void addEmptyCells(BLTable<?> t, int nbrOfCells) throws PDFException {
        for (int i = 0; i < nbrOfCells; ++i) {
            t.addCell("", FONT);
        }
    }

    protected final void printDate(BLTable<?> t, Date date) throws PDFException {
        if (date != null) {
            t.addCell(DateFormat.getDateInstance(2, this.locale).format(date), FONT);
        } else {
            this.addEmptyCell(t);
        }
    }

    protected final void printDateTime(BLTable<?> t, Date date) throws PDFException {
        if (date != null) {
            t.addCell(DateFormat.getDateTimeInstance(2, 3, this.locale).format(date), FONT);
        } else {
            this.addEmptyCell(t);
        }
    }

    protected final void printHeaderLine(BLTable<?> t, String headerText) throws PDFException {
        t.setDefaultPaddingTop(3.0f);
        t.setDefaultPaddingBottom(6.0f);
        t.setBackgroundColor(GREY);
        t.setDefaultColspan(t.getColumnCount());
        t.addCell(headerText, BOLD_FONT);
        t.resetDefaults();
    }

    protected final void addLineWithoutLabel(BLTable<?> t, String content) throws PDFException {
        if (content != null && content.length() > 0) {
            this.addEmptyCell(t);
            t.setDefaultColspan(3);
            t.addCell(content, FONT);
            t.setDefaultColspan(1);
        }
    }

    public final void printOrderInfo(BLTable<?> table, Timestamp sent, String orderTypeOrFileType, String orderNumber, String sender, String bankDisplayName, String refNumber) throws PDFException {
        table.setDefaultColspan(4);
        String msg = refNumber != null && refNumber.length() > 0 ? PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderInfoWithRef", sent, orderTypeOrFileType, orderNumber, refNumber, sender, bankDisplayName) : PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.orderInfo", sent, orderTypeOrFileType, orderNumber, sender, bankDisplayName);
        table.addCell(msg, FONT);
    }

    protected String translateCountry(String isoCode) {
        return isoCode;
    }

    protected String getBankNameFromBlz(String blz, BankInfoCache bankInfoCache) {
        BankInfo info;
        if (bankInfoCache != null && (info = bankInfoCache.findByBankCode(blz)) != null) {
            return info.getName();
        }
        return PaymentPrinterMessages.getString(this.locale, "PaymentPrinter.unknown", new Object[0]);
    }
}

