/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.iso20022.pain00200103;

import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.HAC30Parser;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

public class Hac2Pdf
implements HAC30Parser.Listener {
    private final Locale locale;
    private final BLTable<?> hacTable;
    private final boolean showOrderNumber;
    private NameTranslator translator = new NameTranslator();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public Hac2Pdf(boolean showOrderNumber, Locale locale) throws PDFException {
        this.locale = locale;
        this.showOrderNumber = showOrderNumber;
        this.hacTable = this.createEmptyHACTable(locale);
    }

    private BLTable<?> createEmptyHACTable(Locale locale) throws PDFException {
        ResourceBundle bundle = ResourceBundle.getBundle(Hac2Pdf.class.getName(), locale);
        BLTable<?> hacTable = PDFCreator.getInstance().createTable(this.showOrderNumber ? 5 : 4);
        if (this.showOrderNumber) {
            hacTable.setWidths(new int[]{12, 21, 23, 17, 27});
        } else {
            hacTable.setWidths(new int[]{17, 25, 17, 41});
        }
        hacTable.setWidth(100.0f);
        hacTable.setPadding(3.0f);
        hacTable.addCell(bundle.getString("column_date"));
        if (this.showOrderNumber) {
            hacTable.addCell(bundle.getString("column_order"));
        }
        hacTable.addCell(bundle.getString("column_action"));
        hacTable.addCell(bundle.getString("column_user"));
        hacTable.addCell(bundle.getString("column_message"));
        return hacTable;
    }

    public BLTable<?> getHacTable() {
        return this.hacTable;
    }

    @Override
    public void handle(HAC30Entry hac) {
        this.addEntry(hac);
    }

    public BLTable<?> addEntry(HAC30Entry entry) {
        try {
            String add;
            this.hacTable.addCell(this.getTimestampString(entry));
            if (this.showOrderNumber) {
                this.hacTable.addCell(this.getOrderNumberRepresentation(entry));
            }
            HAC30Entry.Action a = entry.getAction();
            int colSpan = 1;
            String user = this.translator.getUserName(entry.getPartnerID(), entry.getUserID());
            if (user == null || user.length() == 0) {
                ++colSpan;
            }
            if (entry.getRsn() == null) {
                ++colSpan;
            }
            if (HAC30Entry.Action.ORDER_HAC_FINAL_NEG.equals((Object)a) || HAC30Entry.Action.ORDER_HAC_FINAL_POS.equals((Object)a)) {
                this.hacTable.addCell(HAC30Entry.getActionRepresentation(this.locale, a), BLFont.FONT_BOLD, colSpan);
            } else {
                this.hacTable.addCell(HAC30Entry.getActionRepresentation(this.locale, a), colSpan);
            }
            if (user != null && user.length() > 0) {
                this.hacTable.addCell(user);
            }
            if (entry.getRsn() != null) {
                this.hacTable.addCell(HAC30Entry.getReasonMessage(this.locale, entry.getRsn(), a));
            }
            if ((add = entry.getAddtlInfs()) != null && !add.isEmpty()) {
                this.hacTable.addEmptyCell();
                this.hacTable.addCell(add, BLFont.COURIER_NORMAL, this.showOrderNumber ? 4 : 3);
            }
            return this.hacTable;
        }
        catch (PDFException pdf) {
            throw new RuntimeException(pdf);
        }
    }

    public void setTranslator(NameTranslator nameTranslator) {
        this.translator = nameTranslator;
    }

    private String getOrderNumberRepresentation(HAC30Entry entry) {
        String btfString = entry.getBTFString();
        String fileformat = entry.getFileFormat();
        String orderType = entry.getOrderTypeString();
        String orderId = entry.getOrderIdString();
        StringBuilder orderNumberRepresentation = new StringBuilder();
        if (btfString != null) {
            orderNumberRepresentation.append(btfString);
        } else if (fileformat != null && fileformat.trim().length() > 0) {
            orderNumberRepresentation.append(fileformat.trim());
        } else if (orderType != null) {
            orderNumberRepresentation.append(orderType);
        }
        if (orderId != null) {
            if (orderNumberRepresentation.length() > 0) {
                orderNumberRepresentation.append('/');
            }
            orderNumberRepresentation.append(orderId);
        }
        return orderNumberRepresentation.toString();
    }

    private String getTimestampString(HAC30Entry entry) {
        try {
            if (entry.getTimeStamp() == null) {
                return entry.getTimeStampString();
            }
            return this.dateFormat.format(entry.getTimeStamp());
        }
        catch (ParseException pe) {
            return entry.getTimeStampString();
        }
    }

    public static void main(String[] args) throws Exception {
        String title = new File(args[0]).getName();
        FileOutputStream fos = new FileOutputStream(new File(args[1]));
        Hac2Pdf hac2Pdf = new Hac2Pdf(true, Locale.getDefault());
        HAC30Parser parser = new HAC30Parser(hac2Pdf);
        parser.parse(new FileInputStream(args[0]));
        BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4, 70.0f, 30.0f, 70.0f, 30.0f);
        document.addMetaInformation(title, "Business-Logics GmbH", "Hac2Pdf");
        document.open(fos);
        document.addHeadline(title);
        document.addTable(hac2Pdf.getHacTable());
        document.close();
        fos.close();
        fos = null;
    }

    public static class NameTranslator {
        public String getUserName(String partnerId, String userId) {
            if (userId == null || userId.length() == 0) {
                return "";
            }
            return partnerId + "/" + userId;
        }
    }
}

