/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.iso20022.pain00200103;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsElementListener;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.iso20022.pain00200103.CustomerPaymentStatusReportV03;
import de.businesslogics.format.iso20022.pain00200103.Document;
import de.businesslogics.format.iso20022.pain00200103.GenericOrganisationIdentification1;
import de.businesslogics.format.iso20022.pain00200103.GroupHeader36;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.Max105Text;
import de.businesslogics.format.iso20022.pain00200103.OriginalPaymentInformation1;
import de.businesslogics.format.iso20022.pain00200103.StatusReason6Choice;
import de.businesslogics.format.iso20022.pain00200103.StatusReasonInformation8;
import de.businesslogics.format.ptk2.PTKParser;
import de.businesslogics.license.UnsignedJarLicense;
import de.businesslogics.util.LocalizableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HACEntry
implements LocalizableString,
Serializable,
Comparable<HACEntry> {
    private static final long serialVersionUID = 1L;
    private final String hostID;
    private final Action action;
    String partnerID;
    String userID;
    String systemID;
    String orderType;
    String orderID;
    String rsn;
    String fileFormat;
    String partnerIDRef;
    String orderTypeRef;
    String orderIDRef;
    String timeStamp;
    String addtlInfs;
    private OriginalPaymentInformation1 opi;

    public HACEntry(String hostID, Action action, String partnerID, String userID, String systemID, String orderType, String orderID, String rsn, String fileFormat, String partnerIDRef, String orderTypeRef, String orderIDRef, String timeStamp, String addtlInfs, OriginalPaymentInformation1 opi) {
        this.hostID = hostID;
        this.action = action;
        this.partnerID = partnerID;
        this.userID = userID;
        this.systemID = systemID;
        this.orderType = orderType;
        this.orderID = orderID;
        this.rsn = rsn;
        this.fileFormat = fileFormat;
        this.partnerIDRef = partnerIDRef;
        this.orderTypeRef = orderTypeRef;
        this.orderIDRef = orderIDRef;
        this.timeStamp = timeStamp;
        this.addtlInfs = addtlInfs;
        this.opi = opi;
    }

    private HACEntry(String hostID, Action action) {
        this.hostID = hostID;
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public String getActionRepresentation(Locale l) {
        return HACEntry.getActionRepresentation(l, this.action);
    }

    public static String getActionRepresentation(Locale l, Action action) {
        return HACEntry.getActionRepresentation(l, action.toString());
    }

    public static String getActionRepresentation(Locale l, String action) {
        return HACEntry.getStringFromBundle("ActionCode." + action, l);
    }

    public String getHostID() {
        return this.hostID;
    }

    public String getPartnerID() {
        return this.partnerID;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public String getRsn() {
        return this.rsn;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getPartnerIDRef() {
        return this.partnerIDRef;
    }

    public String getOrderTypeRef() {
        return this.orderTypeRef;
    }

    public String getOrderIDRef() {
        return this.orderIDRef;
    }

    public Date getTimeStamp() throws ParseException {
        if (this.timeStamp == null) {
            return null;
        }
        return TimeStamp.fromString(this.timeStamp);
    }

    public String getTimeStampString() {
        return this.timeStamp;
    }

    public String getAddtlInfs() {
        return this.addtlInfs;
    }

    public String getOrderNumberRepresentation() {
        StringBuilder result = new StringBuilder();
        if (this.orderTypeRef != null) {
            result.append(this.orderTypeRef);
            result.append('/');
        } else if (this.orderType != null) {
            result.append(this.orderType);
            result.append('/');
        }
        if (this.orderIDRef != null) {
            result.append(this.orderIDRef);
        } else if (this.orderID != null) {
            result.append(this.orderID);
        }
        return result.toString();
    }

    public String getReasonMessage(Locale l) {
        return HACEntry.getReasonMessage(l, this.rsn, this.action);
    }

    public static String getReasonMessage(Locale l, String rsn, Action action) {
        if (rsn == null) {
            return null;
        }
        HAC30Entry.ReasonCode reasonCode = HAC30Entry.ReasonCode.getByIsoCode(rsn);
        if (reasonCode == null) {
            return null;
        }
        return HACEntry.getReasonMessage(reasonCode, l, action);
    }

    public static String getReasonMessage(HAC30Entry.ReasonCode reasonCode, Locale l, Action action) {
        switch (reasonCode) {
            case CORRESPONDING_ORIGINAL_FILE_STILL_NOT_SENT: 
            case DATA_SIGN_REQUESTED: 
            case DECOMPRESSION_ERROR: 
            case DECRYPTION_ERROR: 
            case DIFFERENT_ORDER_DATA_IN_SIGNATURES: 
            case ELECTRONIC_SIGNATURE_RIGHTS_INSUFFICIENT: 
            case ELECTRONIC_SIGNATURES_CORRECT: 
            case FILE_NON_READABLE: 
            case IDENTICAL_SIGNATURE_FOUND: 
            case INCORRECT_FILE_STRUCTURE: 
            case INCORRECT_SIGNER_1_CERTIFICATE: 
            case INCORRECT_SIGNER_2_CERTIFICATE: 
            case INCORRECT_SIGNER_CERTIFICATE: 
            case LIMIT_EXCEEDED: 
            case NO_DATA_AVAILABLE: 
            case NOT_ALLOWED_ACCOUNT: 
            case NOT_ALLOWED_PAYMENT: 
            case ORDER_CANCELLED: 
            case ORDER_FILE_DELETED: 
            case ORDER_FORWARDED_FOR_POSTPROCESSING: 
            case ORDER_NOT_CANCELLED: 
            case ORDER_REJECTED: 
            case PROCESSING_OK: 
            case PUBLIC_KEY_VERSION_INCORRECT: 
            case REPEAT_ORDER: 
            case SIGNER_1_CERTIFICATE_NOT_VALID: 
            case SIGNER_1_CERTIFICATE_REVOKED: 
            case SIGNER_2_CERTIFICATE_NOT_VALID: 
            case SIGNER_2_CERTIFICATE_REVOKED: 
            case SIGNER_CERTIFICATE_NOT_VALID: 
            case SIGNER_CERTIFICATE_REVOKED: 
            case SIGNER_CERTIFICATION_AUTHORITY: 
            case SIGNER_CERTIFICATION_AUTHORITY_SIGNER_1_NOT_VALID: 
            case SIGNER_CERTIFICATION_AUTHORITY_SIGNER_2_NOT_VALID: 
            case TRANSFER_ORDER: 
            case TRANSFER_TO_SIGN_BY_HAND: 
            case UNKNOWN_DATA_SIGN_FORMAT: 
            case USER_DOES_NOT_EXIST: 
            case USER_NOT_YET_ACTIVATED: 
            case USER_SIGNED_MULTIPLE_TIMES: 
            case WAITING_TIME_EXPIRED: {
                return HACEntry.getStringFromBundle(reasonCode.getIsoCode(), l);
            }
            case TRANSMISSION_ABORTED: 
            case TRANSMISSION_SUCCESSFUL: {
                switch (action.ordinal()) {
                    case 0: {
                        return HACEntry.getStringFromBundle(reasonCode.getIsoCode() + "_U", l);
                    }
                    case 1: {
                        return HACEntry.getStringFromBundle(reasonCode.getIsoCode() + "_D", l);
                    }
                    case 2: {
                        return HACEntry.getStringFromBundle(reasonCode.getIsoCode() + "_S", l);
                    }
                }
                return HACEntry.getStringFromBundle(reasonCode.getIsoCode() + "_U", l);
            }
        }
        return reasonCode.getIsoCode();
    }

    public String getUserRepresentation() {
        if (this.userID == null || this.userID.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (this.partnerIDRef != null) {
            result.append(this.partnerIDRef);
        } else if (this.partnerID != null) {
            result.append(this.partnerID);
        }
        if (result.length() > 0) {
            result.append('/');
        }
        result.append(this.userID);
        return result.toString();
    }

    private static void append(StringBuilder sb, String key, String value) {
        if (value != null) {
            sb.append("    ").append(key);
            for (int i = key.length(); i < 12; ++i) {
                sb.append(' ');
            }
            sb.append(": ").append(value).append("\r\n");
        }
    }

    public boolean isSuccess() {
        switch (this.action.ordinal()) {
            case 9: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "TS01".equals(this.rsn);
            }
            case 4: 
            case 6: {
                return "DS01".equals(this.rsn);
            }
            case 5: {
                return "DS06".equals(this.rsn);
            }
            case 7: {
                return "DS05".equals(this.rsn);
            }
            case 8: {
                return "DS03".equals(this.rsn);
            }
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isFinal() {
        return this.action == Action.ORDER_HAC_FINAL_NEG || this.action == Action.ORDER_HAC_FINAL_POS;
    }

    @Override
    public String toString(Locale l) {
        StringBuilder sb = new StringBuilder();
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.ptk2.Protocol", l);
        try {
            SimpleDateFormat df = new SimpleDateFormat(bundle.getString("PTK_ENTRY_DATE"));
            sb.append(df.format(this.getTimeStamp()));
            sb.append("HAC ");
        }
        catch (ParseException p) {
            sb.append("DATE INVALID          HAC ");
        }
        sb.append(this.getActionRepresentation(l));
        sb.append("\r\n");
        if (this.hostID != null) {
            sb.append(bundle.getString("HOSTNAME"));
            sb.append(this.hostID);
            sb.append("\r\n");
        }
        if (this.orderType != null) {
            sb.append(bundle.getString("ORDER"));
            sb.append(this.orderType);
            if (this.orderID != null) {
                sb.append(" ");
                sb.append(this.orderID);
            }
            sb.append("\r\n");
        }
        if (this.partnerID != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.partnerID);
            if (this.userID != null) {
                sb.append(" ");
                sb.append(this.userID);
            }
            if (this.systemID != null) {
                sb.append(" (");
                sb.append(this.systemID);
                sb.append(")");
            }
            sb.append("\r\n");
        }
        if (this.fileFormat != null) {
            sb.append(bundle.getString("ORDER"));
            sb.append(this.fileFormat);
            if (this.orderID != null) {
                sb.append(" ");
                sb.append(this.orderID);
            }
            sb.append("\r\n");
        }
        if (this.orderTypeRef != null) {
            sb.append(bundle.getString("REFERENCE"));
            sb.append(this.orderTypeRef);
            if (this.orderIDRef != null) {
                sb.append(" ");
                sb.append(this.orderIDRef);
            }
            if (this.partnerIDRef != null) {
                sb.append(" (");
                sb.append(this.partnerIDRef);
                sb.append(")");
            }
            sb.append("\r\n");
        }
        if (this.rsn != null) {
            sb.append(bundle.getString("RESULT"));
            sb.append(this.getReasonMessage(l));
            sb.append("\r\n");
        }
        if (this.addtlInfs != null) {
            sb.append("\r\n");
            sb.append(this.addtlInfs);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        HACEntry.append(sb, "HostID", this.hostID);
        HACEntry.append(sb, "Action", this.action.name());
        HACEntry.append(sb, "TimeStamp", this.timeStamp);
        HACEntry.append(sb, "Rsn", this.rsn);
        HACEntry.append(sb, "PartnerID", this.partnerID);
        HACEntry.append(sb, "UserID", this.userID);
        HACEntry.append(sb, "SystemID", this.systemID);
        HACEntry.append(sb, "OrderType", this.orderType);
        HACEntry.append(sb, "FileFormat", this.fileFormat);
        HACEntry.append(sb, "OrderID", this.orderID);
        HACEntry.append(sb, "PartnerIDRef", this.partnerIDRef);
        HACEntry.append(sb, "OrderTypeRef", this.orderTypeRef);
        HACEntry.append(sb, "OrderIDRef", this.orderIDRef);
        if (this.addtlInfs != null) {
            sb.append(this.addtlInfs);
        }
        return sb.toString();
    }

    public static void parseRelaxed(final Listener listener, InputStream is) throws SAXException, IOException {
        XMLReader r = XMLReaderFactory.createXMLReader();
        r.setContentHandler(new DefaultHandler(){
            private StringBuilder valueBuilder = null;
            private String value = null;
            private StringBuilder fieldBuilder = null;
            private StringBuilder addtlInf = null;
            private String hostId = null;
            private HACEntry hacEntry = null;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) {
                if ("Id".equalsIgnoreCase(localName) || "OrgnlPmtInfId".equalsIgnoreCase(localName) || "Cd".equalsIgnoreCase(localName) || "AddtlInf".equalsIgnoreCase(localName)) {
                    this.valueBuilder = new StringBuilder();
                } else if ("Prtry".equalsIgnoreCase(localName)) {
                    this.fieldBuilder = new StringBuilder();
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if ("OrgnlPmtInfAndSts".equalsIgnoreCase(localName)) {
                    this.hacEntry.addtlInfs = this.addtlInf != null ? this.addtlInf.toString() : null;
                    this.addtlInf = null;
                    listener.handle(this.hacEntry);
                } else if ("OrgnlPmtInfId".equalsIgnoreCase(localName)) {
                    String action = this.valueBuilder.toString();
                    if ("ELAPSED_ORDER".equals(action)) {
                        action = "ES_VERIFICATION";
                    }
                    this.hacEntry = new HACEntry(this.hostId, Action.valueOf(action));
                } else if ("Prtry".equalsIgnoreCase(localName)) {
                    String field = this.fieldBuilder.toString();
                    if ("FileFormat".equalsIgnoreCase(field)) {
                        this.hacEntry.fileFormat = this.value;
                    } else if ("OrderID".equalsIgnoreCase(field)) {
                        this.hacEntry.orderID = this.value;
                    } else if ("OrderIDRef".equalsIgnoreCase(field)) {
                        this.hacEntry.orderIDRef = this.value;
                    } else if ("OrderType".equalsIgnoreCase(field)) {
                        this.hacEntry.orderType = this.value;
                    } else if ("OrderTypeRef".equalsIgnoreCase(field)) {
                        this.hacEntry.orderTypeRef = this.value;
                    } else if ("PartnerID".equalsIgnoreCase(field)) {
                        this.hacEntry.partnerID = this.value;
                    } else if ("PartnerIDRef".equalsIgnoreCase(field)) {
                        this.hacEntry.partnerIDRef = this.value;
                    } else if ("SystemID".equalsIgnoreCase(field)) {
                        this.hacEntry.systemID = this.value;
                    } else if ("TimeStamp".equalsIgnoreCase(field)) {
                        this.hacEntry.timeStamp = this.value;
                    } else if ("UserID".equalsIgnoreCase(field)) {
                        this.hacEntry.userID = this.value;
                    }
                } else if ("Cd".equalsIgnoreCase(localName)) {
                    this.hacEntry.rsn = this.valueBuilder.toString();
                } else if ("Id".equalsIgnoreCase(localName)) {
                    if (this.valueBuilder != null) {
                        this.value = this.valueBuilder.toString();
                    }
                } else if ("InitgPty".equalsIgnoreCase(localName)) {
                    this.hostId = this.value;
                } else if ("AddtlInf".equalsIgnoreCase(localName)) {
                    if (this.addtlInf == null) {
                        this.addtlInf = new StringBuilder();
                    }
                    this.addtlInf.append(this.valueBuilder.toString());
                    this.addtlInf.append("\r\n");
                }
                this.valueBuilder = null;
                this.fieldBuilder = null;
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.valueBuilder != null) {
                    this.valueBuilder.append(ch, start, length);
                } else if (this.fieldBuilder != null) {
                    this.fieldBuilder.append(ch, start, length);
                }
            }
        });
        r.parse(new InputSource(is));
    }

    public static void parse(final Listener listener, InputStream is) throws SAXException, IOException {
        RootChoiceParser rootParser = new RootChoiceParser();
        rootParser.addPossibleRoot(Document.class);
        EbicsHandler handler = new EbicsHandler(rootParser);
        handler.setValidate(false);
        EbicsElementListener hacListener = new EbicsElementListener(){
            List<OriginalPaymentInformation1> opis;
            String hostId;

            @Override
            public void startElement(String uri, String localName, EbicsElement element) {
                if (element instanceof CustomerPaymentStatusReportV03) {
                    this.opis = ((CustomerPaymentStatusReportV03)element).getOrgnlPmtInfAndStss();
                }
            }

            @Override
            public void endElement(EbicsElement element) {
                if (element instanceof GroupHeader36) {
                    GroupHeader36 grpHdr = (GroupHeader36)element;
                    this.hostId = grpHdr.getInitgPty().getId().getChoice1().getOrgId().getOthrs().get(0).getId().getValue();
                }
                if (element instanceof OriginalPaymentInformation1) {
                    HACEntry hac;
                    this.opis.clear();
                    OriginalPaymentInformation1 opi = (OriginalPaymentInformation1)element;
                    try {
                        hac = new HACEntry(this.hostId, Action.valueOf(opi.getOrgnlPmtInfId().getValue()));
                        hac.setOpi(opi);
                    }
                    catch (Exception e) {
                        return;
                    }
                    StatusReasonInformation8 sri = opi.getStsRsnInfs().get(0);
                    StatusReason6Choice src = sri.getRsn();
                    if (src != null) {
                        hac.rsn = src.getChoice1().getCd().getValue();
                    }
                    for (GenericOrganisationIdentification1 goi : sri.getOrgtr().getId().getChoice1().getOrgId().getOthrs()) {
                        String key = goi.getSchmeNm().getChoice1().getPrtry().getValue();
                        String value = goi.getId().getValue();
                        if (key.equals("UserID")) {
                            hac.userID = value;
                            continue;
                        }
                        if (key.equals("PartnerID")) {
                            hac.partnerID = value;
                            continue;
                        }
                        if (key.equals("FileFormat")) {
                            hac.fileFormat = value;
                            continue;
                        }
                        if (key.equals("OrderID")) {
                            hac.orderID = value;
                            continue;
                        }
                        if (key.equals("OrderType")) {
                            hac.orderType = value;
                            continue;
                        }
                        if (key.equals("TimeStamp")) {
                            hac.timeStamp = value;
                            continue;
                        }
                        if (key.equals("SystemID")) {
                            hac.systemID = value;
                            continue;
                        }
                        if (key.equals("PartnerIDRef")) {
                            hac.partnerIDRef = value;
                            continue;
                        }
                        if (key.equals("OrderTypeRef")) {
                            hac.orderTypeRef = value;
                            continue;
                        }
                        if (!key.equals("OrderIDRef")) continue;
                        hac.orderIDRef = value;
                    }
                    if (!sri.getAddtlInfs().isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (Max105Text t : sri.getAddtlInfs()) {
                            sb.append(t.getValue()).append("\r\n");
                        }
                        hac.addtlInfs = sb.toString();
                    }
                    listener.handle(hac);
                }
            }
        };
        handler.setListener(hacListener);
        handler.parse(is, null);
    }

    private static String getStringFromBundle(String key, Locale l) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.iso20022.pain00200103.HACMessage", l);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missing) {
            return "!" + key + "!";
        }
    }

    @Override
    public int compareTo(HACEntry o) {
        Date otherTimeStamp;
        Date myTimeStamp;
        int result = 0;
        if (o == null) {
            return 1;
        }
        try {
            myTimeStamp = this.getTimeStamp();
        }
        catch (ParseException e) {
            myTimeStamp = null;
        }
        try {
            otherTimeStamp = o.getTimeStamp();
        }
        catch (ParseException e) {
            otherTimeStamp = null;
        }
        if (myTimeStamp == null) {
            if (otherTimeStamp != null) {
                result = -1;
            }
        } else {
            result = otherTimeStamp != null ? myTimeStamp.compareTo(otherTimeStamp) : 1;
        }
        if (result == 0) {
            result = this.action.compareTo(o.action);
        }
        return result;
    }

    public OriginalPaymentInformation1 getOpi() {
        return this.opi;
    }

    public void setOpi(OriginalPaymentInformation1 opi) {
        this.opi = opi;
    }

    static {
        InputStream in = PTKParser.class.getResourceAsStream("/de/businesslogics/format/iso20022/pain00200103/license");
        if (in != null) {
            new UnsignedJarLicense(in);
        }
    }

    public static enum Action {
        FILE_UPLOAD,
        FILE_DOWNLOAD,
        ES_UPLOAD,
        ES_DOWNLOAD,
        ES_VERIFICATION,
        VEU_FORWARDING,
        VEU_VERIFICATION,
        VEU_VERIFICATION_END,
        VEU_CANCEL_ORDER,
        ADDITIONAL,
        ORDER_HAC_FINAL_POS,
        ORDER_HAC_FINAL_NEG;

    }

    public static interface Listener {
        public void handle(HACEntry var1);
    }
}

