/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.iso20022.pain00200103;

import de.businesslogics.ebics.schema.OutputContentHandler;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HAC30Parser
extends SmartDefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(HAC30Parser.class.getName());
    public static final SmartDefaultHandler.Path P213_HOST_ID;
    public static final SmartDefaultHandler.Path P213_OPI;
    public static final SmartDefaultHandler.Path P213_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P213_RSN;
    public static final SmartDefaultHandler.Path P213_ORG_ID;
    public static final SmartDefaultHandler.Path P213_KEY;
    public static final SmartDefaultHandler.Path P213_VALUE;
    public static final SmartDefaultHandler.Path P213_ADDT_INF;
    private final Listener listener;
    private ByteArrayOutputStream opi;
    private String hostId;
    private String value;
    private HAC30Entry entry;
    private final StringBuilder addtInf = new StringBuilder();
    private ContentHandler subHandler;

    public HAC30Parser(Listener listener) {
        this.listener = listener;
    }

    public boolean isStoreOpi() {
        return this.opi != null;
    }

    public void setStoreOpi(boolean storeOpi) {
        if (this.isStoreOpi() != storeOpi) {
            this.opi = storeOpi ? new ByteArrayOutputStream() : null;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.hostId = null;
    }

    @SmartDefaultHandler.Callback(value={"P213_HOST_ID"})
    public void setHostId() {
        this.hostId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P213_OPI"})
    public void startOpi(Attributes atts) throws IOException {
        if (this.opi != null) {
            this.subHandler = new OutputContentHandler(this.opi);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.subHandler != null) {
            this.subHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.subHandler != null) {
            this.subHandler.endElement(uri, localName, qName);
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.subHandler != null) {
            this.subHandler.characters(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (this.subHandler != null) {
            this.subHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
        if (this.subHandler != null) {
            this.subHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        if (this.subHandler != null) {
            this.subHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
        if (this.subHandler != null) {
            this.subHandler.skippedEntity(name);
        }
    }

    @SmartDefaultHandler.Callback(value={"P213_PMT_INF_ID"})
    public void setAction() {
        String action = this.getString();
        if ("ELAPSED_ORDER".equals(action)) {
            action = "ES_VERIFICATION";
        }
        this.entry = new HAC30Entry(this.hostId, HAC30Entry.Action.valueOf(action));
    }

    @SmartDefaultHandler.Callback(value={"P213_RSN"})
    public void setRsn() {
        this.entry.rsn = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P213_VALUE"})
    public void setValue() {
        this.value = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P213_KEY"})
    public void setKey() {
        String key;
        switch (key = this.getString()) {
            case "UserID": {
                this.entry.userID = this.value;
                break;
            }
            case "PartnerID": {
                this.entry.partnerID = this.value;
                break;
            }
            case "FileFormat": {
                this.entry.fileFormat = this.value;
                break;
            }
            case "OrderID": {
                this.entry.orderID = this.value;
                break;
            }
            case "AdminOrderType": {
                this.entry.h005 = true;
            }
            case "OrderType": {
                this.entry.orderType = this.value;
                break;
            }
            case "ServiceName": {
                this.entry.ensureBTF().setServiceName(this.value);
                break;
            }
            case "Scope": {
                this.entry.ensureBTF().setScope(this.value);
                break;
            }
            case "ServiceOption": {
                this.entry.ensureBTF().setServiceOption(this.value);
                break;
            }
            case "ContainerType": {
                this.entry.ensureBTF().setContainer(this.value);
                break;
            }
            case "MsgName": {
                this.entry.ensureBTF().setMsgName(this.value);
                break;
            }
            case "TimeStamp": {
                this.entry.timeStamp = this.value;
                break;
            }
            case "SystemID": {
                this.entry.systemID = this.value;
                break;
            }
            case "PartnerIDRef": {
                this.entry.partnerIDRef = this.value;
                break;
            }
            case "AdminOrderTypeRef": {
                this.entry.h005 = true;
            }
            case "OrderTypeRef": {
                this.entry.orderTypeRef = this.value;
                break;
            }
            case "ServiceNameRef": {
                this.entry.ensureBTFRef().setServiceName(this.value);
                break;
            }
            case "ScopeRef": {
                this.entry.ensureBTFRef().setScope(this.value);
                break;
            }
            case "ServiceOptionRef": {
                this.entry.ensureBTFRef().setServiceOption(this.value);
                break;
            }
            case "ContainerTypeRef": {
                this.entry.ensureBTFRef().setContainer(this.value);
                break;
            }
            case "MsgNameRef": {
                this.entry.ensureBTFRef().setMsgName(this.value);
                break;
            }
            case "OrderIDRef": {
                this.entry.orderIDRef = this.value;
                break;
            }
            case "DataDigest": {
                break;
            }
            default: {
                LOGGER.warning("Unknown key " + key);
            }
        }
    }

    @SmartDefaultHandler.Callback(value={"P213_ORG_ID"})
    public void endOrgId() {
        this.value = null;
    }

    @SmartDefaultHandler.Callback(value={"P213_ADDT_INF"})
    public void addAddtInf() {
        this.addtInf.append(this.getString()).append("\r\n");
    }

    @SmartDefaultHandler.Callback(value={"P213_OPI"})
    public void endOpi() throws SAXException {
        if (this.addtInf.length() > 0) {
            this.entry.addtlInfs = this.addtInf.toString();
            this.addtInf.setLength(0);
        }
        if (this.opi != null) {
            this.subHandler.endDocument();
            this.subHandler = null;
            this.entry.opi = this.opi.toByteArray();
            this.opi.reset();
        }
        this.listener.handle(this.entry);
        this.entry = null;
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.002.001.03", "Document");
        SmartDefaultHandler.Path cstmrPmtStsRpt = new SmartDefaultHandler.Path(document, "CstmrPmtStsRpt");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrPmtStsRpt, "GrpHdr");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P213_HOST_ID = new SmartDefaultHandler.Path(othr, "Id");
        P213_OPI = new SmartDefaultHandler.Path(cstmrPmtStsRpt, "OrgnlPmtInfAndSts");
        P213_PMT_INF_ID = new SmartDefaultHandler.Path(P213_OPI, "OrgnlPmtInfId");
        SmartDefaultHandler.Path stsRsnInf = new SmartDefaultHandler.Path(P213_OPI, "StsRsnInf");
        SmartDefaultHandler.Path orgtr = new SmartDefaultHandler.Path(stsRsnInf, "Orgtr");
        SmartDefaultHandler.Path id2 = new SmartDefaultHandler.Path(orgtr, "Id");
        P213_ORG_ID = new SmartDefaultHandler.Path(id2, "OrgId");
        othr = new SmartDefaultHandler.Path(P213_ORG_ID, "Othr");
        P213_VALUE = new SmartDefaultHandler.Path(othr, "Id");
        SmartDefaultHandler.Path schmeNm = new SmartDefaultHandler.Path(othr, "SchmeNm");
        P213_KEY = new SmartDefaultHandler.Path(schmeNm, "Prtry");
        SmartDefaultHandler.Path rsn = new SmartDefaultHandler.Path(stsRsnInf, "Rsn");
        P213_RSN = new SmartDefaultHandler.Path(rsn, "Cd");
        P213_ADDT_INF = new SmartDefaultHandler.Path(stsRsnInf, "AddtlInf");
    }

    public static interface Listener {
        public void handle(HAC30Entry var1);
    }
}

