/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.iso20022.pain00200103;

import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.BTF;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.iso20022.pain00200103.HACEntry;
import de.businesslogics.format.iso20022.pain00200103.OriginalPaymentInformation1;
import de.businesslogics.format.ptk2.PTKParser;
import de.businesslogics.license.UnsignedJarLicense;
import de.businesslogics.util.LocalizableString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.SAXException;

public class HAC30Entry
implements LocalizableString,
Serializable,
Comparable<HAC30Entry> {
    private static final long serialVersionUID = 1L;
    private final String hostID;
    private final Action action;
    boolean h005;
    String partnerID;
    String userID;
    String systemID;
    String orderType;
    String orderID;
    String rsn;
    String fileFormat;
    String partnerIDRef;
    String orderTypeRef;
    String orderIDRef;
    String timeStamp;
    String addtlInfs;
    BTF btf;
    BTF btfRef;
    byte[] opi;

    public HAC30Entry(String hostID, Action action, String partnerID, String userID, String orderType, String orderID, String rsn, String fileFormat, BTF btf, String timeStamp, String addtlInfs) {
        this.hostID = hostID;
        this.action = action;
        this.partnerID = partnerID;
        this.userID = userID;
        this.orderType = orderType;
        this.orderID = orderID;
        this.rsn = rsn;
        this.fileFormat = fileFormat;
        this.btf = btf;
        if (btf != null) {
            this.h005 = true;
        }
        this.timeStamp = timeStamp;
        this.addtlInfs = addtlInfs;
    }

    HAC30Entry(String hostID, Action action) {
        this.hostID = hostID;
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    private String getActionRepresentation(ResourceBundle rb) {
        return rb.getString("ActionCode." + this.action.toString());
    }

    public String getActionRepresentation(Locale l) {
        return HACEntry.getActionRepresentation(l, this.action.toString());
    }

    public static String getActionRepresentation(Locale l, Action action) {
        return HACEntry.getActionRepresentation(l, action.toString());
    }

    public String getHostID() {
        return this.hostID;
    }

    public String getPartnerID() {
        return this.partnerID;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public String getRsn() {
        return this.rsn;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getPartnerIDRef() {
        return this.partnerIDRef;
    }

    public String getOrderTypeRef() {
        return this.orderTypeRef;
    }

    public String getOrderIDRef() {
        return this.orderIDRef;
    }

    public Date getTimeStamp() throws ParseException {
        if (this.timeStamp == null) {
            return null;
        }
        return TimeStamp.fromString(this.timeStamp);
    }

    public String getTimeStampString() {
        return this.timeStamp;
    }

    public String getAddtlInfs() {
        return this.addtlInfs;
    }

    public String getReasonMessage(Locale l) {
        return this.getReasonMessage(ResourceBundle.getBundle("de.businesslogics.format.iso20022.pain00200103.HACMessage", l));
    }

    public static String getReasonMessage(Locale l, String rsn, Action action) {
        return HAC30Entry.getReasonMessage(ResourceBundle.getBundle("de.businesslogics.format.iso20022.pain00200103.HACMessage", l), rsn, action);
    }

    public static String getReasonMessage(ResourceBundle bundle, String rsn, Action action) {
        if (rsn == null) {
            return null;
        }
        if ("TS01".equals(rsn) || "TA01".equals(rsn)) {
            switch (action.ordinal()) {
                case 1: {
                    return bundle.getString(rsn + "_D");
                }
                case 2: {
                    return bundle.getString(rsn + "_S");
                }
            }
            return bundle.getString(rsn + "_U");
        }
        try {
            return bundle.getString(rsn);
        }
        catch (MissingResourceException mre) {
            return rsn;
        }
    }

    private String getReasonMessage(ResourceBundle bundle) {
        return HAC30Entry.getReasonMessage(bundle, this.rsn, this.action);
    }

    private static void append(StringBuilder sb, String key, String value) {
        if (value != null) {
            sb.append("    ").append(key);
            for (int i = key.length(); i < 12; ++i) {
                sb.append(' ');
            }
            sb.append(": ").append(value).append("\r\n");
        }
    }

    public static boolean isSuccess(int action, String rsn) {
        Action[] actions = Action.values();
        if (action >= 0 && action < actions.length) {
            return HAC30Entry.isSuccess(actions[action], rsn);
        }
        return false;
    }

    public static String getSymbolicActionName(int action) {
        Action[] actions = Action.values();
        if (action >= 0 && action < actions.length) {
            return actions[action].name();
        }
        return String.valueOf(action);
    }

    public static boolean isSuccess(Action action, String rsn) {
        switch (action.ordinal()) {
            case 9: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "TS01".equals(rsn);
            }
            case 4: 
            case 6: {
                if ("TS04".equals(rsn)) {
                    return true;
                }
                return "DS01".equals(rsn);
            }
            case 5: {
                return "DS06".equals(rsn);
            }
            case 7: {
                return "DS05".equals(rsn);
            }
            case 8: {
                return "DS03".equals(rsn);
            }
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isSuccess() {
        return HAC30Entry.isSuccess(this.action, this.rsn);
    }

    public HACState getProbableFinalSuccess(HACState lastState) {
        switch (this.action.ordinal()) {
            case 12: {
                if (lastState == HACState.PROBABELY_OK || lastState == HACState.OK) {
                    return HACState.PROBABELY_OK;
                }
                if (lastState == HACState.PROBABELY_NOK || lastState == HACState.NOK) {
                    return HACState.NOK;
                }
                return lastState;
            }
            case 11: {
                return HACState.NOK;
            }
            case 10: {
                return lastState == HACState.CANCELLED ? HACState.CANCELLED : HACState.OK;
            }
            case 4: 
            case 7: {
                return this.h005 ? (this.isSuccess() ? HACState.PROBABELY_OK : HACState.PROBABELY_NOK) : null;
            }
            case 8: {
                if (!"DS02".equals(this.rsn)) break;
                return HACState.CANCELLED;
            }
        }
        return lastState;
    }

    @Override
    public String toString(Locale l) {
        StringBuilder sb = new StringBuilder();
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.ptk2.Protocol", l);
        ResourceBundle hac30b = ResourceBundle.getBundle("de.businesslogics.format.iso20022.pain00200103.HACMessage", l);
        try {
            SimpleDateFormat df = new SimpleDateFormat(bundle.getString("PTK_ENTRY_DATE"));
            sb.append(df.format(this.getTimeStamp()));
            sb.append("HAC ");
        }
        catch (ParseException p) {
            sb.append("DATE INVALID          HAC ");
        }
        sb.append(this.getActionRepresentation(hac30b));
        sb.append("\r\n");
        if (this.hostID != null) {
            sb.append(bundle.getString("HOSTNAME"));
            sb.append(this.hostID);
            sb.append("\r\n");
        }
        if (this.orderType != null) {
            sb.append(bundle.getString("ORDER"));
            sb.append(this.orderType);
            if (this.orderID != null) {
                sb.append(" ");
                sb.append(this.orderID);
            }
            sb.append("\r\n");
        }
        if (this.partnerID != null) {
            sb.append(bundle.getString("CUSTOMER"));
            sb.append(this.partnerID);
            if (this.userID != null) {
                sb.append(" ");
                sb.append(this.userID);
            }
            if (this.systemID != null) {
                sb.append(" (");
                sb.append(this.systemID);
                sb.append(")");
            }
            sb.append("\r\n");
        }
        if (this.fileFormat != null) {
            sb.append(bundle.getString("ORDER"));
            sb.append(this.fileFormat);
            if (this.orderID != null) {
                sb.append(" ");
                sb.append(this.orderID);
            }
            sb.append("\r\n");
        }
        if (this.orderTypeRef != null) {
            sb.append(bundle.getString("REFERENCE"));
            sb.append(this.orderTypeRef);
            if (this.orderIDRef != null) {
                sb.append(" ");
                sb.append(this.orderIDRef);
            }
            if (this.partnerIDRef != null) {
                sb.append(" (");
                sb.append(this.partnerIDRef);
                sb.append(")");
            }
            sb.append("\r\n");
        }
        if (this.rsn != null) {
            sb.append(bundle.getString("RESULT"));
            sb.append(this.getReasonMessage(hac30b));
            sb.append("\r\n");
        }
        if (this.addtlInfs != null) {
            sb.append("\r\n");
            sb.append(this.addtlInfs);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        HAC30Entry.append(sb, "HostID", this.hostID);
        HAC30Entry.append(sb, "Action", this.action.name());
        HAC30Entry.append(sb, "TimeStamp", this.timeStamp);
        HAC30Entry.append(sb, "Rsn", this.rsn);
        HAC30Entry.append(sb, "PartnerID", this.partnerID);
        HAC30Entry.append(sb, "UserID", this.userID);
        HAC30Entry.append(sb, "SystemID", this.systemID);
        HAC30Entry.append(sb, "OrderType", this.orderType);
        HAC30Entry.append(sb, "FileFormat", this.fileFormat);
        HAC30Entry.append(sb, "OrderID", this.orderID);
        HAC30Entry.append(sb, "PartnerIDRef", this.partnerIDRef);
        HAC30Entry.append(sb, "OrderTypeRef", this.orderTypeRef);
        HAC30Entry.append(sb, "OrderIDRef", this.orderIDRef);
        if (this.btf != null) {
            HAC30Entry.append(sb, "BTF", BTFTranslator.convertToString(this.btf.getService()));
        }
        if (this.btfRef != null) {
            HAC30Entry.append(sb, "BTFRef", BTFTranslator.convertToString(this.btfRef.getService()));
        }
        if (this.addtlInfs != null) {
            sb.append(this.addtlInfs);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(HAC30Entry o) {
        Date otherTimeStamp;
        Date myTimeStamp;
        int result = 0;
        if (o == null) {
            return 1;
        }
        try {
            myTimeStamp = this.getTimeStamp();
        }
        catch (ParseException e) {
            myTimeStamp = null;
        }
        try {
            otherTimeStamp = o.getTimeStamp();
        }
        catch (ParseException e) {
            otherTimeStamp = null;
        }
        if (myTimeStamp == null) {
            if (otherTimeStamp != null) {
                result = -1;
            }
        } else {
            result = otherTimeStamp != null ? myTimeStamp.compareTo(otherTimeStamp) : 1;
        }
        if (result == 0) {
            result = this.action.compareTo(o.action);
        }
        return result;
    }

    public byte[] getOpi() {
        return this.opi;
    }

    public BTF getBTF() {
        return this.btf;
    }

    BTF ensureBTF() {
        this.h005 = true;
        if (this.btf == null) {
            this.btf = new BTF();
        }
        return this.btf;
    }

    BTF ensureBTFRef() {
        this.h005 = true;
        if (this.btfRef == null) {
            this.btfRef = new BTF();
        }
        return this.btfRef;
    }

    public BTF getBTFRef() {
        return this.btfRef;
    }

    public String getBTFString() {
        if (this.btfRef != null) {
            return BTFTranslator.convertToString(this.btfRef.getService());
        }
        if (this.btf != null) {
            return BTFTranslator.convertToString(this.btf.getService());
        }
        return null;
    }

    public String getOrderIdString() {
        if (this.orderIDRef != null) {
            return this.orderIDRef;
        }
        return this.orderID;
    }

    public String getOrderTypeString() {
        if (this.orderTypeRef != null) {
            return this.orderTypeRef;
        }
        return this.orderType;
    }

    public OriginalPaymentInformation1 getOpiElement() {
        if (this.opi == null) {
            return null;
        }
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(null, "OrgnlPmtInfAndSts", OriginalPaymentInformation1.class);
        try {
            return (OriginalPaymentInformation1)EbicsHandler.parse(new ByteArrayInputStream(this.opi), p, null);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        InputStream in = PTKParser.class.getResourceAsStream("/de/businesslogics/format/iso20022/pain00200103/license");
        if (in != null) {
            new UnsignedJarLicense(in);
        }
    }

    public static enum Action {
        FILE_UPLOAD,
        FILE_DOWNLOAD,
        ES_UPLOAD,
        ES_DOWNLOAD,
        ES_VERIFICATION,
        VEU_FORWARDING,
        VEU_VERIFICATION,
        VEU_VERIFICATION_END,
        VEU_CANCEL_ORDER,
        ADDITIONAL,
        ORDER_HAC_FINAL_POS,
        ORDER_HAC_FINAL_NEG,
        ORDER_HAC_FINAL;

    }

    public static enum HACState {
        OK,
        NOK,
        CANCELLED,
        PROBABELY_OK,
        PROBABELY_NOK;

    }

    public static enum ReasonCode {
        LIMIT_EXCEEDED("AM21"),
        ELECTRONIC_SIGNATURES_CORRECT("DS01"),
        ORDER_CANCELLED("DS02"),
        ORDER_NOT_CANCELLED("DS03"),
        ORDER_REJECTED("DS04"),
        ORDER_FORWARDED_FOR_POSTPROCESSING("DS05"),
        TRANSFER_ORDER("DS06"),
        PROCESSING_OK("DS07"),
        DECOMPRESSION_ERROR("DS08"),
        DECRYPTION_ERROR("DS09"),
        SIGNER_1_CERTIFICATE_REVOKED("DS10"),
        SIGNER_1_CERTIFICATE_NOT_VALID("DS11"),
        INCORRECT_SIGNER_1_CERTIFICATE("DS12"),
        SIGNER_CERTIFICATION_AUTHORITY_SIGNER_1_NOT_VALID("DS13"),
        USER_DOES_NOT_EXIST("DS14"),
        IDENTICAL_SIGNATURE_FOUND("DS15"),
        PUBLIC_KEY_VERSION_INCORRECT("DS16"),
        DIFFERENT_ORDER_DATA_IN_SIGNATURES("DS17"),
        REPEAT_ORDER("DS18"),
        ELECTRONIC_SIGNATURE_RIGHTS_INSUFFICIENT("DS19"),
        SIGNER_2_CERTIFICATE_REVOKED("DS20"),
        SIGNER_2_CERTIFICATE_NOT_VALID("DS21"),
        INCORRECT_SIGNER_2_CERTIFICATE("DS22"),
        SIGNER_CERTIFICATION_AUTHORITY_SIGNER_2_NOT_VALID("DS23"),
        WAITING_TIME_EXPIRED("DS24"),
        ORDER_FILE_DELETED("DS25"),
        USER_SIGNED_MULTIPLE_TIMES("DS26"),
        USER_NOT_YET_ACTIVATED("DS27"),
        DATA_SIGN_REQUESTED("DS0A"),
        UNKNOWN_DATA_SIGN_FORMAT("DS0B"),
        SIGNER_CERTIFICATE_REVOKED("DS0C"),
        SIGNER_CERTIFICATE_NOT_VALID("DS0D"),
        INCORRECT_SIGNER_CERTIFICATE("DS0E"),
        SIGNER_CERTIFICATION_AUTHORITY("DS0F"),
        NOT_ALLOWED_PAYMENT("DS0G"),
        NOT_ALLOWED_ACCOUNT("DS0H"),
        CORRESPONDING_ORIGINAL_FILE_STILL_NOT_SENT("ID01"),
        TRANSMISSION_ABORTED("TA01"),
        NO_DATA_AVAILABLE("TD01"),
        FILE_NON_READABLE("TD02"),
        INCORRECT_FILE_STRUCTURE("TD03"),
        TRANSMISSION_SUCCESSFUL("TS01"),
        TRANSFER_TO_SIGN_BY_HAND("TS04");

        private final String isoCode;

        private ReasonCode(String isoCode) {
            this.isoCode = isoCode;
        }

        public static ReasonCode getByIsoCode(String isoCode) {
            for (ReasonCode reasonCode : ReasonCode.values()) {
                if (!reasonCode.isoCode.equals(isoCode)) continue;
                return reasonCode;
            }
            return null;
        }

        public String getIsoCode() {
            return this.isoCode;
        }
    }
}

