/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.iso20022.pain00200102;

import de.businesslogics.bcs.core.YYYYMMDDHHMMSS;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.pain00200102.Document;
import de.businesslogics.format.iso20022.pain00200102.GenericIdentification3;
import de.businesslogics.format.iso20022.pain00200102.GroupHeader5;
import de.businesslogics.format.iso20022.pain00200102.Max35Text;
import de.businesslogics.format.iso20022.pain00200102.OrganisationIdentification2;
import de.businesslogics.format.iso20022.pain00200102.OriginalGroupInformation1;
import de.businesslogics.format.iso20022.pain00200102.Pain_002_001_02;
import de.businesslogics.format.iso20022.pain00200102.Party2Choice;
import de.businesslogics.format.iso20022.pain00200102.PartyIdentification8;
import de.businesslogics.format.iso20022.pain00200102.TransactionGroupStatus1Code;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.PTKEnumeration;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.SignatureResult;
import de.businesslogics.format.sepa.MultipleInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.xml.sax.SAXException;

public class PSREngine
implements PTKEnumeration {
    private LinkedList<Document> documents = new LinkedList();

    public PSREngine(InputStream is) throws SAXException, IOException {
        MultipleInputStream mis = new MultipleInputStream(is);
        do {
            Document d = new Document();
            EbicsRootParser p = new EbicsRootParser("urn:iso:std:iso:20022:tech:xsd:pain.002.001.02", d);
            EbicsHandler h = new EbicsHandler(p);
            h.setValidate(false);
            h.parse(mis);
            this.documents.add(d);
        } while (mis.reopen());
        mis.realClose();
    }

    @Override
    public PTKEntry nextEntry() throws IOException, ParseException {
        Document d;
        while ((d = this.documents.poll()) != null) {
            OrganisationIdentification2 o2;
            Pain_002_001_02 p = d.getPain_002_001_02();
            GroupHeader5 gh = p.getGrpHdr();
            YYYYMMDDHHMMSS date = new YYYYMMDDHHMMSS(gh.getCreDtTm().getDate().getTime());
            OriginalGroupInformation1 ogi = p.getOrgnlGrpInfAndSts();
            Max35Text orgnlMsgId = ogi.getChoice1().getOrgnlMsgId();
            TransactionGroupStatus1Code grpSts = ogi.getGrpSts();
            if (grpSts == null || orgnlMsgId == null || orgnlMsgId.getValue().length() != 4) continue;
            OrderInfo orderInfo = new OrderInfo("FUL." + ogi.getOrgnlMsgNmId().getValue(), orgnlMsgId.getValue());
            Result result = "RCVD".equals(grpSts.getValue()) ? Result.SIGNATURES_OK : Result.SIGNATURES_NOK;
            SignatureResult sr = new SignatureResult(null, result, null, null, null, false);
            ArrayList<String> l = new ArrayList<String>();
            l.add(d.toString());
            SimpleStringElement hostId = null;
            PartyIdentification8 pi = gh.getInitgPty();
            Party2Choice pc = gh.getInitgPty().getId();
            if (pc != null && (o2 = pc.getChoice1().getOrgId()) != null) {
                GenericIdentification3 gi;
                hostId = o2.getBIC();
                if (hostId == null) {
                    hostId = o2.getBEI();
                }
                if (hostId == null && (gi = o2.getPrtryId()) != null) {
                    hostId = gi.getId();
                }
            }
            if (hostId == null && (hostId = pi.getNm()) == null) continue;
            return new PTKEntry(date, Action.SIGNATURE_CHECK, hostId.getValue(), orderInfo, sr, l);
        }
        return null;
    }
}

