/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta.csv;

import de.businesslogics.format.csv.BaseFormat;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.DateUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;

public class Format
extends BaseFormat {
    public static final String SEPARATOR = "|";
    private static final String BLZ_PREFIX = "///";
    public static Format DEFAULT_FORMAT = new Format(Fields.ORIGINATOR_NAME, Fields.ORIGINATOR_NAME2, Fields.ORIGINATOR_STREET, Fields.ORIGINATOR_TOWN, Fields.ORIGINATOR_ACCOUNT_NUMBER, Fields.ORIGINATOR_BLZ, Fields.ORIGINATOR_ACCOUNT_CURRENCY, Fields.RECIPIENT_NAME, Fields.RECIPIENT_NAME2, Fields.RECIPIENT_STREET, Fields.RECIPIENT_TOWN, Fields.RECIPIENT_COUNTRY, Fields.RECIPIENT_ACCOUNT_NUMBER, Fields.RECIPIENT_BANK_CODE, Fields.RECIPIENT_BANK_NAME, Fields.RECIPIENT_BANK_NAME2, Fields.RECIPIENT_BANK_STREET, Fields.RECIPIENT_BANK_TOWN, Fields.RECIPIENT_BANK_COUNTRY, Fields.AMOUNT, Fields.CURRENCY, Fields.DATE, Fields.PURPOSE1, Fields.PURPOSE2, Fields.PURPOSE3, Fields.PURPOSE4, Fields.FEE_TYPE, Fields.INSTRUCTION_CODE1, Fields.INSTRUCTION_CODE2, Fields.INSTRUCTION_CODE3, Fields.INSTRUCTION_CODE4, Fields.INSTRUCTIONS, Fields.PAYMENT_TYPE);
    private final Map<Fields, Column> mapping = new HashMap<Fields, Column>();
    private int minimum = -1;

    public Column getColumn(Fields field) {
        return this.mapping.get((Object)field);
    }

    public Format(String definition, String language) {
        String[] columns;
        if (language != null) {
            this.numberFormat = NumberFormat.getInstance(new Locale(language));
        }
        if ((columns = definition.split("\\|")) == null || columns.length <= 1) {
            columns = definition.split(",");
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].length() <= 0) continue;
            Fields f = Fields.values()[i];
            if (columns[i].startsWith("=")) {
                this.mapping.put(f, new Column(columns[i].substring(1), f.name(), f.maxLength, f.pattern));
                continue;
            }
            try {
                this.mapping.put(f, new Column(Integer.parseInt(columns[i]), f.name(), f.maxLength, f.pattern));
                continue;
            }
            catch (NumberFormatException nf) {
                this.mapping.put(f, new Column(CellReference.convertColStringToIndex((String)columns[i]), f.name(), f.maxLength, f.pattern));
            }
        }
    }

    private Format(Fields ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            Fields field = fields[i];
            this.mapping.put(field, new Column(i, field.name(), field.maxLength, field.pattern));
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Fields f : Fields.values()) {
            Column c = this.mapping.get((Object)f);
            if (c != null) {
                if (b.length() > 0) {
                    b.append(SEPARATOR);
                }
                if (c.getValue() != null) {
                    b.append("=");
                    b.append(c.getValue());
                    continue;
                }
                b.append(c.getColumnIndex());
                continue;
            }
            b.append(SEPARATOR);
        }
        return b.toString();
    }

    @Override
    protected int minimumColumns() {
        if (this.minimum < 0) {
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_ACCOUNT_NUMBER).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_BLZ).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_ACCOUNT_CURRENCY).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_COUNTRY).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_ACCOUNT_NUMBER).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_BANK_CODE).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.AMOUNT).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.CURRENCY).getColumnIndex());
        }
        return this.minimum;
    }

    @Override
    protected String validateRow(Row row, String[] row2) {
        String error = this.checkString(row, row2, this.mapping.get((Object)Fields.ORIGINATOR_ACCOUNT_NUMBER), RegularExpressions.GERMAN_ACCOUNT_NUMBER);
        if (error != null) {
            return error;
        }
        error = this.checkString(row, row2, this.mapping.get((Object)Fields.ORIGINATOR_BLZ), RegularExpressions.GERMAN_BANK_CODE);
        if (error != null) {
            return error;
        }
        error = this.checkAmount(row, row2, this.mapping.get((Object)Fields.AMOUNT));
        if (error != null) {
            return error;
        }
        return null;
    }

    @Override
    protected String getValidString(String s, int maxFieldLength) {
        return SEPAUtil.getSEPAString(s, maxFieldLength, null).toUpperCase();
    }

    public DTAZVPayment getPaymentData(Row row) throws IOException {
        return this.getPaymentData(row, null, row.getRowNum());
    }

    public DTAZVPayment getPaymentData(String[] row, int line) throws IOException {
        return this.getPaymentData(null, row, line);
    }

    private DTAZVPayment getPaymentData(Row row, String[] row2, int line) throws IOException {
        String reference;
        String accNumber = this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_ACCOUNT_NUMBER), true);
        long accountNumber = accNumber != null ? Long.parseLong(accNumber) : 0L;
        String origBankCode = this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_BLZ), true);
        int blz = origBankCode != null ? Integer.parseInt(origBankCode) : 0;
        String accountCurrency = this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_ACCOUNT_CURRENCY), true);
        Date executionDate = this.getDate(row, row2, line, this.mapping.get((Object)Fields.DATE), false);
        if (executionDate == null) {
            executionDate = DateUtils.getNextWorkingDay(Calendar.getInstance()).getTime();
        }
        DTAZVPayment p = new DTAZVPayment();
        p.setBlz(blz);
        p.setCustomerNumber(accountNumber);
        p.setOriginator(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_NAME), true));
        p.setOriginator2(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_NAME2), false));
        p.setOriginator3(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_STREET), false));
        p.setOriginator4(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_TOWN), false));
        p.setExecutionDate(executionDate);
        DTAZVTransaction t = new DTAZVTransaction();
        t.setBlz(blz);
        t.setAccountCurrency(accountCurrency);
        t.setAccount(accountNumber);
        t.setExecutionDate(executionDate);
        Object bankCode = this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_CODE), false);
        if (bankCode != null && RegularExpressions.GERMAN_BANK_CODE.matches((String)bankCode)) {
            bankCode = BLZ_PREFIX + (String)bankCode;
        }
        t.setBic((String)bankCode);
        t.setBankCountry(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_COUNTRY), false));
        t.setBank(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_NAME), false));
        t.setBank2(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_NAME2), false));
        t.setBank3(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_STREET), false));
        t.setBank4(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BANK_TOWN), false));
        this.checkRecipientBank(t, line);
        t.setRecipientCountry(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_COUNTRY), true));
        t.setRecipient(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_NAME), true));
        t.setRecipient2(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_NAME2), false));
        t.setRecipient3(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_STREET), false));
        t.setRecipient4(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_TOWN), false));
        String recipientAccountNumber = this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_ACCOUNT_NUMBER), true);
        String recipientIban = StringUtils.removeAllWhitespace(recipientAccountNumber);
        if (IbanUtil.checkIban(recipientIban)) {
            recipientAccountNumber = recipientIban;
        }
        t.setIban("/" + recipientAccountNumber);
        t.setCurrency(this.getString(row, row2, line, this.mapping.get((Object)Fields.CURRENCY), true));
        t.setAmount(this.getAmount(row, row2, line, this.mapping.get((Object)Fields.AMOUNT)));
        t.setPurpose(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE1), false));
        t.setPurpose2(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE2), false));
        t.setPurpose3(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE3), false));
        t.setPurpose4(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE4), false));
        String feeType = this.getString(row, row2, line, this.mapping.get((Object)Fields.FEE_TYPE), false);
        t.setFeeType(Byte.parseByte(feeType));
        String instCode1 = this.getString(row, row2, line, this.mapping.get((Object)Fields.INSTRUCTION_CODE1), false);
        String instCode2 = this.getString(row, row2, line, this.mapping.get((Object)Fields.INSTRUCTION_CODE2), false);
        String instCode3 = this.getString(row, row2, line, this.mapping.get((Object)Fields.INSTRUCTION_CODE3), false);
        String instCode4 = this.getString(row, row2, line, this.mapping.get((Object)Fields.INSTRUCTION_CODE4), false);
        if (instCode1 != null) {
            t.setInstructionCode(Byte.parseByte(instCode1));
        }
        if (instCode2 != null) {
            t.setInstructionCode2(Byte.parseByte(instCode2));
        }
        if (instCode3 != null) {
            t.setInstructionCode3(Byte.parseByte(instCode3));
        }
        if (instCode4 != null) {
            t.setInstructionCode4(Byte.parseByte(instCode4));
        }
        t.setInstructions(this.getString(row, row2, line, this.mapping.get((Object)Fields.INSTRUCTIONS), false));
        String paymentType = this.getString(row, row2, line, this.mapping.get((Object)Fields.PAYMENT_TYPE), false);
        if (paymentType != null) {
            t.setPaymentType(Byte.parseByte(paymentType));
        }
        if ((reference = this.getString(row, row2, line, this.mapping.get((Object)Fields.REFERENCE), false)) != null) {
            t.setReference(reference);
        }
        p.getTransactions().add(t);
        return p;
    }

    private void checkRecipientBank(DTAZVTransaction t, int line) throws IOException {
        String bankCode = t.getBic();
        if (!(bankCode != null && (RegularExpressions.BIC.matches(bankCode) || bankCode.startsWith(BLZ_PREFIX) && RegularExpressions.GERMAN_BANK_CODE.matches(bankCode.substring(2))))) {
            if (t.getBank() == null || t.getBank().trim().length() == 0) {
                throw new CSVConverterException(this.getMissingBicOrBankAddressMessage(line), line);
            }
            if (t.getBank3() == null || t.getBank3().trim().length() == 0) {
                throw new CSVConverterException(this.getMissingBicOrBankAddressMessage(line), line);
            }
            if (t.getBank4() == null || t.getBank4().trim().length() == 0) {
                throw new CSVConverterException(this.getMissingBicOrBankAddressMessage(line), line);
            }
            if (t.getBankCountry() == null || t.getBankCountry().trim().length() == 0) {
                throw new CSVConverterException(this.getMissingBicOrBankAddressMessage(line), line);
            }
        }
    }

    private DTAZVPayment getDemoPayment() {
        DTAZVPayment paymentFile = new DTAZVPayment();
        paymentFile.setBlz(12345678);
        paymentFile.setCustomerNumber(987654321L);
        paymentFile.setOriginator("Auftraggeber Name 1");
        paymentFile.setOriginator2("Auftraggeber Name 2");
        paymentFile.setOriginator3("Auftraggeber Strasse");
        paymentFile.setOriginator4("Auftraggeber Ort");
        DTAZVTransaction t = new DTAZVTransaction();
        t.setAccount(1234567890L);
        t.setBlz(12345678);
        t.setAccountCurrency("EUR");
        t.setRecipient("Empfaenger Name 1");
        t.setRecipient2("Empfaenger Name 2");
        t.setRecipient3("Empfaenger Strasse");
        t.setRecipient4("Empfaenger Ort");
        t.setRecipientCountry("Frankreich");
        t.setIban("FR12345678901234567890");
        t.setBic("BICODE00");
        t.setCurrency("EUR");
        t.setAmount(new BigDecimal("123.45"));
        t.setPurpose("Verwendungszweck Zeile 1");
        t.setPurpose2("Verwendungszweck Zeile 2");
        t.setPurpose3("Verwendungszweck Zeile 3");
        t.setPurpose4("Verwendungszweck Zeile 4");
        t.setReference("Dies ist meine Referenz");
        paymentFile.getTransactions().add(t);
        return paymentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Format> parseFile(File in) throws IOException {
        ArrayList<Format> toReturn;
        block10: {
            toReturn = new ArrayList<Format>();
            Format current = null;
            Scanner s = new Scanner(in);
            block5: while (true) {
                while (s.hasNextLine()) {
                    int div;
                    String line = s.nextLine();
                    if (line == null || line.trim().isEmpty() || line.startsWith("#")) continue;
                    if (line.startsWith("[")) {
                        current = new Format(new Fields[0]);
                        toReturn.add(current);
                        continue;
                    }
                    if (current == null) {
                        current = new Format(new Fields[0]);
                        toReturn.add(current);
                    }
                    String key = (div = line.indexOf(61)) > 0 ? line.substring(0, div).trim() : line;
                    String value = div > 0 ? line.substring(div + 1) : null;
                    Fields f = Fields.valueOf(key);
                    if (value.startsWith("=")) {
                        current.mapping.put(f, new Column(value.substring(1), f.name(), f.maxLength, f.pattern));
                        continue;
                    }
                    try {
                        int c = Integer.parseInt(value);
                        current.mapping.put(f, new Column(c, f.name(), f.maxLength, f.pattern));
                        continue block5;
                    }
                    catch (NumberFormatException nf) {
                        current.mapping.put(f, new Column(CellReference.convertColStringToIndex((String)value), f.name(), f.maxLength, f.pattern));
                    }
                }
                break block10;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                s.close();
            }
        }
        return toReturn;
    }

    public static enum Fields {
        ORIGINATOR_NAME(35),
        ORIGINATOR_NAME2(35),
        ORIGINATOR_STREET(35),
        ORIGINATOR_TOWN(35),
        ORIGINATOR_ACCOUNT_NUMBER(RegularExpressions.GERMAN_ACCOUNT_NUMBER),
        ORIGINATOR_BLZ(RegularExpressions.GERMAN_BANK_CODE),
        ORIGINATOR_ACCOUNT_CURRENCY(3),
        RECIPIENT_NAME(35),
        RECIPIENT_NAME2(35),
        RECIPIENT_STREET(35),
        RECIPIENT_TOWN(35),
        RECIPIENT_COUNTRY(2),
        RECIPIENT_ACCOUNT_NUMBER(35),
        RECIPIENT_BANK_CODE(11),
        RECIPIENT_BANK_NAME(35),
        RECIPIENT_BANK_NAME2(35),
        RECIPIENT_BANK_STREET(35),
        RECIPIENT_BANK_TOWN(35),
        RECIPIENT_BANK_COUNTRY(2),
        AMOUNT(-1),
        CURRENCY(3),
        DATE(-1),
        PURPOSE1(35),
        PURPOSE2(35),
        PURPOSE3(35),
        PURPOSE4(35),
        FEE_TYPE(2),
        INSTRUCTION_CODE1(2),
        INSTRUCTION_CODE2(2),
        INSTRUCTION_CODE3(2),
        INSTRUCTION_CODE4(2),
        INSTRUCTIONS(25),
        PAYMENT_TYPE(2),
        REFERENCE(27);

        private int maxLength = -1;
        private RegularExpressions pattern;

        private Fields(int maxLength) {
            this.maxLength = maxLength;
        }

        private Fields(RegularExpressions pattern) {
            this.pattern = pattern;
        }
    }
}

