/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta.csv;

import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.csv.SeqNumberGenerator;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.csv.Format;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.license.License;
import de.businesslogics.util.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.xml.sax.SAXException;

public class Converter {
    private static JFrame UI_FRAME = null;
    protected static boolean guiUsed = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCSVFile(File in, Format format, boolean hasHeader) {
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line = r.readLine();
            boolean hasReadHeader = !hasHeader;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (format.checkRow(row) == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (hasReadHeader) {
                        boolean bl = false;
                        return bl;
                    }
                    hasReadHeader = true;
                }
                line = r.readLine();
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List<File> convertCSVFile(File originalFile, Format format, boolean hasHeader, SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder) throws IOException, SAXException {
        boolean hasReadHeader = !hasHeader;
        int lineCounter = 0;
        ArrayList<DTAZVPayment> payments = new ArrayList<DTAZVPayment>();
        try (BufferedReader r = new BufferedReader(new FileReader(originalFile));){
            String line = r.readLine();
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (!hasReadHeader) {
                        hasReadHeader = true;
                        if (format.checkRow(row) != null) {
                            line = r.readLine();
                            continue;
                        }
                    }
                    payments.add(format.getPaymentData(row, ++lineCounter));
                }
                line = r.readLine();
            }
        }
        return Converter.writeFiles(payments, originalFile, seqNumberGenerator, oneLogicalFilePerOrder);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int checkXLS(File f, Format format, boolean hasHeader) {
        try (Workbook workbook = XLSUtil.createWorkbook(f);){
            block8: for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                boolean hasReadHeader;
                Sheet sheet = workbook.getSheetAt(i);
                boolean bl = hasReadHeader = !hasHeader;
                for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                    Row r = sheet.getRow(row);
                    if (r == null) continue;
                    if (format.checkRow(r) == null) {
                        int n = i;
                        return n;
                    }
                    if (hasReadHeader) continue block8;
                    hasReadHeader = true;
                }
            }
            int n = -1;
            return n;
        }
        catch (Exception format1) {
            return -1;
        }
    }

    public static List<File> convertXLS(File f, int sheetIndex, Format format, boolean hasHeader, SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder) throws IOException, SAXException {
        int startRow;
        Sheet sheet = null;
        try (Workbook workbook = XLSUtil.createWorkbook(f);){
            if (sheetIndex < 0 || sheetIndex >= workbook.getNumberOfSheets()) {
                throw new IOException("No sheet with index = " + sheetIndex);
            }
            sheet = workbook.getSheetAt(sheetIndex);
        }
        ArrayList<DTAZVPayment> payments = new ArrayList<DTAZVPayment>();
        boolean hasReadHeader = !hasHeader;
        for (int i = startRow = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            if (!hasReadHeader) {
                hasReadHeader = true;
                if (format.checkRow(row) != null) continue;
            }
            payments.add(format.getPaymentData(row));
        }
        return Converter.writeFiles(payments, f, seqNumberGenerator, oneLogicalFilePerOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> writeFiles(List<DTAZVPayment> payments, File originalFile, SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder) throws IOException, SAXException {
        String logicalFileKey;
        if (payments == null) return null;
        if (payments.isEmpty()) {
            return null;
        }
        ArrayList<String> logicalFileKeys = new ArrayList<String>();
        HashMap<String, DTAZVPayment> logicalFilesMap = new HashMap<String, DTAZVPayment>();
        for (DTAZVPayment dTAZVPayment : payments) {
            logicalFileKey = Converter.getLogicalFileKey(dTAZVPayment);
            if (logicalFilesMap.containsKey(logicalFileKey)) {
                DTAZVPayment logicalFile = (DTAZVPayment)logicalFilesMap.get(logicalFileKey);
                logicalFile.getTransactions().addAll(dTAZVPayment.getTransactions());
                continue;
            }
            logicalFileKeys.add(logicalFileKey);
            dTAZVPayment.setCreationDate(new Date());
            if (seqNumberGenerator != null) {
                dTAZVPayment.setSequentialNumber((byte)seqNumberGenerator.getNextNumber());
            }
            logicalFilesMap.put(logicalFileKey, dTAZVPayment);
        }
        ArrayList<File> convertedFiles = new ArrayList<File>();
        if (oneLogicalFilePerOrder) {
            Iterator iterator = logicalFileKeys.iterator();
            while (iterator.hasNext()) {
                logicalFileKey = (String)iterator.next();
                File file = File.createTempFile(originalFile.getName() + ".", ".DTAZV", originalFile.getAbsoluteFile().getParentFile());
                CountingFilterOutputStream out2 = null;
                DTAWriter writer2 = null;
                try {
                    out2 = new CountingFilterOutputStream(new FileOutputStream(file));
                    writer2 = new DTAWriter(out2);
                    DTAZVPayment logicalFile = (DTAZVPayment)logicalFilesMap.get(logicalFileKey);
                    Converter.setEarliestExecutionDateInQ8(logicalFile);
                    logicalFile.writeTo(writer2);
                    convertedFiles.add(file);
                }
                catch (Throwable throwable) {
                    writer2.close();
                    SystemUtils.close(out2);
                    throw throwable;
                }
                writer2.close();
                SystemUtils.close(out2);
            }
            return convertedFiles;
        }
        File file = File.createTempFile(originalFile.getName() + ".", ".DTAZV", originalFile.getAbsoluteFile().getParentFile());
        CountingFilterOutputStream out = null;
        DTAWriter writer = null;
        try {
            out = new CountingFilterOutputStream(new FileOutputStream(file));
            writer = new DTAWriter(out);
            for (String logicalFileKey2 : logicalFileKeys) {
                DTAZVPayment logicalFile = (DTAZVPayment)logicalFilesMap.get(logicalFileKey2);
                Converter.setEarliestExecutionDateInQ8(logicalFile);
                logicalFile.writeTo(writer);
            }
            convertedFiles.add(file);
        }
        catch (Throwable throwable) {
            writer.close();
            SystemUtils.close(out);
            throw throwable;
        }
        writer.close();
        SystemUtils.close(out);
        return convertedFiles;
    }

    private static void setEarliestExecutionDateInQ8(DTAZVPayment group) {
        Date earliestExecutionDate = null;
        for (DTAZVTransaction o : group.getTransactions()) {
            Date executionDate;
            if (!(o instanceof DTAZVTransaction) || (executionDate = o.getExecutionDate()) == null || earliestExecutionDate != null && !earliestExecutionDate.after(executionDate)) continue;
            earliestExecutionDate = executionDate;
        }
        if (earliestExecutionDate != null) {
            group.setExecutionDate(earliestExecutionDate);
        }
    }

    private static String getLogicalFileKey(DTAZVPayment p) {
        String SEPARATOR = ":";
        StringBuffer sb = new StringBuffer();
        sb.append(p.getBlz());
        sb.append(":");
        sb.append(p.getCustomerNumber());
        sb.append(":");
        sb.append(p.getOriginator());
        sb.append(":");
        sb.append(p.getOriginator2());
        sb.append(":");
        sb.append(p.getOriginator3());
        sb.append(":");
        sb.append(p.getOriginator4());
        sb.append(":");
        sb.append(p.isBundesbankReport());
        sb.append(":");
        sb.append(p.getCountryCode());
        sb.append(":");
        sb.append(p.getCompanyCode());
        return sb.toString();
    }

    public static void main(String[] args) {
        File in = null;
        File out = null;
        if (args != null && args.length >= 1) {
            in = new File(args[0]);
            if (args != null && args.length >= 2) {
                out = new File(args[1]);
            }
        }
        if (guiUsed) {
            UI_FRAME = new JFrame("BL CSV-DTAZV Converter");
            UI_FRAME.setDefaultCloseOperation(3);
        }
        if (in == null) {
            in = new File(".");
        }
        boolean successful = false;
        try {
            License l = License.getLicense();
            l.checkValid();
            successful = Converter.doIt(in, out);
        }
        catch (Exception e) {
            Converter.showException("Error occurred", e);
        }
        if (guiUsed) {
            UI_FRAME.dispose();
        }
        if (!successful) {
            System.exit(1);
        }
    }

    private static boolean doIt(File in, File out) throws Exception {
        File dir = in.isDirectory() ? in : in.getParentFile();
        File formatDefinition = new File(dir, "format.txt");
        ArrayList<Format> formats = new ArrayList<Format>();
        if (formatDefinition.exists()) {
            try {
                formats.addAll(Format.parseFile(formatDefinition));
            }
            catch (Exception e) {
                Converter.showException("Error reading format.txt", e);
                return false;
            }
        }
        formats.add(Format.DEFAULT_FORMAT);
        File[] filesToConvert = null;
        filesToConvert = in.isDirectory() ? in.listFiles(new ConverterFilter()) : new File[]{in};
        if (filesToConvert == null || filesToConvert.length == 0) {
            Converter.showWarning("No files found", "There are no files to convert. Check that there are files in " + in.getAbsolutePath());
            return false;
        }
        boolean returnValue = true;
        for (File f : filesToConvert) {
            returnValue = returnValue && Converter.convertFile(f, formats, out);
        }
        return returnValue;
    }

    private static boolean convertFile(File f, List<Format> formats, File out) throws IOException, SAXException {
        SeqNumberGenerator gen = new SeqNumberGenerator(1, 1, 99);
        List<File> filesWritten = null;
        for (Format format : formats) {
            int sheet = Converter.checkXLS(f, format, true);
            if (sheet < 0) continue;
            filesWritten = Converter.convertXLS(f, sheet, format, true, gen, false);
            Converter.renameFiles(filesWritten, out);
            return true;
        }
        for (Format format : formats) {
            if (!Converter.checkCSVFile(f, format, true)) continue;
            filesWritten = Converter.convertCSVFile(f, format, true, gen, false);
            Converter.renameFiles(filesWritten, out);
            return true;
        }
        Converter.showWarning("Unknown file format", "Unknown format of file '" + f.getAbsolutePath() + "'");
        return false;
    }

    private static void renameFiles(List<File> files, File out) {
        if (out == null) {
            return;
        }
        if (out.isDirectory()) {
            for (File f : files) {
                f.renameTo(new File(out, f.getName()));
            }
        } else {
            for (File f : files) {
                File tmp = out;
                int count = 0;
                while (tmp.exists()) {
                    tmp = new File(out.getParentFile(), out.getName() + count);
                    ++count;
                }
                f.renameTo(tmp);
            }
        }
    }

    public static JOptionPane getNarrowOptionPane(int maxCharactersPerLineCount) {
        class NarrowOptionPane
        extends JOptionPane {
            private static final long serialVersionUID = 1L;
            int maxCharactersPerLineCount;

            NarrowOptionPane(int maxCharactersPerLineCount) {
                this.maxCharactersPerLineCount = maxCharactersPerLineCount;
            }

            @Override
            public int getMaxCharactersPerLineCount() {
                return this.maxCharactersPerLineCount;
            }
        }
        return new NarrowOptionPane(maxCharactersPerLineCount);
    }

    private static void showWarning(String title, String message) {
        if (guiUsed) {
            JOptionPane pane = Converter.getNarrowOptionPane(80);
            pane.setMessage(message);
            pane.setMessageType(2);
            JDialog dialog = pane.createDialog(UI_FRAME, title);
            dialog.setVisible(true);
        } else {
            System.out.println(title + ": " + message);
        }
    }

    private static void showException(String title, Exception e) {
        if (guiUsed) {
            JOptionPane pane = Converter.getNarrowOptionPane(80);
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            e.printStackTrace(p);
            p.close();
            pane.setMessage(w.toString());
            pane.setMessageType(0);
            JDialog dialog = pane.createDialog(UI_FRAME, title);
            dialog.setVisible(true);
        } else {
            System.err.println(title);
            e.printStackTrace(System.err);
        }
    }

    private static class ConverterFilter
    implements FilenameFilter {
        private ConverterFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xls") || name.endsWith(".xlsx") || name.endsWith(".csv");
        }
    }
}

