/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.format.dta.InvalidHeaderException;

public class SLF {
    private final int length;
    private final boolean compressed;
    public static final SLF SLF_4_UNCOMPRESSED = new SLF(4, false);
    public static final SLF SLF_4_COMPRESSED = new SLF(4, true);
    public static final SLF SLF_6_UNCOMPRESSED = new SLF(6, false);

    private SLF(int length, boolean compressed) {
        this.length = length;
        this.compressed = compressed;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public int getBlockLength(byte[] in) throws InvalidHeaderException {
        try {
            if (this.compressed) {
                return (in[0] & 0xFF) << 8 | in[1] & 0xFF;
            }
            return Integer.valueOf(new String(EBCDICConverter.convertCharacterField(in, new byte[this.length], 0, 0, this.length), 0, this.length));
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidHeaderException(new String(in, 0, this.length));
        }
    }

    public String toString() {
        return String.valueOf(this.compressed) + String.valueOf(this.length);
    }

    public static SLF getInstance(String s) {
        if ("true4".equals(s)) {
            return SLF_4_COMPRESSED;
        }
        if ("false4".equals(s)) {
            return SLF_4_UNCOMPRESSED;
        }
        if ("false6".equals(s)) {
            return SLF_6_UNCOMPRESSED;
        }
        return null;
    }
}

