/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.EBCDICConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class McvLogicalFile
extends DTAUSLogicalFile {
    private static final long serialVersionUID = 1L;
    private static final String GS = "GS";
    private static ThreadLocal<SimpleDateFormat> ddMMyy = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyy");
        }
    };
    private static ThreadLocal<SimpleDateFormat> ddMMyyyy = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyyyy");
        }
    };
    private static final byte[] A_HEADER_MCV = new byte[]{0, -106, 0, 0, -63};
    private static final byte[] E_HEADER_MCV = new byte[]{0, -106, 0, 0, -59, 64, 64, 64, 64, 64};
    private boolean isFromBBK = false;

    public McvLogicalFile(String orderType, boolean isFromBBK, DTAUSLogicalFile lf) throws ParseException {
        this(orderType, isFromBBK, lf.getFileType(), lf.getOrigBankcode(), lf.getOrigAccount(), lf.getOriginator(), lf.getCreation(), lf.getReference(), lf.getExecution(), lf.getFileNumber());
    }

    public McvLogicalFile(String orderType, boolean isFromBBK, String fileType, int blz, long accountNumber, String customerName, Date creationDate, int fileNumber) {
        this(orderType, isFromBBK, fileType, blz, accountNumber, customerName, creationDate, 0L, null, fileNumber);
    }

    private McvLogicalFile(String orderType, boolean isFromBBK, String fileType, int blz, long accountNumber, String customerName, Date creationDate, long refNumber, Date executionDate, int fileNumber) {
        this.isFromBBK = isFromBBK;
        boolean isBankOrderType = orderType != null && orderType.startsWith("Q");
        this.a_block = new byte[150];
        System.arraycopy(A_HEADER_MCV, 0, this.a_block, 0, 5);
        byte[] fileTypeBytes = EBCDICConverter.getAlphaNumericBytes(fileType, 2);
        System.arraycopy(fileTypeBytes, 0, this.a_block, 5, 2);
        byte[] packedBlz = EBCDICConverter.getNPBytes(blz, 5);
        if (!isFromBBK) {
            System.arraycopy(packedBlz, 0, this.a_block, 7, 5);
            if (isBankOrderType) {
                packedAccNumber = EBCDICConverter.getNPBytes(accountNumber, 5);
                System.arraycopy(packedAccNumber, 0, this.a_block, 12, 5);
            } else {
                Arrays.fill(this.a_block, 12, 16, (byte)0);
                Arrays.fill(this.a_block, 16, 17, (byte)12);
            }
        } else {
            if (isBankOrderType) {
                packedAccNumber = EBCDICConverter.getNPBytes(accountNumber, 5);
                System.arraycopy(packedAccNumber, 0, this.a_block, 7, 5);
            } else {
                Arrays.fill(this.a_block, 7, 11, (byte)0);
                Arrays.fill(this.a_block, 11, 12, (byte)12);
            }
            System.arraycopy(packedBlz, 0, this.a_block, 12, 5);
        }
        byte[] customerBytes = EBCDICConverter.getAlphaNumericBytes(customerName, 27);
        System.arraycopy(customerBytes, 0, this.a_block, 17, 27);
        if (creationDate == null) {
            creationDate = new Date();
        }
        byte[] packedCreationDate = EBCDICConverter.getNPBytes(Long.parseLong(ddMMyy.get().format(creationDate)), 4);
        System.arraycopy(packedCreationDate, 0, this.a_block, 44, 4);
        if (fileNumber > 0) {
            byte[] bytes = EBCDICConverter.getNPBytes(fileNumber, 4);
            System.arraycopy(bytes, 0, this.a_block, 48, 4);
        } else {
            Arrays.fill(this.a_block, 48, 52, (byte)64);
        }
        if (isBankOrderType) {
            Arrays.fill(this.a_block, 52, 57, (byte)0);
            Arrays.fill(this.a_block, 57, 58, (byte)12);
        } else {
            byte[] packedAccNumber = EBCDICConverter.getNPBytes(accountNumber, 6);
            System.arraycopy(packedAccNumber, 0, this.a_block, 52, 6);
        }
        if (GS.equals(fileType)) {
            Arrays.fill(this.a_block, 58, 150, (byte)64);
        } else {
            if (refNumber > 0L) {
                byte[] refNumberBytes = EBCDICConverter.getNumericBytes(refNumber, 10);
                System.arraycopy(refNumberBytes, 0, this.a_block, 58, 10);
            } else {
                Arrays.fill(this.a_block, 58, 68, (byte)-16);
            }
            Arrays.fill(this.a_block, 68, 83, (byte)64);
            if (executionDate == null) {
                Arrays.fill(this.a_block, 83, 91, (byte)64);
            } else {
                byte[] dateBytes = EBCDICConverter.getAlphaNumericBytes(ddMMyyyy.get().format(executionDate), 8);
                System.arraycopy(dateBytes, 0, this.a_block, 83, 8);
            }
            Arrays.fill(this.a_block, 91, 149, (byte)64);
            this.a_block[149] = -15;
        }
        this.e_block = new byte[150];
        System.arraycopy(E_HEADER_MCV, 0, this.e_block, 0, 10);
        Arrays.fill(this.e_block, 14, 20, (byte)0);
        Arrays.fill(this.e_block, 20, 21, (byte)12);
        Arrays.fill(this.e_block, 46, 150, (byte)64);
    }

    @Override
    public String getFileType() {
        return EBCDICConverter.getStringFromBytes(this.a_block, 5, 2);
    }

    @Override
    public void setFileNumber(int fileNumber) {
        byte[] bytes = EBCDICConverter.getNPBytes(fileNumber, 4);
        System.arraycopy(bytes, 0, this.a_block, 48, 4);
    }

    @Override
    public int getFileNumber() {
        return (int)EBCDICConverter.getNumberFromPackedBytes(this.a_block, 48, 4);
    }

    @Override
    void setNumberOfPayments(int i) {
        byte[] bytes = EBCDICConverter.getNPBytes(i, 4);
        System.arraycopy(bytes, 0, this.e_block, 10, 4);
    }

    @Override
    void setSumAccount(long l) {
        byte[] bytes = EBCDICConverter.getNPBytes(l, 9);
        System.arraycopy(bytes, 0, this.e_block, 21, 9);
    }

    @Override
    void setSumBankcode(long l) {
        byte[] bytes = EBCDICConverter.getNPBytes(l, 9);
        System.arraycopy(bytes, 0, this.e_block, 30, 9);
    }

    @Override
    void setSumAmount(long l) {
        byte[] bytes = EBCDICConverter.getNPBytes(l, 7);
        System.arraycopy(bytes, 0, this.e_block, 39, 7);
    }

    @Override
    public long getOrigAccount() {
        long accNumber = EBCDICConverter.getNumberFromPackedBytes(this.a_block, 52, 6);
        if (accNumber > 0L) {
            return accNumber;
        }
        if (this.isFromBBK) {
            return EBCDICConverter.getNumberFromPackedBytes(this.a_block, 7, 5);
        }
        return EBCDICConverter.getNumberFromPackedBytes(this.a_block, 12, 5);
    }

    @Override
    public int getOrigBankcode() {
        if (this.isFromBBK) {
            return (int)EBCDICConverter.getNumberFromPackedBytes(this.a_block, 12, 5);
        }
        return (int)EBCDICConverter.getNumberFromPackedBytes(this.a_block, 7, 5);
    }

    @Override
    public int getOrigBankcodeFromDTIFile() {
        return (int)EBCDICConverter.getNumberFromPackedBytes(this.a_block, 12, 5);
    }

    @Override
    public String getOriginator() {
        return EBCDICConverter.getStringFromBytes(this.a_block, 17, 27);
    }

    @Override
    protected void writeBlock(byte[] block, OutputStream out) throws IOException {
        int asciiBlockLength = this.getAsciiBlockLength(block);
        if (asciiBlockLength > 0) {
            byte[] ebcdicBlock = EBCDICConverter.convertToEbcdic(block);
            int q = asciiBlockLength / 256;
            int r = asciiBlockLength % 256;
            ebcdicBlock[0] = q > 0 ? (byte)q : (byte)0;
            ebcdicBlock[1] = (byte)r;
            Arrays.fill(ebcdicBlock, 2, 4, (byte)0);
            super.writeBlock(ebcdicBlock, out);
        } else {
            super.writeBlock(block, out);
        }
    }

    private int getAsciiBlockLength(byte[] block) {
        byte[] temp = new byte[4];
        System.arraycopy(block, 0, temp, 0, 4);
        try {
            return Integer.parseInt(new String(temp));
        }
        catch (Exception e) {
            return -1;
        }
    }
}

