/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.format.dta.FieldC7;
import java.util.Arrays;

public class McvItem
extends DTAUSItem {
    private static final long serialVersionUID = 1L;
    private static final byte RECIPIENT_BYTE = -15;
    private static final byte PURPOSE_BYTE = -14;
    private static final byte ORIGINATOR_BYTE = -13;
    private static final byte[] RECIPIENT_TAG = new byte[]{-16, -15};
    private static final byte[] PURPOSE_TAG = new byte[]{-16, -14};
    private static final byte[] ORIGINATOR_TAG = new byte[]{-16, -13};
    private static final int MAX_COUNT_PURPOSE_LINES = 16;
    private static final int[] MCV_BLOCK_SIZE = new int[]{150, 179, 208, 237, 266, 295, 324, 353, 382, 411, 440, 469, 498, 527, 556, 585, 614, 643};

    public McvItem(DTAUSItem item) {
        String[] recipientArray = item.getRecipient();
        String[] originatorArray = item.getCustomer();
        String[] purposeArray = item.getPurpose();
        int countExtensions = 0;
        if (recipientArray != null && recipientArray.length > 1) {
            countExtensions = countExtensions + recipientArray.length - 1;
        }
        if (originatorArray != null && originatorArray.length > 1) {
            countExtensions = countExtensions + originatorArray.length - 1;
        }
        if (purposeArray != null && purposeArray.length > 1) {
            countExtensions = countExtensions + purposeArray.length - 1;
        }
        int blockSize = MCV_BLOCK_SIZE[countExtensions];
        this.cblock = new byte[blockSize];
        int q = blockSize / 256;
        int r = blockSize % 256;
        this.cblock[0] = q > 0 ? (byte)q : (byte)0;
        this.cblock[1] = (byte)r;
        Arrays.fill(this.cblock, 2, 4, (byte)0);
        this.cblock[4] = -61;
        byte[] packedFirstBankBlz = EBCDICConverter.getNPBytes(item.getFirstParticipatingBank(), 5);
        System.arraycopy(packedFirstBankBlz, 0, this.cblock, 5, 5);
        byte[] packedRecipientBlz = EBCDICConverter.getNPBytes(item.getRecipientBankcode(), 5);
        System.arraycopy(packedRecipientBlz, 0, this.cblock, 10, 5);
        byte[] packedRecipientAccNumber = EBCDICConverter.getNPBytes(item.getRecipientAccount(), 6);
        System.arraycopy(packedRecipientAccNumber, 0, this.cblock, 15, 6);
        byte[] packedCustomerId = EBCDICConverter.getNPBytes(item.getC6a(), 6, false);
        System.arraycopy(packedCustomerId, 0, this.cblock, 21, 6);
        Arrays.fill(this.cblock, 27, 33, (byte)0);
        this.cblock[33] = 12;
        FieldC7 fieldC7 = FieldC7.getInstance(item.getTextKey());
        this.cblock[34] = EBCDICConverter.getNPBytes(fieldC7.getTextKey(), 1, false)[0];
        byte[] packedTextKeyExtension = EBCDICConverter.getNPBytes(fieldC7.getTextKeyExtension(), 2);
        System.arraycopy(packedTextKeyExtension, 0, this.cblock, 35, 2);
        this.cblock[37] = 64;
        Arrays.fill(this.cblock, 39, 43, (byte)0);
        this.cblock[43] = 12;
        byte[] packedOriginatorBlz = EBCDICConverter.getNPBytes(item.getOriginatorBankcode(), 5);
        System.arraycopy(packedOriginatorBlz, 0, this.cblock, 44, 5);
        byte[] packedOriginatorAccNumber = EBCDICConverter.getNPBytes(item.getOriginatorAccount(), 6);
        System.arraycopy(packedOriginatorAccNumber, 0, this.cblock, 49, 6);
        byte[] packedAmount = EBCDICConverter.getNPBytes(item.getAmount(), 6);
        System.arraycopy(packedAmount, 0, this.cblock, 55, 6);
        Arrays.fill(this.cblock, 61, 64, (byte)64);
        if (recipientArray != null && recipientArray.length > 0) {
            byte[] recipientBytes = EBCDICConverter.getAlphaNumericBytes(recipientArray[0], 27);
            System.arraycopy(recipientBytes, 0, this.cblock, 64, 27);
        } else {
            Arrays.fill(this.cblock, 64, 91, (byte)64);
        }
        if (originatorArray != null && originatorArray.length > 0) {
            byte[] originatorBytes = EBCDICConverter.getAlphaNumericBytes(originatorArray[0], 27);
            System.arraycopy(originatorBytes, 0, this.cblock, 91, 27);
        } else {
            Arrays.fill(this.cblock, 91, 118, (byte)64);
        }
        if (purposeArray != null && purposeArray.length > 0) {
            byte[] purposeBytes = EBCDICConverter.getAlphaNumericBytes(purposeArray[0], 27);
            System.arraycopy(purposeBytes, 0, this.cblock, 118, 27);
        } else {
            Arrays.fill(this.cblock, 118, 145, (byte)64);
        }
        this.cblock[145] = -15;
        Arrays.fill(this.cblock, 146, 148, (byte)64);
        byte[] packedExtensions = EBCDICConverter.getNPBytes(countExtensions, 2);
        System.arraycopy(packedExtensions, 0, this.cblock, 148, 2);
        int counter = 0;
        if (recipientArray != null) {
            counter = this.writeExtensionParts(counter, RECIPIENT_TAG, recipientArray, 2);
        }
        if (purposeArray != null) {
            counter = this.writeExtensionParts(counter, PURPOSE_TAG, purposeArray, 16);
        }
        if (originatorArray != null) {
            counter = this.writeExtensionParts(counter, ORIGINATOR_TAG, originatorArray, 2);
        }
    }

    public McvItem(DTAUSLogicalFile lf, DTAUSItem item) {
        this(lf, item.getCustomer(), item.getCounterPartyBankCode(!lf.isBankFile()), item.getCounterPartyAccountNumber(!lf.isBankFile()), item.getRecipient(), FieldC7.getInstance(item.getTextKey()), item.getAmount(), item.getPurpose());
    }

    public McvItem(DTAUSLogicalFile lf, String[] originatorArray, int recipientBankcode, long recipientAccount, String[] recipientArray, FieldC7 fieldC7, long amount, String[] purposeArray) {
        this(lf, originatorArray, -1, -1L, recipientBankcode, recipientAccount, recipientArray, fieldC7, amount, purposeArray);
    }

    public McvItem(DTAUSLogicalFile lf, String[] originatorArray, int originatorBankcode, long originatorAccount, int recipientBankcode, long recipientAccount, String[] recipientArray, FieldC7 fieldC7, long amount, String[] purposeArray) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("Illegal amount: " + amount);
        }
        int countExtensions = recipientArray.length + purposeArray.length - 2;
        if (originatorArray != null) {
            countExtensions += originatorArray.length - 1;
        }
        int blockSize = MCV_BLOCK_SIZE[countExtensions];
        this.cblock = new byte[blockSize];
        int q = blockSize / 256;
        int r = blockSize % 256;
        this.cblock[0] = q > 0 ? (byte)q : (byte)0;
        this.cblock[1] = (byte)r;
        Arrays.fill(this.cblock, 2, 4, (byte)0);
        this.cblock[4] = -61;
        Arrays.fill(this.cblock, 5, 9, (byte)0);
        this.cblock[9] = 12;
        byte[] packedOriginatorBlz = null;
        byte[] packedOriginatorAccNumber = null;
        if (originatorBankcode >= 0 && originatorAccount >= 0L) {
            packedOriginatorBlz = EBCDICConverter.getNPBytes(originatorBankcode, 5);
            packedOriginatorAccNumber = EBCDICConverter.getNPBytes(originatorAccount, 6);
        } else {
            packedOriginatorBlz = EBCDICConverter.getNPBytes(lf.getOrigBankcode(), 5);
            packedOriginatorAccNumber = EBCDICConverter.getNPBytes(lf.getOrigAccount(), 6);
        }
        byte[] packedRecipientBlz = EBCDICConverter.getNPBytes(recipientBankcode, 5);
        byte[] packedRecipientAccNumber = EBCDICConverter.getNPBytes(recipientAccount, 6);
        if (lf.isBankFile()) {
            System.arraycopy(packedOriginatorBlz, 0, this.cblock, 10, 5);
            System.arraycopy(packedOriginatorAccNumber, 0, this.cblock, 15, 6);
            System.arraycopy(packedRecipientBlz, 0, this.cblock, 44, 5);
            System.arraycopy(packedRecipientAccNumber, 0, this.cblock, 49, 6);
        } else {
            System.arraycopy(packedRecipientBlz, 0, this.cblock, 10, 5);
            System.arraycopy(packedRecipientAccNumber, 0, this.cblock, 15, 6);
            System.arraycopy(packedOriginatorBlz, 0, this.cblock, 44, 5);
            System.arraycopy(packedOriginatorAccNumber, 0, this.cblock, 49, 6);
        }
        Arrays.fill(this.cblock, 21, 27, (byte)0);
        Arrays.fill(this.cblock, 27, 33, (byte)0);
        this.cblock[33] = 12;
        this.cblock[34] = EBCDICConverter.getNPBytes(fieldC7.getTextKey(), 1, false)[0];
        byte[] packedTextKeyExtension = EBCDICConverter.getNPBytes(fieldC7.getTextKeyExtension(), 2);
        System.arraycopy(packedTextKeyExtension, 0, this.cblock, 35, 2);
        this.cblock[37] = 64;
        Arrays.fill(this.cblock, 39, 43, (byte)0);
        this.cblock[43] = 12;
        byte[] packedAmount = EBCDICConverter.getNPBytes(amount, 6);
        System.arraycopy(packedAmount, 0, this.cblock, 55, 6);
        Arrays.fill(this.cblock, 61, 64, (byte)64);
        byte[] recipientBytes = EBCDICConverter.getAlphaNumericBytes(recipientArray[0], 27);
        System.arraycopy(recipientBytes, 0, this.cblock, 64, 27);
        String originator = originatorArray != null && originatorArray.length > 0 ? originatorArray[0] : lf.getOriginator();
        byte[] originatorBytes = EBCDICConverter.getAlphaNumericBytes(originator, 27);
        System.arraycopy(originatorBytes, 0, this.cblock, 91, 27);
        if (purposeArray != null && purposeArray.length > 0) {
            byte[] purposeBytes = EBCDICConverter.getAlphaNumericBytes(purposeArray[0], 27);
            System.arraycopy(purposeBytes, 0, this.cblock, 118, 27);
        } else {
            Arrays.fill(this.cblock, 118, 145, (byte)64);
        }
        this.cblock[145] = -15;
        Arrays.fill(this.cblock, 146, 148, (byte)64);
        byte[] packedExtensions = EBCDICConverter.getNPBytes(countExtensions, 2);
        System.arraycopy(packedExtensions, 0, this.cblock, 148, 2);
        int counter = 0;
        counter = this.writeExtensionParts(counter, RECIPIENT_TAG, recipientArray, 2);
        counter = this.writeExtensionParts(counter, PURPOSE_TAG, purposeArray, 16);
        if (originatorArray != null) {
            counter = this.writeExtensionParts(counter, ORIGINATOR_TAG, originatorArray, 2);
        }
    }

    private int writeExtensionParts(int counter, byte[] tag, String[] array, int maxOccurence) {
        if (array.length > maxOccurence) {
            throw new IllegalArgumentException("Too many extensions of type " + tag[1]);
        }
        for (int i = 1; i < array.length; ++i) {
            int p = MCV_BLOCK_SIZE[counter++];
            System.arraycopy(tag, 0, this.cblock, p, 2);
            byte[] bytes = EBCDICConverter.getAlphaNumericBytes(array[i], 27);
            System.arraycopy(bytes, 0, this.cblock, p + 2, 27);
        }
        return counter;
    }

    @Override
    public long getAmount() {
        return EBCDICConverter.getNumberFromPackedBytes(this.cblock, 55, 6);
    }

    @Override
    public long getRecipientAccount() {
        return EBCDICConverter.getNumberFromPackedBytes(this.cblock, 15, 6);
    }

    @Override
    public int getRecipientBankcode() {
        return (int)EBCDICConverter.getNumberFromPackedBytes(this.cblock, 10, 5);
    }
}

