/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAExtractor;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.format.dta.EndOfFileException;
import de.businesslogics.format.dta.InvalidBlockLengthException;
import de.businesslogics.format.dta.InvalidHeaderException;
import de.businesslogics.io.Streams;
import de.businesslogics.io.YOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class McvExtractor
extends OutputStream {
    final OutputStream dta;
    protected final DTAExtractor.FormatListener listener;
    protected final byte[] in_bytes;
    byte[] dta_bytes = new byte[768];
    protected int writePos = 0;
    int toRead = 4;
    private int offset = 1;
    private String expectedFileType = null;

    public McvExtractor(OutputStream os) {
        this.listener = new DTAExtractor.NullFormatListener();
        this.dta = os;
        this.in_bytes = new byte[this.getMaxBlockLength()];
    }

    public McvExtractor(DTAUSExtractor.DTAUSListener listener) {
        this(listener, null);
    }

    public McvExtractor(DTAUSExtractor.DTAUSListener listener, String expectedFileType) {
        this.listener = listener;
        this.dta = new DTAUSExtractor(listener);
        this.in_bytes = new byte[this.getMaxBlockLength()];
        this.expectedFileType = expectedFileType;
    }

    public McvExtractor(OutputStream out, DTAUSExtractor.DTAUSListener listener) {
        this.listener = listener;
        this.dta = new YOutputStream(new DTAUSExtractor(listener), out);
        this.in_bytes = new byte[this.getMaxBlockLength()];
    }

    @Override
    public void write(int b) throws IOException {
        byte[] one_byte = new byte[1];
        this.write(one_byte, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.writePos == 0 && (b[off] == 10 || b[off] == 13)) {
                --len;
                ++off;
                continue;
            }
            int toCopy = this.toRead;
            if (toCopy > len) {
                toCopy = len;
            }
            System.arraycopy(b, off, this.in_bytes, this.writePos, toCopy);
            this.writePos += toCopy;
            off += toCopy;
            len -= toCopy;
            this.toRead -= toCopy;
            if (this.toRead != 0) continue;
            if (this.writePos == 4) {
                if (this.offset == 1) {
                    if (this.in_bytes[0] == -63) {
                        this.offset = -4;
                        this.toRead = 142;
                        continue;
                    }
                    this.offset = this.in_bytes[2] == -63 ? -2 : 0;
                }
                this.toRead = (this.in_bytes[0] & 0xFF) << 8 | this.in_bytes[1] & 0xFF;
                if (this.toRead > this.in_bytes.length) {
                    this.listener.consumeError(new InvalidBlockLengthException(this.toRead));
                }
                this.toRead -= 4;
                continue;
            }
            this.toRead = this.handleBlock();
            if (this.toRead != 0) continue;
            this.writePos = 0;
            this.toRead = this.offset == -4 ? 146 : 4;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writePos != 0) {
            this.listener.consumeError(new EndOfFileException());
        }
        this.dta.close();
    }

    public Boolean getMandatoryIsDebit() {
        DTAUSExtractor extractor;
        if (this.dta instanceof DTAUSExtractor) {
            extractor = (DTAUSExtractor)this.dta;
        } else if (this.dta instanceof YOutputStream && ((YOutputStream)this.dta).getOutputStream1() instanceof DTAUSExtractor) {
            extractor = (DTAUSExtractor)((YOutputStream)this.dta).getOutputStream1();
        } else {
            return null;
        }
        return extractor.getMandatoryIsDebit();
    }

    public void setMandatoryIsDebit(Boolean mandatoryIsDebit) {
        DTAUSExtractor extractor;
        if (this.dta instanceof DTAUSExtractor) {
            extractor = (DTAUSExtractor)this.dta;
        } else if (this.dta instanceof YOutputStream && ((YOutputStream)this.dta).getOutputStream1() instanceof DTAUSExtractor) {
            extractor = (DTAUSExtractor)((YOutputStream)this.dta).getOutputStream1();
        } else {
            return;
        }
        extractor.setMandatoryIsDebit(mandatoryIsDebit);
    }

    protected void handleBlockA() throws IOException {
        String fileType;
        if (this.writePos != 150 + this.offset) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        DTAUtil.setNumericalField(this.dta_bytes, 0, 4, 128L);
        this.dta_bytes[4] = 65;
        this.copyCharacterField(5 + this.offset, 5, 2);
        this.copyNumericalField(7 + this.offset, 7, 8);
        this.copyNumericalField(12 + this.offset, 15, 8);
        this.copyCharacterField(17 + this.offset, 23, 27);
        this.copyNumericalField(44 + this.offset, 50, 6);
        if (this.expectedFileType != null && !this.expectedFileType.equals(fileType = DTAUtil.getString(this.dta_bytes, 5 + this.offset, 2))) {
            throw new IOException("Invalid file type = " + fileType);
        }
        try {
            int fileNumber = (int)EBCDICConverter.getNumberFromPackedBytes(this.in_bytes, 48 + this.offset, 4);
            DTAUtil.setNumericalField(this.dta_bytes, 56, 4, fileNumber);
        }
        catch (Exception e) {
            this.copyCharacterField(48 + this.offset, 56, 4);
        }
        this.copyNumericalField(52 + this.offset, 60, 10);
        this.copyCharacterField(58 + this.offset, 70, 10);
        this.copyCharacterField(68 + this.offset, 80, 47);
        this.copyCharacterField(149 + this.offset, 127, 1);
        this.dta.write(this.dta_bytes, 0, 128);
    }

    protected int handleBlockC() throws IOException {
        if (this.writePos < 150 + this.offset) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        int extensions = (int)EBCDICConverter.getNumberFromPackedBytes(this.in_bytes, 148 + this.offset, 2);
        int expectedLength = 150 + extensions * 29 + this.offset;
        if (this.offset == -4 && expectedLength > this.writePos) {
            return expectedLength - this.writePos;
        }
        if (this.writePos != expectedLength) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        DTAUtil.setNumericalField(this.dta_bytes, 0, 4, 187 + extensions * 29);
        this.dta_bytes[4] = 67;
        this.copyNumericalField(5 + this.offset, 5, 8);
        this.copyNumericalField(10 + this.offset, 13, 8);
        this.copyNumericalField(15 + this.offset, 21, 10);
        this.copyUnsignedNumericalField(21 + this.offset, 31, 12);
        this.dta_bytes[43] = 48;
        this.copyUnsignedNumericalField(34 + this.offset, 44, 2);
        this.copyNumericalField(35 + this.offset, 46, 3);
        this.copyCharacterField(37 + this.offset, 49, 1);
        this.copyNumericalField(38 + this.offset, 50, 11);
        this.copyNumericalField(44 + this.offset, 61, 8);
        this.copyNumericalField(49 + this.offset, 69, 10);
        this.copyNumericalField(55 + this.offset, 79, 11);
        this.copyCharacterField(61 + this.offset, 90, 3);
        this.copyCharacterField(64 + this.offset, 93, 27);
        Arrays.fill(this.dta_bytes, 120, 128, (byte)32);
        this.copyCharacterField(91 + this.offset, 128, 27);
        this.copyCharacterField(118 + this.offset, 155, 27);
        this.copyCharacterField(145 + this.offset, 182, 3);
        this.copyNumericalField(148 + this.offset, 185, 2);
        int extension = 0;
        int dtaPos = DTAUSItem.EXTENSION_POSITION[0];
        for (int pos = 150; pos < this.writePos; pos += 29) {
            this.copyCharacterField(pos + this.offset, dtaPos, 29);
            int i = DTAUSItem.EXTENSION_POSITION[++extension];
            Arrays.fill(this.dta_bytes, dtaPos += 29, i, (byte)32);
            dtaPos = i;
        }
        int blockSize = DTAUSItem.BLOCK_SIZE[extension];
        while (dtaPos < blockSize) {
            Arrays.fill(this.dta_bytes, dtaPos, dtaPos += 2, (byte)48);
            Arrays.fill(this.dta_bytes, dtaPos, dtaPos += 27, (byte)32);
            int n = dtaPos;
            dtaPos = DTAUSItem.EXTENSION_POSITION[++extension];
            Arrays.fill(this.dta_bytes, n, dtaPos, (byte)32);
        }
        this.dta.write(this.dta_bytes, 0, blockSize);
        return 0;
    }

    protected void handleBlockE() throws IOException {
        if (this.writePos != 150 + this.offset) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        DTAUtil.setNumericalField(this.dta_bytes, 0, 4, 128L);
        this.dta_bytes[4] = 69;
        this.copyCharacterField(5 + this.offset, 5, 5);
        this.copyNumericalField(10 + this.offset, 10, 7);
        this.copyNumericalField(14 + this.offset, 17, 13);
        this.copyNumericalField(21 + this.offset, 30, 17);
        this.copyNumericalField(30 + this.offset, 47, 17);
        this.copyNumericalField(39 + this.offset, 64, 13);
        Arrays.fill(this.dta_bytes, 77, 128, (byte)32);
        this.dta.write(this.dta_bytes, 0, 128);
    }

    protected int getMaxBlockLength() {
        return 585;
    }

    private int handleBlock() throws IOException {
        switch (this.in_bytes[4 + this.offset]) {
            case -63: {
                this.handleBlockA();
                return 0;
            }
            case -61: {
                return this.handleBlockC();
            }
            case -59: {
                this.handleBlockE();
                return 0;
            }
        }
        this.handleUnknownBlock();
        return 0;
    }

    public void handleUnknownBlock() throws IOException {
        this.listener.consumeError(new InvalidHeaderException((char)EBCDICConverter.EBCDIC_TO_DTAUS[this.in_bytes[4] & 0xFF], "ACE"));
    }

    protected void copyCharacterField(int fromIndex, int toIndex, int length) {
        while (length > 0) {
            this.dta_bytes[toIndex] = EBCDICConverter.EBCDIC_TO_DTAUS[this.in_bytes[fromIndex] & 0xFF];
            ++fromIndex;
            ++toIndex;
            --length;
        }
    }

    private void copyNumericalField(int fromIndex, int toIndex, int dtaLength) {
        this.copyNumericalField(fromIndex, toIndex, dtaLength, (dtaLength & 1) == 0);
    }

    private void copyUnsignedNumericalField(int fromIndex, int toIndex, int dtaLength) {
        this.copyNumericalField(fromIndex, toIndex, dtaLength, (dtaLength & 1) != 0);
    }

    private void copyNumericalField(int fromIndex, int toIndex, int dtaLength, boolean lowerNibble) {
        while (dtaLength > 0) {
            byte b;
            if (lowerNibble) {
                b = (byte)(48 + (this.in_bytes[fromIndex] & 0xF));
                lowerNibble = false;
                ++fromIndex;
            } else {
                b = (byte)(48 + ((this.in_bytes[fromIndex] & 0xFF) >> 4));
                lowerNibble = true;
            }
            this.dta_bytes[toIndex] = b;
            ++toIndex;
            --dtaLength;
        }
    }

    public void setMode(Mode mode) {
        this.offset = mode.offset;
        this.toRead = this.offset == -4 ? 146 : 4;
    }

    public static void main(String[] args) throws Exception {
        try (FileInputStream in = new FileInputStream(args[0]);
             FileOutputStream out = new FileOutputStream(args[1]);){
            McvExtractor e = new McvExtractor(out);
            Streams.copy(in, e, false);
        }
    }

    public static enum Mode {
        AUTO(1),
        MC4(-4),
        MC2(-2),
        MCV(0);

        private final int offset;

        private Mode(int offset) {
            this.offset = offset;
        }
    }
}

