/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUSWriter;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.McvItem;
import de.businesslogics.format.dta.McvLogicalFile;
import de.businesslogics.io.NullOutputStream;
import de.businesslogics.io.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MCVConverter
implements DTAUSExtractor.DTAUSListener {
    private int length = 0;
    private OutputStream out;
    private DTAUSWriter writer;

    public MCVConverter(int recordLength, OutputStream out) {
        this.length = recordLength;
        this.out = out;
        this.writer = new DTAUSWriter(new NullOutputStream());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: <in-file> <out-file> [recordlength]");
            System.exit(-1);
        }
        File in = new File(args[0]);
        File out = new File(args[1]);
        int length = 0;
        if (args.length > 2) {
            length = Integer.parseInt(args[2]);
        }
        MCVConverter c = new MCVConverter(length, new FileOutputStream(out));
        DTAUSExtractor e = new DTAUSExtractor(c);
        Streams.copy(new FileInputStream(in), e);
        c.close();
    }

    public void close() throws IOException {
        this.writer.close();
        this.out.close();
    }

    @Override
    public void endLogicalFile(DTAUSLogicalFile logicalFile) {
        try {
            DTAUSLogicalFile lf = this.writer.closeLogicalFile();
            switch (this.length) {
                case 0: {
                    this.out.write(lf.e_block, 4, lf.e_block.length - 4);
                    break;
                }
                case 2: {
                    this.write2ByteLength(lf.e_block);
                    this.out.write(lf.e_block, 4, lf.e_block.length - 4);
                    break;
                }
                case 4: {
                    this.out.write(lf.e_block);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleItem(DTAUSItem i) {
        try {
            McvItem mcv = new McvItem(i);
            this.writer.write(mcv);
            switch (this.length) {
                case 0: {
                    this.out.write(mcv.cblock, 4, mcv.cblock.length - 4);
                    break;
                }
                case 2: {
                    this.write2ByteLength(mcv.cblock);
                    this.out.write(mcv.cblock, 4, mcv.cblock.length - 4);
                    break;
                }
                case 4: {
                    this.out.write(mcv.cblock);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        try {
            McvLogicalFile mcv = new McvLogicalFile(null, true, logicalFile);
            this.writer.startLogicalFile(mcv);
            switch (this.length) {
                case 0: {
                    this.out.write(mcv.a_block, 4, mcv.a_block.length - 4);
                    break;
                }
                case 2: {
                    this.write2ByteLength(mcv.a_block);
                    this.out.write(mcv.a_block, 4, mcv.a_block.length - 4);
                    break;
                }
                case 4: {
                    this.out.write(mcv.a_block);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void write2ByteLength(byte[] block) throws IOException {
        int length = block.length - 2;
        int q = length / 256;
        int r = length % 256;
        this.out.write(q > 0 ? (byte)q : (byte)0);
        this.out.write((byte)r);
    }

    @Override
    public void consumeError(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    @Override
    public void handleWarning(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }
}

