/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.InvalidFileException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class InvalidHeaderException
extends InvalidFileException {
    String shouldBe;
    String value = null;
    char was;
    private static final long serialVersionUID = -936358198674183928L;

    public InvalidHeaderException(char was, String shouldBe) {
        this.was = was;
        this.shouldBe = shouldBe;
    }

    public InvalidHeaderException(String header) {
        this.value = header;
    }

    @Override
    public String getMessage(Locale locale) {
        if (this.value == null) {
            return MessageFormat.format(ResourceBundle.getBundle("de.businesslogics.format.dta.ErrorMessages", locale).getString("INVALID_HEADER"), InvalidHeaderException.escape(Character.toString(this.was)), this.shouldBe);
        }
        return MessageFormat.format(ResourceBundle.getBundle("de.businesslogics.format.dta.ErrorMessages", locale).getString("INVALID_HEADER_TEXT"), InvalidHeaderException.escape(this.value));
    }

    private static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c & 0x7F) < 32) {
                sb.append("0x").append(Integer.toHexString(c)).append(" ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

