/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FieldC7 {
    private static ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.dta.TextKeys");
    public static final FieldC7 ABBUCHUNGSVERFAHREN = new FieldC7("04000");
    public static final FieldC7 ABBUCHUNGSVERFAHREN_GEBIETSFREMD = new FieldC7("04888");
    public static final FieldC7 EINZUGSERMAECHTIGUNG = new FieldC7("05000");
    public static final FieldC7 EINZUGSERMAECHTIGUNG_GEBITESFREMD = new FieldC7("05888");
    public static final FieldC7 ELECTRONIC_CASH = new FieldC7("05005");
    public static final FieldC7 MAESTRO = new FieldC7("05006");
    public static final FieldC7 KREDITKARTE = new FieldC7("05008");
    public static final FieldC7 POZ = new FieldC7("05015");
    public static final FieldC7 UEBERWEISUNG = new FieldC7("51000");
    public static final FieldC7 UEBERWEISUNG_GEBIETSFREMD = new FieldC7("51888");
    public static final FieldC7 LOHN = new FieldC7("53000");
    public static final FieldC7 LOHN_GEBIETSFREMD = new FieldC7("53888");
    public static final FieldC7 OEFFENTLICHE_KASSE = new FieldC7("56000");
    public static final FieldC7 PRUEFZIFFERGESICHERTE_UEBERWEISUNG = new FieldC7("67000");
    public static final FieldC7 NEUTRALE_UEBERWEISUNG = new FieldC7("68000");
    public static final FieldC7 SPENDENUEBERWEISUNG = new FieldC7("69000");
    public static final FieldC7 POS_MAESTRO = new FieldC7("05010");
    public static final FieldC7 POS_ELECTRONIC_CASH = new FieldC7("05011");
    public static final FieldC7 POS_ELV = new FieldC7("05019");
    public static final FieldC7 POS_EAPS = new FieldC7("05021");
    public static final FieldC7 KORREKTUR_POS_ELECTRONIC_CASH = new FieldC7("51505");
    public static final FieldC7 KORREKTUR_POS_MAESTRO = new FieldC7("51506");
    public static final FieldC7 KORREKTUR_POS_MAESTRO_EMV = new FieldC7("51510");
    public static final FieldC7 KORREKTUR_POS_ELECTRONIC_CASH_EMV = new FieldC7("51511");
    public static final FieldC7 KORREKTUR_POS_EAPS = new FieldC7("51521");
    public static final FieldC7[] FIELDS = new FieldC7[]{OEFFENTLICHE_KASSE, LOHN_GEBIETSFREMD, LOHN, UEBERWEISUNG_GEBIETSFREMD, UEBERWEISUNG, EINZUGSERMAECHTIGUNG_GEBITESFREMD, EINZUGSERMAECHTIGUNG, ABBUCHUNGSVERFAHREN_GEBIETSFREMD, ABBUCHUNGSVERFAHREN, PRUEFZIFFERGESICHERTE_UEBERWEISUNG, NEUTRALE_UEBERWEISUNG, SPENDENUEBERWEISUNG, POS_MAESTRO, POS_ELECTRONIC_CASH, POS_ELV, POS_EAPS, KORREKTUR_POS_ELECTRONIC_CASH, KORREKTUR_POS_MAESTRO, KORREKTUR_POS_MAESTRO_EMV, KORREKTUR_POS_ELECTRONIC_CASH_EMV, KORREKTUR_POS_EAPS};
    final byte[] internalValue;
    private final int textKey;
    private final int textKeyExtension;
    public static final String[] DEBIT_TEXT_KEYS = new String[]{"05000", "05888", "05019"};
    public static final String[] CREDIT_TEXT_KEYS = new String[]{"51000", "51888", "53000", "53888", "56000", "67000", "67888", "68000", "68888", "69000", "69888"};
    public static final String[] BBK_DEBIT_TEXT_KEYS = new String[]{"01000", "01888", "02000", "02888", "03000", "04000", "04888", "05000", "05888", "05001", "05002", "05003", "05004", "05005", "05006", "05007", "05008", "05009", "05010", "05011", "05015", "05019", "05021", "05071", "05073", "05200", "05201", "05202", "05210", "05222", "05230", "05240", "05242", "09056", "11000", "11888", "12000", "13000", "14001", "14002", "14003", "14004", "14005", "14006", "14007", "14008", "14009", "14010", "14011", "14012", "14013", "14014", "14015", "14016", "14084", "14085", "14088", "14089", "15000"};
    public static final String[] BBK_CREDIT_TEXT_KEYS = new String[]{"51000", "51888", "51200", "51210", "51211", "51212", "51220", "51221", "51230", "51240", "51241", "51401", "51402", "51403", "51404", "51405", "51406", "51407", "51408", "51409", "51410", "51411", "51412", "51413", "51414", "51415", "51416", "51484", "51485", "51488", "51489", "51501", "51502", "51503", "51504", "51505", "51506", "51507", "51509", "51510", "51511", "51521", "51571", "51573", "51990", "52000", "52888", "53000", "53888", "54777", "56000", "63000", "65000", "67000", "67888", "68000", "68888", "69000", "69888"};

    FieldC7(String s) {
        this.textKey = Integer.parseInt(s.substring(0, 2));
        this.textKeyExtension = Integer.parseInt(s.substring(2));
        this.internalValue = s.getBytes();
    }

    public static FieldC7 getInstance(String s) {
        for (int i = 0; i < FIELDS.length; ++i) {
            if (!FIELDS[i].toString().equals(s)) continue;
            return FIELDS[i];
        }
        return new FieldC7(s);
    }

    public int getTextKey() {
        return this.textKey;
    }

    public int getTextKeyExtension() {
        return this.textKeyExtension;
    }

    boolean isCredit() {
        return this.internalValue[0] == 53 || this.internalValue[0] == 54;
    }

    public static FieldC7 getVL(int percent, int year) {
        Object s = Integer.toString(percent / 100);
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return new FieldC7("54" + (String)s + year % 10);
    }

    public String toString() {
        return new String(this.internalValue);
    }

    public static String getDescription(String textKey) {
        try {
            return bundle.getString(textKey).trim();
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public static boolean isTextKeyValid(String s, boolean isCreditPayment) {
        if (s.length() != 5) {
            return false;
        }
        if (isCreditPayment ? !s.startsWith("5") && !s.startsWith("6") : !s.startsWith("0") && !s.startsWith("1")) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isSalaryPayment(String textKey) {
        return textKey != null && textKey.startsWith("53");
    }
}

