/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAExtractor;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.format.dta.EndOfFileException;
import de.businesslogics.format.dta.InvalidBlockLengthException;
import de.businesslogics.format.dta.InvalidHeaderException;
import de.businesslogics.format.dta.SLF;
import java.io.IOException;
import java.io.OutputStream;

public abstract class EBCDICExtractor
extends OutputStream {
    OutputStream dta;
    final DTAExtractor.FormatListener listener;
    SLF slf;
    byte[] in_bytes = new byte[9999];
    byte[] dta_bytes = new byte[9999];
    int writePos = 0;
    private int toRead;
    protected int offset;
    protected int lengthBlockA;
    protected int lengthBlockE;

    public EBCDICExtractor(DTAUSExtractor.DTAUSListener listener, SLF slf) {
        this.listener = listener;
        this.slf = slf;
        this.toRead = slf.getLength();
        this.offset = slf.getLength() - 4;
        this.lengthBlockA = DTAUSLogicalFile.LENGTH_BLOCK_A + this.offset;
        this.lengthBlockE = DTAUSLogicalFile.LENGTH_BLOCK_E + this.offset;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] one_byte = new byte[1];
        this.write(one_byte, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int toCopy = this.toRead;
            if (toCopy > len) {
                toCopy = len;
            }
            System.arraycopy(b, off, this.in_bytes, this.writePos, toCopy);
            this.writePos += toCopy;
            off += toCopy;
            len -= toCopy;
            this.toRead -= toCopy;
            if (this.toRead != 0) continue;
            if (this.writePos == this.slf.getLength()) {
                this.toRead = this.slf.getBlockLength(this.in_bytes);
                if (this.toRead > this.in_bytes.length) {
                    this.listener.consumeError(new InvalidBlockLengthException(this.toRead));
                }
                this.toRead -= this.slf.getLength();
                continue;
            }
            this.handleBlock();
            this.writePos = 0;
            this.toRead = this.slf.getLength();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writePos != 0) {
            this.listener.consumeError(new EndOfFileException());
        }
        if (this.dta != null) {
            this.dta.close();
        }
    }

    private void handleBlock() throws IOException {
        switch (this.in_bytes[this.slf.getLength()]) {
            case -63: {
                this.handleBlockA();
                break;
            }
            case -61: {
                this.handleBlockC();
                break;
            }
            case -60: {
                this.handleBlockD();
                break;
            }
            case -59: {
                this.handleBlockE();
                break;
            }
            case -56: {
                this.handleBlockH();
                break;
            }
            case -55: {
                this.handleBlockI();
                break;
            }
            case -43: {
                this.handleBlockN();
                break;
            }
            default: {
                this.handleUnknownBlock();
            }
        }
    }

    public void handleUnknownBlock() throws IOException {
        this.listener.consumeError(new InvalidHeaderException((char)EBCDICConverter.EBCDIC_TO_DTAUS[this.in_bytes[4] & 0xFF], "ACDEHIN"));
    }

    protected abstract void handleBlockA() throws IOException;

    protected abstract void handleBlockC() throws IOException;

    protected void handleBlockD() throws IOException {
    }

    protected void handleBlockH() throws IOException {
    }

    protected void handleBlockN() throws IOException {
    }

    protected void handleBlockI() throws IOException {
    }

    protected abstract void handleBlockE() throws IOException;

    protected void copyCharacterField(int fromIndex, int toIndex, int length) {
        while (length > 0) {
            this.dta_bytes[toIndex] = EBCDICConverter.EBCDIC_TO_DTAUS[this.in_bytes[fromIndex] & 0xFF];
            ++fromIndex;
            ++toIndex;
            --length;
        }
    }

    protected void copyNumericalField(int fromIndex, int toIndex, int dtaLength) {
        EBCDICConverter.convertNumericalField(this.in_bytes, this.dta_bytes, this.slf.isCompressed(), fromIndex, toIndex, dtaLength);
    }

    protected void copyUnsignedNumericalField(int fromIndex, int toIndex, int dtaLength) {
        this.copyNumericalField(fromIndex, toIndex, dtaLength, (dtaLength & 1) != 0);
    }

    protected void copyNumericalField(int fromIndex, int toIndex, int dtaLength, boolean lowerNibble) {
        while (dtaLength > 0) {
            byte b;
            if (lowerNibble) {
                b = (byte)(48 + (this.in_bytes[fromIndex] & 0xF));
                lowerNibble = false;
                ++fromIndex;
            } else {
                b = (byte)(48 + ((this.in_bytes[fromIndex] & 0xFF) >> 4));
                lowerNibble = true;
            }
            this.dta_bytes[toIndex] = b;
            ++toIndex;
            --dtaLength;
        }
    }
}

