/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EBCDICConverter {
    public static final int BLOCK_SIZE = 4096;
    public static byte[] EBCDIC_TO_DTAUS = new byte[]{0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15, 16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31, -128, -127, -126, -125, -124, 10, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7, -112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26, 32, -96, -95, 123, -93, -92, -91, -90, -89, -88, 91, 46, 60, 40, 43, 33, 38, -87, -86, -85, -84, -83, -82, -81, -80, 126, 93, 36, 42, 41, 59, 94, 45, 47, -78, 91, -76, -75, -74, -73, -72, -71, 124, 44, 37, 95, 62, 63, -70, -69, -68, -67, -66, -65, -64, -63, -62, 96, 58, 35, 64, 39, 61, 34, -61, 97, 98, 99, 100, 101, 102, 103, 104, 105, -60, -59, -58, -57, -56, -55, -54, 106, 107, 108, 109, 110, 111, 112, 113, 114, -53, -52, -51, -50, -49, -48, -47, 126, 115, 116, 117, 118, 119, 120, 121, 122, -46, -45, -44, -43, -42, -41, 94, -39, -38, -37, -36, 64, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, 124, -21, -20, -19, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, 125, -15, -14, -13, 92, -97, 83, 84, 85, 86, 87, 88, 89, 90, -12, -11, 92, -9, -8, -7, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -6, -5, 93, -3, -2, -1};
    public static byte[] DTAUS_TO_EBCDIC = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 74, -32, 90, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 106, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -31, 65, 66, 67, 68, 69, 70, 71, 72, 73, 81, 82, 83, 84, 85, 86, 87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100, -99, -98, -97, -96, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37, -36, -35, -34, -33, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2, -1};

    public static byte[] convertToEbcdic(byte[] dtausBytes) {
        return EBCDICConverter.convertToEbcdic(dtausBytes, dtausBytes.length);
    }

    public static byte[] convertToEbcdic(byte[] dtausBytes, int countBytes) {
        byte[] ebcdicBytes = new byte[countBytes];
        for (int i = 0; i < countBytes; ++i) {
            ebcdicBytes[i] = DTAUS_TO_EBCDIC[dtausBytes[i] & 0xFF];
        }
        return ebcdicBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ebcdicToDtaus(InputStream ebcdicStream, OutputStream dtausStream, boolean close) throws IOException {
        try {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = ebcdicStream.read(buffer)) > 0) {
                byte[] dtausBytes = EBCDICConverter.convertToDtaus(buffer, read);
                dtausStream.write(dtausBytes);
            }
        }
        finally {
            if (close) {
                SystemUtils.close(ebcdicStream);
                SystemUtils.close(dtausStream);
            }
        }
    }

    public static void ebcdicToDtaus(InputStream ebcdicStream, OutputStream dtausStream) throws IOException {
        EBCDICConverter.ebcdicToDtaus(ebcdicStream, dtausStream, true);
    }

    public static byte[] convertToDtaus(byte[] ebcdicBytes) {
        return EBCDICConverter.convertToDtaus(ebcdicBytes, 0, ebcdicBytes.length);
    }

    public static byte[] convertToDtaus(byte[] ebcdicBytes, int countBytes) {
        return EBCDICConverter.convertToDtaus(ebcdicBytes, 0, countBytes);
    }

    public static byte[] convertToDtaus(byte[] ebcdicBytes, int firstPos, int countBytes) {
        byte[] dtausBytes = new byte[countBytes];
        for (int i = 0; i < countBytes; ++i) {
            dtausBytes[i] = EBCDIC_TO_DTAUS[ebcdicBytes[i + firstPos] & 0xFF];
        }
        return dtausBytes;
    }

    public static byte[] convertCharacterField(byte[] in_bytes, byte[] out_bytes, int fromIndex, int toIndex, int length) {
        while (length > 0) {
            out_bytes[toIndex] = EBCDIC_TO_DTAUS[in_bytes[fromIndex] & 0xFF];
            ++fromIndex;
            ++toIndex;
            --length;
        }
        return out_bytes;
    }

    public static byte[] convertNumericalField(byte[] in_bytes, byte[] out_bytes, boolean compressed, int fromIndex, int toIndex, int convertedLength) {
        if (!compressed) {
            return EBCDICConverter.convertCharacterField(in_bytes, out_bytes, fromIndex, toIndex, convertedLength);
        }
        return EBCDICConverter.convertNumericalField(in_bytes, out_bytes, fromIndex, toIndex, convertedLength, (convertedLength & 1) == 0);
    }

    public static byte[] convertUnsignedNumericalField(byte[] in_bytes, byte[] out_bytes, boolean compressed, int fromIndex, int toIndex, int convertedLength) {
        if (!compressed) {
            return EBCDICConverter.convertCharacterField(in_bytes, out_bytes, fromIndex, toIndex, convertedLength);
        }
        return EBCDICConverter.convertNumericalField(in_bytes, out_bytes, fromIndex, toIndex, convertedLength, (convertedLength & 1) != 0);
    }

    private static byte[] convertNumericalField(byte[] in_bytes, byte[] out_bytes, int fromIndex, int toIndex, int dtaLength, boolean lowerNibble) {
        while (dtaLength > 0) {
            byte b;
            if (lowerNibble) {
                b = (byte)(48 + (in_bytes[fromIndex] & 0xF));
                lowerNibble = false;
                ++fromIndex;
            } else {
                b = (byte)(48 + ((in_bytes[fromIndex] & 0xFF) >> 4));
                lowerNibble = true;
            }
            out_bytes[toIndex] = b;
            ++toIndex;
            --dtaLength;
        }
        return out_bytes;
    }

    public static byte[] getNPBytes(long number, int fieldLength) {
        return EBCDICConverter.getNPBytes(number, fieldLength, true);
    }

    public static byte[] getNPBytes(long number, int fieldLength, boolean withSign) {
        int i;
        byte[] toReturn = new byte[fieldLength];
        Object s = withSign ? (number >= 0L ? String.valueOf(number) + "C" : String.valueOf(Math.abs(number)) + "D") : String.valueOf(number);
        int countZeroesToAdd = 2 * fieldLength - ((String)s).length();
        if (countZeroesToAdd < 0) {
            throw new IllegalArgumentException("Field length " + fieldLength + " too small for number: " + number);
        }
        for (i = 0; i < countZeroesToAdd; ++i) {
            s = "0" + (String)s;
        }
        for (i = 0; i < fieldLength; ++i) {
            int beginIndex = 2 * i;
            int endIndex = beginIndex + 2;
            String sub = ((String)s).substring(beginIndex, endIndex);
            int subNumber = Integer.parseInt(sub, 16);
            toReturn[i] = (byte)subNumber;
        }
        return toReturn;
    }

    public static long getNumberFromPackedBytes(byte[] b, int firstPos, int length) {
        StringBuilder buffer = new StringBuilder();
        for (int i = firstPos; i < firstPos + length; ++i) {
            String byteAsHex = Integer.toHexString(b[i] & 0xFF);
            if (byteAsHex.length() == 1) {
                buffer.append('0');
            }
            buffer.append(byteAsHex);
        }
        int lastPos = buffer.length() - 1;
        switch (buffer.charAt(lastPos)) {
            case 'a': 
            case 'c': 
            case 'e': 
            case 'f': {
                buffer.deleteCharAt(lastPos);
                break;
            }
            case 'b': 
            case 'd': {
                buffer.deleteCharAt(lastPos);
                buffer.insert(0, '-');
            }
        }
        return Long.parseLong(buffer.toString());
    }

    public static byte[] getAlphaNumericBytes(String s, int fieldLength) {
        byte[] ascii = new byte[fieldLength];
        DTAUtil.setString(ascii, 0, fieldLength, s);
        return EBCDICConverter.convertToEbcdic(ascii);
    }

    public static String getStringFromBytes(byte[] ebcdic, int firstPos, int length) {
        byte[] ascii = EBCDICConverter.convertToDtaus(ebcdic, firstPos, length);
        return DTAUtil.getString(ascii, 0, length);
    }

    public static byte[] getNumericBytes(long number, int fieldLength) {
        byte[] toReturn = new byte[fieldLength];
        String s = String.valueOf(number);
        int countZeroesToAdd = fieldLength - s.length();
        if (countZeroesToAdd < 0) {
            throw new IllegalArgumentException("Field length " + fieldLength + " too small for number: " + number);
        }
        for (int i = 0; i < countZeroesToAdd; ++i) {
            toReturn[i] = 48;
        }
        System.arraycopy(s.getBytes(), 0, toReturn, countZeroesToAdd, s.getBytes().length);
        return EBCDICConverter.convertToEbcdic(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dtausToEbcdic(File dtausFile, File ebcdicFile) throws IOException {
        FileInputStream fis = new FileInputStream(dtausFile);
        try {
            FileOutputStream fos = new FileOutputStream(ebcdicFile);
            try {
                this.dtausToEbcdic(fis, fos);
                fis = null;
                fos = null;
            }
            finally {
                SystemUtils.close(fos);
            }
        }
        finally {
            SystemUtils.close(fis);
        }
    }

    public void dtausToEbcdic(InputStream dtausStream, OutputStream ebcdicStream) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = dtausStream.read(buffer)) > 0) {
            byte[] ebcdicBytes = EBCDICConverter.convertToEbcdic(buffer, read);
            ebcdicStream.write(ebcdicBytes);
        }
        dtausStream.close();
        ebcdicStream.close();
    }

    public void ebcdicToDtaus(File ebcdicFile, File dtausFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(ebcdicFile);
             FileOutputStream fos = new FileOutputStream(dtausFile);){
            EBCDICConverter.ebcdicToDtaus(fis, fos, true);
        }
    }
}

