/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum DtazvPaymentType {
    TYPE_00("00", false, true),
    TYPE_10("10", false, true),
    TYPE_15("15", false, true),
    TYPE_20("20", true, false),
    TYPE_21("21", true, false),
    TYPE_22("22", true, false),
    TYPE_23("23", true, false),
    TYPE_30("30", true, false),
    TYPE_31("31", true, false),
    TYPE_32("32", true, false),
    TYPE_33("33", true, false);

    private static final Map<String, ResourceBundle> bundles;
    private final String key;
    private final boolean chequeType;
    private final boolean general;

    public static DtazvPaymentType getForKey(String key) {
        for (DtazvPaymentType paymentType : DtazvPaymentType.values()) {
            if (!paymentType.key.equals(key)) continue;
            return paymentType;
        }
        return null;
    }

    private DtazvPaymentType(String key, boolean chequeType, boolean general) {
        this.key = key;
        this.chequeType = chequeType;
        this.general = general;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isChequeType() {
        return this.chequeType;
    }

    public boolean isGeneral() {
        return this.general;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.dta.DtazvPaymentType", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("DtazvPaymentType." + this.key);
        }
        catch (MissingResourceException e) {
            return "!DtazvPaymentType." + this.key + "!";
        }
    }

    static {
        bundles = new HashMap<String, ResourceBundle>();
    }
}

