/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAZVCapitalMessage;
import de.businesslogics.format.dta.DTAZVMessage;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.DTAZVTransitMessage;
import de.businesslogics.format.dta.DtazvApi;
import de.businesslogics.format.dta.DtazvFederalState;
import de.businesslogics.format.dta.DtazvFeeType;
import de.businesslogics.format.dta.DtazvInstructionCode;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.format.printer.BasePaymentPrinter;
import de.businesslogics.format.printer.PaymentPrinterMessages;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class DtazvPaymentPrinter
extends BasePaymentPrinter {
    private final String orderType;
    private boolean onePaymentPerPage = false;

    public DtazvPaymentPrinter(Locale locale, String orderType) {
        super(locale);
        this.orderType = orderType;
    }

    public void printPayment(BLDocument document, DTAZVPayment payment, String reference) throws PDFException {
        if (payment.getTransactions() == null || payment.getTransactions().size() < 1) {
            return;
        }
        boolean firstPage = true;
        for (DTAZVTransaction transaction : payment.getTransactions()) {
            List<DTAZVMessage> messages;
            Currency currency;
            if (firstPage) {
                firstPage = false;
            } else if (this.onePaymentPerPage) {
                document.newPage();
            }
            BLTable<?> table = PDFCreator.getInstance().createTable(4);
            table.setBorder(BLBorder.NO_BORDER);
            table.setWidth(100.0f);
            table.setWidths(new int[]{18, 32, 18, 32});
            String paymentType = Byte.toString(transaction.getPaymentType());
            boolean isEsuPayment = "13".equals(paymentType);
            if (isEsuPayment) {
                this.printHeaderLine(table, PaymentPrinterMessages.getString(this.locale, "paymentprinter.esupayment", new Object[0]));
            } else if ("11".equals(paymentType)) {
                this.printHeaderLine(table, PaymentPrinterMessages.getString(this.locale, "paymentprinter.euepayment", new Object[0]));
            } else {
                this.printHeaderLine(table, PaymentPrinterMessages.getString(this.locale, "paymentprinter.azvpayment", new Object[0]));
            }
            this.printOrderInfo(table, reference);
            table.setDefaultColspan(2);
            table.addCell(this.getTextOriginatorData(true), BOLD_FONT);
            table.addCell(this.getTextRecipientData(true), BOLD_FONT);
            table.setDefaultColspan(1);
            String textName = this.getTextName();
            table.addCell(textName, FONT);
            table.addCell(payment.getOriginator(), FONT);
            table.addCell(textName, FONT);
            table.addCell(transaction.getRecipient(), FONT);
            this.addEmptyCell(table);
            table.addCell(payment.getOriginator2(), FONT);
            this.addEmptyCell(table);
            table.addCell(transaction.getRecipient2(), FONT);
            String textStreet = this.getTextStreet();
            table.addCell(textStreet, FONT);
            table.addCell(payment.getOriginator3(), FONT);
            table.addCell(textStreet, FONT);
            table.addCell(transaction.getRecipient3(), FONT);
            String textTown = this.getTextTown();
            table.addCell(textTown, FONT);
            table.addCell(payment.getOriginator4(), FONT);
            table.addCell(textTown, FONT);
            table.addCell(transaction.getRecipient4(), FONT);
            if (isEsuPayment) {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            } else {
                table.addCell(this.getTextFederalState(), FONT);
                DtazvFederalState state = DtazvFederalState.getByKey(Byte.toString(payment.getCountryCode()));
                if (state != null) {
                    table.addCell(state.getName(this.locale), FONT);
                } else {
                    this.addEmptyCell(table);
                }
            }
            table.addCell(this.getTextCountry(), FONT);
            String country = this.translateCountry(transaction.getRecipientCountry());
            if (country != null) {
                table.addCell(country, FONT);
            } else {
                this.addEmptyCell(table);
            }
            String textAccountNumber = this.getTextAccountNumber();
            table.addCell(textAccountNumber, FONT);
            table.addCell(String.valueOf(transaction.getAccount()), FONT);
            boolean isChequePayment = DtazvApi.isChequePaymentType(paymentType);
            if (isChequePayment) {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            } else {
                String iban = transaction.getIban();
                if (iban != null && iban.length() > 0 && iban.charAt(0) == '/') {
                    iban = iban.substring(1);
                }
                if (iban == null || iban.length() == 0 || IbanUtil.checkIban(iban)) {
                    table.addCell(this.getTextIban(), FONT);
                    iban = IbanUtil.formatIBAN(iban);
                } else {
                    table.addCell(textAccountNumber, FONT);
                }
                table.addCell(iban == null ? "" : iban, FONT);
            }
            String textBlz = this.getTextBlz();
            String originatorBlz = String.valueOf(payment.getBlz());
            table.addCell(textBlz, FONT);
            table.addCell(originatorBlz, FONT);
            if (isChequePayment) {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            } else {
                String bic = transaction.getBic();
                if (bic != null && bic.startsWith("///")) {
                    table.addCell(textBlz, FONT);
                } else {
                    table.addCell(this.getTextBic(), FONT);
                }
                table.addCell(bic == null ? "" : bic, FONT);
            }
            table.addCell(this.getTextCurrency(), FONT);
            if (transaction.getAccountCurrency() != null) {
                table.addCell(transaction.getAccountCurrency(), FONT);
            } else {
                this.addEmptyCell(table);
            }
            boolean isBankAddressPresent = this.hasRecipientBankAddress(transaction);
            if (isBankAddressPresent) {
                table.addCell(this.getTextBank(), FONT);
                table.addCell(transaction.getBank(), FONT);
            } else {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            }
            table.addCell(this.getTextBank(), FONT);
            table.addCell(this.getBankNameFromBlz(originatorBlz), FONT);
            this.addEmptyCell(table);
            if (isBankAddressPresent) {
                table.addCell(transaction.getBank2(), FONT);
            } else {
                this.addEmptyCell(table);
            }
            if (!isEsuPayment) {
                table.addCell(this.getTextCompanyNumber(), FONT);
                if (payment.getCompanyCode() != 0) {
                    table.addCell(Integer.toString(payment.getCompanyCode()), FONT);
                } else {
                    this.addEmptyCell(table);
                }
                if (isBankAddressPresent) {
                    table.addCell(textStreet, FONT);
                    table.addCell(transaction.getBank3(), FONT);
                } else {
                    this.addEmptyCell(table);
                    this.addEmptyCell(table);
                }
            }
            table.addCell(this.getTextContact(), FONT);
            table.addCell(transaction.getContact(), FONT);
            if (isBankAddressPresent) {
                table.addCell(textTown, FONT);
                table.addCell(transaction.getBank4(), FONT);
            } else {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            }
            table.addCell(this.getTextCustomerNumber(), FONT);
            if (payment.getCustomerNumber() != 0L) {
                table.addCell(Long.toString(payment.getCustomerNumber()), FONT);
            } else {
                this.addEmptyCell(table);
            }
            if (isBankAddressPresent) {
                table.addCell(this.getTextCountry(), FONT);
                String bankCountry = this.translateCountry(transaction.getBankCountry());
                table.addCell(bankCountry, FONT);
            } else {
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            }
            table.setDefaultColspan(4);
            this.addEmptyCell(table);
            table.addCell(this.getTextPaymentData(), BOLD_FONT);
            table.setDefaultColspan(1);
            table.addCell(this.getTextAmount(), FONT);
            boolean isCounterValue = "91".equals(Byte.toString(transaction.getInstructionCode4()));
            if (isCounterValue) {
                currency = Currency.getInstance("EUR");
                table.addCell(PaymentUtils.formatAmount(transaction.getAmount(), Currency.getInstance(transaction.getAccountCurrency()), this.locale), FONT);
                table.setDefaultColspan(2);
                table.addCell(this.getTextCounterValuePayment(transaction.getCurrency()), FONT);
                table.setDefaultColspan(1);
            } else {
                currency = Currency.getInstance(transaction.getCurrency());
                table.addCell(PaymentUtils.formatAmount(transaction.getAmount(), currency, this.locale), FONT);
                this.addEmptyCell(table);
                this.addEmptyCell(table);
            }
            table.addCell(this.getTextPaymentType(), FONT);
            DtazvPaymentType dtazvPaymentType = DtazvPaymentType.getForKey(paymentType);
            if (dtazvPaymentType == null) {
                table.addCell(DtazvPaymentType.TYPE_00.getDescription(this.locale), FONT);
            } else {
                table.addCell(dtazvPaymentType.getDescription(this.locale));
            }
            table.addCell(this.getTextExecutionDate(true), FONT);
            Date date = transaction.getExecutionDate();
            if (date == null) {
                date = payment.getExecutionDate();
            }
            this.printDate(table, date);
            table.addCell(this.getTextOrderType(), FONT);
            table.addCell(this.orderType, FONT);
            table.addCell(this.getTextReference(), FONT);
            table.addCell(transaction.getReference(), FONT);
            table.addCell(this.getTextPurpose(), FONT);
            table.setDefaultColspan(3);
            table.addCell(transaction.getPurpose(), FONT);
            table.setDefaultColspan(1);
            this.addLineWithoutLabel(table, transaction.getPurpose2());
            this.addLineWithoutLabel(table, transaction.getPurpose3());
            this.addLineWithoutLabel(table, transaction.getPurpose4());
            if (isChequePayment) {
                table.addCell(this.getTextOrderComment(), FONT);
                table.setDefaultColspan(3);
                table.addCell(transaction.getOrderComment(), FONT);
                table.setDefaultColspan(1);
                this.addLineWithoutLabel(table, transaction.getOrderComment2());
            }
            if (!isEsuPayment && transaction.getFeeBlz() > 0) {
                String feeAccountDisplayName = String.valueOf(transaction.getFeeBlz()) + "/" + transaction.getFeeAccount() + "/" + transaction.getFeeCurrency();
                table.addCell(this.getTextFeeAccount(), FONT);
                table.setDefaultColspan(3);
                table.addCell(feeAccountDisplayName, FONT);
                table.setDefaultColspan(1);
            }
            table.addCell(this.getTextFeeType(), FONT);
            table.setDefaultColspan(3);
            DtazvFeeType feeType = DtazvFeeType.getByKey(Byte.toString(transaction.getFeeType()));
            if (feeType == null) {
                table.addCell(DtazvFeeType.TYPE_00.getDescription(this.locale), FONT);
            } else {
                table.addCell(feeType.getDescription(this.locale), FONT);
            }
            table.setDefaultColspan(1);
            if (!isEsuPayment && !isChequePayment) {
                String additionalInfo;
                DtazvInstructionCode instrCode1 = DtazvInstructionCode.getByKey(Byte.toString(transaction.getInstructionCode()));
                DtazvInstructionCode instrCode2 = DtazvInstructionCode.getByKey(Byte.toString(transaction.getInstructionCode2()));
                DtazvInstructionCode instrCode3 = DtazvInstructionCode.getByKey(Byte.toString(transaction.getInstructionCode3()));
                DtazvInstructionCode instrCode4 = DtazvInstructionCode.getByKey(Byte.toString(transaction.getInstructionCode4()));
                if (instrCode1 != null && instrCode1 != DtazvInstructionCode.TYPE_00 || instrCode2 != null && instrCode2 != DtazvInstructionCode.TYPE_00 || instrCode3 != null && instrCode3 != DtazvInstructionCode.TYPE_00 || instrCode4 != null && instrCode4 != DtazvInstructionCode.TYPE_00) {
                    table.addCell(this.getTextInstructionCode1(), FONT);
                    this.addInstructionCode(table, instrCode1);
                    table.addCell(this.getTextInstructionCode2(), FONT);
                    this.addInstructionCode(table, instrCode2);
                    table.addCell(this.getTextInstructionCode3(), FONT);
                    this.addInstructionCode(table, instrCode3);
                    table.addCell(this.getTextInstructionCode4(), FONT);
                    this.addInstructionCode(table, instrCode4);
                }
                if ((additionalInfo = transaction.getInstructions()) != null && additionalInfo.length() > 0) {
                    table.addCell(this.getTextInstructions(), FONT);
                    table.setDefaultColspan(3);
                    table.addCell(transaction.getInstructions(), FONT);
                    table.setDefaultColspan(1);
                }
            }
            boolean hasMessages = (messages = transaction.getMessages()) != null && messages.size() > 0;
            document.addTable(table);
            if (!hasMessages) continue;
            BLTable<?> t2 = PDFCreator.getInstance().createTable(3);
            t2.setBorder(BLBorder.NO_BORDER);
            t2.setWidth(100.0f);
            t2.setWidths(new int[]{40, 40, 20});
            t2.setDefaultColspan(3);
            t2.addCell(this.getTextMessages(), BOLD_FONT);
            t2.setDefaultColspan(1);
            t2.addCell(this.getTextType(), BOLD_FONT);
            t2.addCell(this.getTextMessageDescription(), BOLD_FONT);
            t2.addCell(this.getTextAmount(), BOLD_FONT);
            for (DTAZVMessage message : messages) {
                if (message instanceof DTAZVCapitalMessage) {
                    DTAZVCapitalMessage capitalMessage = (DTAZVCapitalMessage)message;
                    t2.addCell(this.getTextCapitalType(), FONT);
                    t2.addCell(capitalMessage.getDescription(), FONT);
                    t2.addCell(PaymentUtils.formatAmount(BigDecimal.valueOf(capitalMessage.getAmount()), Currency.getInstance(transaction.getCurrency()), this.locale), FONT);
                    continue;
                }
                if (!(message instanceof DTAZVTransitMessage)) continue;
                DTAZVTransitMessage transitMessage = (DTAZVTransitMessage)message;
                t2.addCell(this.getTextTransitType(), FONT);
                t2.addCell(transitMessage.getBuyDesciption(), FONT);
                t2.addCell(PaymentUtils.formatAmount(BigDecimal.valueOf(transitMessage.getBuyPrice()), currency, this.locale), FONT);
            }
            document.addTable(t2);
        }
    }

    protected abstract void printOrderInfo(BLTable<?> var1, String var2) throws PDFException;

    private boolean hasRecipientBankAddress(DTAZVTransaction transaction) {
        return transaction.getBank() != null && transaction.getBank().length() > 0 || transaction.getBank2() != null && transaction.getBank2().length() > 0 || transaction.getBank3() != null && transaction.getBank3().length() > 0 || transaction.getBank4() != null && transaction.getBank4().length() > 0 || transaction.getBankCountry() != null && transaction.getBankCountry().length() > 0;
    }

    private void addInstructionCode(BLTable<?> t, DtazvInstructionCode instrCode) throws PDFException {
        t.setDefaultColspan(3);
        if (instrCode == null || instrCode == DtazvInstructionCode.TYPE_00) {
            this.addEmptyCell(t);
        } else {
            t.addCell(instrCode.getDescription(this.locale), FONT);
        }
        t.setDefaultColspan(1);
    }

    public boolean isOnePaymentPerPage() {
        return this.onePaymentPerPage;
    }

    protected String getBankNameFromBlz(String blz) {
        return super.getBankNameFromBlz(blz, null);
    }

    public void setOnePaymentPerPage(boolean onePaymentPerPage) {
        this.onePaymentPerPage = onePaymentPerPage;
    }
}

