/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum DtazvInstructionCode {
    TYPE_00("0", true),
    TYPE_02("2", false),
    TYPE_04("4", false),
    TYPE_06("6", false),
    TYPE_07("7", false),
    TYPE_09("9", false),
    TYPE_10("10", true),
    TYPE_11("11", true),
    TYPE_12("12", true);

    private static final Map<String, ResourceBundle> bundles;
    private String key;
    private boolean usedForEue;

    public static DtazvInstructionCode getByKey(String key) {
        for (DtazvInstructionCode instructionCode : DtazvInstructionCode.values()) {
            if (!instructionCode.key.equals(key)) continue;
            return instructionCode;
        }
        return null;
    }

    private DtazvInstructionCode(String key, boolean usedForEue) {
        this.key = key;
        this.usedForEue = usedForEue;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isUsedForEue() {
        return this.usedForEue;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.dta.DtazvInstructionCode", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("DtazvInstructionCode." + this.key);
        }
        catch (MissingResourceException e) {
            return "!DtazvInstructionCode." + this.key + "!";
        }
    }

    static {
        bundles = new HashMap<String, ResourceBundle>();
    }
}

