/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum DtazvFederalState {
    EMPTY("0"),
    BE("1"),
    BY("11"),
    HE("12"),
    BW("13"),
    HB("14"),
    NI("21"),
    NW("22"),
    SH("23"),
    HH("24"),
    RP("31"),
    SL("32"),
    MV("41"),
    BB("42"),
    ST("43"),
    SN("44"),
    TH("45");

    private static final Map<String, ResourceBundle> BUNDLES;
    private final String key;

    public static DtazvFederalState getByKey(String key) {
        for (DtazvFederalState state : DtazvFederalState.values()) {
            if (!state.getKey().equals(key)) continue;
            return state;
        }
        return null;
    }

    public static DtazvFederalState[] sortedValues(final Locale locale) {
        ArrayList<DtazvFederalState> states = new ArrayList<DtazvFederalState>();
        for (int i = 0; i < DtazvFederalState.values().length; ++i) {
            if (DtazvFederalState.values()[i] == EMPTY) continue;
            states.add(DtazvFederalState.values()[i]);
        }
        final Collator collator = Collator.getInstance(locale);
        collator.setStrength(2);
        Collections.sort(states, new Comparator<DtazvFederalState>(){

            @Override
            public int compare(DtazvFederalState o1, DtazvFederalState o2) {
                return collator.compare(o1.getName(locale), o2.getName(locale));
            }
        });
        DtazvFederalState[] result = new DtazvFederalState[DtazvFederalState.values().length];
        int index = 0;
        result[index++] = EMPTY;
        for (DtazvFederalState state : states) {
            result[index++] = state;
        }
        return result;
    }

    private DtazvFederalState(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public String getName(Locale locale) {
        ResourceBundle bundle = BUNDLES.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.dta.DtazvFederalState");
            BUNDLES.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("DtazvFederalState." + this.key);
        }
        catch (MissingResourceException e) {
            return "!DtazvFederalState." + this.key + "!";
        }
    }

    static {
        BUNDLES = new HashMap<String, ResourceBundle>();
    }
}

