/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAZVItem;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DTAZV_TBlock
implements Serializable {
    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyMMdd");
        }
    };
    private final byte[] feeAccount = new byte[10];
    private final byte[] feeAccountCurrency = new byte[3];
    private final byte[] feeBankcode = new byte[8];
    private final byte[] account = new byte[10];
    private final byte[] accountCurrency = new byte[3];
    private final byte[] bankcode = new byte[8];
    private final byte[] currency = new byte[3];
    private final byte[] executionDate = new byte[6];
    private transient Date executionDateAsDate;
    private transient String accountAsString;
    private transient String bankcodeAsString;
    private String accountCurrencyAsString;
    private transient String feeAccountAsString;
    private transient String feeBankcodeAsString;
    private String feeAccountCurrencyAsString;
    private transient String currencyAsString;
    private boolean isCounterValuePayment = false;
    private static final long serialVersionUID = 2647526290433893706L;

    public DTAZV_TBlock(DTAZVLogicalFile logicalFile, DTAZVItem item) {
        System.arraycopy(item.tblock, 5, this.bankcode, 0, this.bankcode.length);
        System.arraycopy(item.tblock, 13, this.accountCurrency, 0, this.accountCurrency.length);
        System.arraycopy(item.tblock, 16, this.account, 0, this.account.length);
        boolean tExecutionDate = false;
        for (int i = 26; i < 32; ++i) {
            if (item.tblock[i] == 48) continue;
            tExecutionDate = true;
            System.arraycopy(item.tblock, 26, this.executionDate, 0, 6);
            break;
        }
        if (!tExecutionDate) {
            System.arraycopy(logicalFile.q_block, 171, this.executionDate, 0, 6);
        }
        System.arraycopy(item.tblock, 455, this.currency, 0, this.currency.length);
        this.isCounterValuePayment = "91".equals(item.getInstructionCode4());
        System.arraycopy(item.tblock, 32, this.feeBankcode, 0, this.bankcode.length);
        System.arraycopy(item.tblock, 40, this.feeAccountCurrency, 0, this.accountCurrency.length);
        System.arraycopy(item.tblock, 43, this.feeAccount, 0, this.account.length);
    }

    public byte[] getAccount() {
        return this.account;
    }

    public byte[] getAccountCurrency() {
        return this.accountCurrency;
    }

    public byte[] getBankcode() {
        return this.bankcode;
    }

    public byte[] getCurrency() {
        return this.currency;
    }

    public byte[] getExecutionDate() {
        return this.executionDate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTAZV_TBlock other = (DTAZV_TBlock)obj;
        if (!Arrays.equals(this.account, other.account)) {
            return false;
        }
        if (!Arrays.equals(this.accountCurrency, other.accountCurrency)) {
            return false;
        }
        if (!Arrays.equals(this.bankcode, other.bankcode)) {
            return false;
        }
        if (!Arrays.equals(this.currency, other.currency)) {
            return false;
        }
        if (!Arrays.equals(this.executionDate, other.executionDate)) {
            return false;
        }
        return this.isCounterValuePayment == other.isCounterValuePayment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.account);
        result = 31 * result + Arrays.hashCode(this.accountCurrency);
        result = 31 * result + Arrays.hashCode(this.bankcode);
        result = 31 * result + Arrays.hashCode(this.currency);
        result = 31 * result + Arrays.hashCode(this.executionDate);
        result = 31 * result + (this.isCounterValuePayment ? 1231 : 1237);
        return result;
    }

    public String getAccountAsString() {
        if (this.accountAsString == null) {
            this.accountAsString = new String(this.account);
        }
        return this.accountAsString;
    }

    public String getBankcodeAsString() {
        if (this.bankcodeAsString == null) {
            this.bankcodeAsString = new String(this.bankcode);
        }
        return this.bankcodeAsString;
    }

    public String getCurrencyAsString() {
        if (this.currencyAsString == null) {
            this.currencyAsString = new String(this.currency);
        }
        return this.currencyAsString;
    }

    public String getAccountCurrencyAsString() {
        if (this.accountCurrencyAsString == null) {
            this.accountCurrencyAsString = new String(this.accountCurrency);
        }
        return this.accountCurrencyAsString;
    }

    public String getFeeAccountCurrencyAsString() {
        if (this.feeAccountCurrencyAsString == null) {
            this.feeAccountCurrencyAsString = new String(this.feeAccountCurrency);
        }
        return this.feeAccountCurrencyAsString;
    }

    public String getFeeAccountAsString() {
        if (this.feeAccountAsString == null) {
            this.feeAccountAsString = new String(this.feeAccount);
        }
        return this.feeAccountAsString;
    }

    public String getFeeBankcodeAsString() {
        if (this.feeBankcodeAsString == null) {
            this.feeBankcodeAsString = new String(this.feeBankcode);
        }
        return this.feeBankcodeAsString;
    }

    public boolean isSameFeeAccount() {
        return "00000000".equals(this.getFeeBankcodeAsString()) && "0000000000".equals(this.getFeeAccountAsString()) && "   ".equals(this.getFeeAccountCurrencyAsString()) || this.getFeeBankcodeAsString().equals(this.getBankcodeAsString()) && this.getFeeAccountAsString().equals(this.getAccountAsString()) && this.getFeeAccountCurrencyAsString().equals(this.getAccountCurrencyAsString());
    }

    public boolean isSameFeeBankCode() {
        return "00000000".equals(this.getFeeBankcodeAsString()) || this.getFeeBankcodeAsString().equals(this.getBankcodeAsString());
    }

    public Date getExecutionDateAsDate() throws ParseException {
        if (this.executionDateAsDate == null) {
            this.executionDateAsDate = DATE_FORMAT.get().parse(new String(this.executionDate));
        }
        return this.executionDateAsDate;
    }

    public String getCurrencyThatCorrespondsToAmount() {
        if (this.isCounterValuePayment) {
            return "EUR";
        }
        return this.getCurrencyAsString();
    }

    public boolean isCounterValuePayment() {
        return this.isCounterValuePayment;
    }
}

