/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVMessage;
import java.io.IOException;
import java.util.Date;

public class DTAZVTransitMessage
extends DTAZVMessage {
    protected static byte[] V_HEADER = "0256V".getBytes();
    private static byte[] V_RESERVE = "                                                                                       ".getBytes();
    private Date soldDate = new Date();
    private String buyCountry;
    private String buyDesciption;
    private String soldCountry;
    private String soldDecription;
    private String soldTo;
    private boolean soldNonResident;
    private boolean soldResident;
    private boolean store;
    private byte buyCategory;
    private byte soldCategory;
    private long buyPrice;
    private long soldPrice;

    public void setBuyCategory(byte buyCategory) {
        this.buyCategory = buyCategory;
    }

    public byte getBuyCategory() {
        return this.buyCategory;
    }

    public void setBuyCountry(String buyCountry) {
        this.buyCountry = buyCountry;
    }

    public String getBuyCountry() {
        return this.buyCountry;
    }

    public void setBuyDesciption(String buyDesciption) {
        this.buyDesciption = buyDesciption;
    }

    public String getBuyDesciption() {
        return this.buyDesciption;
    }

    public void setBuyPrice(long buyPrice) {
        this.buyPrice = buyPrice;
    }

    public long getBuyPrice() {
        return this.buyPrice;
    }

    public void setSoldCategory(byte soldCategory) {
        this.soldCategory = soldCategory;
    }

    public byte getSoldCategory() {
        return this.soldCategory;
    }

    public void setSoldCountry(String soldCountry) {
        this.soldCountry = soldCountry;
    }

    public String getSoldCountry() {
        return this.soldCountry;
    }

    public void setSoldDate(Date soldDate) {
        this.soldDate = soldDate;
    }

    public Date getSoldDate() {
        return this.soldDate;
    }

    public void setSoldDecription(String soldDecription) {
        this.soldDecription = soldDecription;
    }

    public String getSoldDecription() {
        return this.soldDecription;
    }

    public void setSoldNonResident(boolean soldNonResident) {
        this.soldNonResident = soldNonResident;
    }

    public boolean isSoldNonResident() {
        return this.soldNonResident;
    }

    public void setSoldPrice(long soldPrice) {
        this.soldPrice = soldPrice;
    }

    public long getSoldPrice() {
        return this.soldPrice;
    }

    public void setSoldResident(boolean soldResident) {
        this.soldResident = soldResident;
    }

    public boolean isSoldResident() {
        return this.soldResident;
    }

    public void setSoldTo(String soldTo) {
        this.soldTo = soldTo;
    }

    public String getSoldTo() {
        return this.soldTo;
    }

    public void setStore(boolean store) {
        this.store = store;
    }

    public boolean isStore() {
        return this.store;
    }

    public static DTAZVTransitMessage readFrom(DTAReader r) throws IOException {
        DTAZVTransitMessage m = new DTAZVTransitMessage();
        m.buyDesciption = r.readString(27);
        m.buyCategory = r.readByte(2);
        r.skip(14);
        m.buyCountry = r.readString(3);
        m.buyPrice = r.readLong(12);
        m.soldNonResident = r.readBoolean();
        m.soldResident = r.readBoolean();
        r.skip(1);
        m.store = r.readBoolean();
        m.soldDecription = r.readString(27);
        m.soldCategory = r.readByte(2);
        r.skip(7);
        m.soldDate = r.readYYMMDate();
        r.skip(7);
        m.soldCountry = r.readString(3);
        m.soldPrice = r.readLong(12);
        m.soldTo = r.readString(40);
        r.skip(V_RESERVE.length);
        return m;
    }

    @Override
    public void writeTo(DTAWriter w) throws IOException {
        w.write(V_HEADER);
        w.write(this.buyDesciption, 27);
        w.write(this.buyCategory, 2);
        w.write(0, 7);
        w.write(DTAZVTransitMessage.getCountry(this.buyCountry), 7);
        w.write(this.buyCountry, 3);
        w.write(this.buyPrice, 12);
        w.write(this.soldNonResident);
        w.write(this.soldResident);
        w.write(' ');
        w.write(this.store);
        w.write(this.soldDecription, 27);
        w.write(this.soldCategory, 2);
        w.write(0, 7);
        if (this.soldDate != null) {
            w.writeYYMM(this.soldDate);
        } else {
            w.writeBlanks(4);
        }
        w.write(DTAZVTransitMessage.getCountry(this.soldCountry), 7);
        w.write(this.soldCountry, 3);
        w.write(this.soldPrice, 12);
        w.write(this.soldTo, 40);
        w.write(V_RESERVE);
    }
}

