/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVCapitalMessage;
import de.businesslogics.format.dta.DTAZVMessage;
import de.businesslogics.format.dta.DTAZVTransitMessage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DTAZVTransaction
implements Cloneable {
    protected static byte[] T_HEADER = "0768T".getBytes();
    private static byte[] T_RESERVE = "                                                   ".getBytes();
    private BigDecimal amount;
    private Date executionDate;
    private List<DTAZVMessage> messages = new ArrayList<DTAZVMessage>();
    private String accountCurrency;
    private String bank;
    private String bank2;
    private String bank3;
    private String bank4;
    private String bankCountry;
    private String bic;
    private String contact;
    private String currency;
    private String feeCurrency;
    private String iban;
    private String instructions;
    private String orderComment;
    private String orderComment2;
    private String purpose;
    private String purpose2;
    private String purpose3;
    private String purpose4;
    private String recipient;
    private String recipient2;
    private String recipient3;
    private String recipient4;
    private String recipientCountry;
    private String reference;
    private boolean bundesbankReport = false;
    private byte feeType;
    private byte instructionCode;
    private byte instructionCode2;
    private byte instructionCode3;
    private byte instructionCode4;
    private byte paymentType;
    private int blz;
    private int feeBlz;
    private long account;
    private long feeAccount;

    public void setAccount(long account) {
        this.account = account;
    }

    public long getAccount() {
        return this.account;
    }

    public void setAccountCurrency(String accountCurrency) {
        this.accountCurrency = accountCurrency;
    }

    public String getAccountCurrency() {
        return this.accountCurrency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount.divide(BigDecimal.ONE, 3, 4);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank2(String bank2) {
        this.bank2 = bank2;
    }

    public String getBank2() {
        return this.bank2;
    }

    public void setBank3(String bank3) {
        this.bank3 = bank3;
    }

    public String getBank3() {
        return this.bank3;
    }

    public void setBank4(String bank4) {
        this.bank4 = bank4;
    }

    public String getBank4() {
        return this.bank4;
    }

    public void setBankCountry(String bankCountry) {
        this.bankCountry = bankCountry;
    }

    public String getBankCountry() {
        return this.bankCountry;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public String getBic() {
        return this.bic;
    }

    public void setBlz(int blz) {
        this.blz = blz;
    }

    public int getBlz() {
        return this.blz;
    }

    public void setBundesbankReport(boolean bundesbankReport) {
        this.bundesbankReport = bundesbankReport;
    }

    public boolean isBundesbankReport() {
        return this.bundesbankReport;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContact() {
        return this.contact;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setFeeAccount(long feeAccount) {
        this.feeAccount = feeAccount;
    }

    public long getFeeAccount() {
        return this.feeAccount;
    }

    public void setFeeBlz(int feeBlz) {
        this.feeBlz = feeBlz;
    }

    public int getFeeBlz() {
        return this.feeBlz;
    }

    public void setFeeCurrency(String feeCurrency) {
        this.feeCurrency = feeCurrency;
    }

    public String getFeeCurrency() {
        return this.feeCurrency;
    }

    public void setFeeType(byte feeType) {
        this.feeType = feeType;
    }

    public byte getFeeType() {
        return this.feeType;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public String getIban() {
        return this.iban;
    }

    public void setInstructionCode(byte instructionCode) {
        this.instructionCode = instructionCode;
    }

    public byte getInstructionCode() {
        return this.instructionCode;
    }

    public void setInstructionCode2(byte instructionCode2) {
        this.instructionCode2 = instructionCode2;
    }

    public byte getInstructionCode2() {
        return this.instructionCode2;
    }

    public void setInstructionCode3(byte instructionCode3) {
        this.instructionCode3 = instructionCode3;
    }

    public byte getInstructionCode3() {
        return this.instructionCode3;
    }

    public void setInstructionCode4(byte instructionCode4) {
        this.instructionCode4 = instructionCode4;
    }

    public byte getInstructionCode4() {
        return this.instructionCode4;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setMessages(List<DTAZVMessage> messages) {
        this.messages = messages;
    }

    public List<DTAZVMessage> getMessages() {
        return this.messages;
    }

    public void setOrderComment(String orderComment) {
        this.orderComment = orderComment;
    }

    public String getOrderComment() {
        return this.orderComment;
    }

    public void setOrderComment2(String orderComment2) {
        this.orderComment2 = orderComment2;
    }

    public String getOrderComment2() {
        return this.orderComment2;
    }

    public void setPaymentType(byte paymentType) {
        this.paymentType = paymentType;
    }

    public byte getPaymentType() {
        return this.paymentType;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose2(String purpose2) {
        this.purpose2 = purpose2;
    }

    public String getPurpose2() {
        return this.purpose2;
    }

    public void setPurpose3(String purpose3) {
        this.purpose3 = purpose3;
    }

    public String getPurpose3() {
        return this.purpose3;
    }

    public void setPurpose4(String purpose4) {
        this.purpose4 = purpose4;
    }

    public String getPurpose4() {
        return this.purpose4;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient2(String recipient2) {
        this.recipient2 = recipient2;
    }

    public String getRecipient2() {
        return this.recipient2;
    }

    public void setRecipient3(String recipient3) {
        this.recipient3 = recipient3;
    }

    public String getRecipient3() {
        return this.recipient3;
    }

    public void setRecipient4(String recipient4) {
        this.recipient4 = recipient4;
    }

    public String getRecipient4() {
        return this.recipient4;
    }

    public void setRecipientCountry(String recipientCountry) {
        this.recipientCountry = recipientCountry;
    }

    public String getRecipientCountry() {
        return this.recipientCountry;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    public static DTAZVTransaction readFrom(DTAReader r) throws IOException {
        DTAZVTransaction t = new DTAZVTransaction();
        t.blz = r.readInt(8);
        t.accountCurrency = r.readString(3);
        t.account = r.readLong(10);
        t.executionDate = r.readYYMMDDDate();
        t.feeBlz = r.readInt(8);
        t.feeCurrency = r.readString(3);
        t.feeAccount = r.readLong(10);
        t.bic = r.readString(11);
        t.bankCountry = r.readString(3);
        t.bank = r.readString(35);
        t.bank2 = r.readString(35);
        t.bank3 = r.readString(35);
        t.bank4 = r.readString(35);
        t.recipientCountry = r.readString(3);
        t.recipient = r.readString(35);
        t.recipient2 = r.readString(35);
        t.recipient3 = r.readString(35);
        t.recipient4 = r.readString(35);
        t.orderComment = r.readString(35);
        t.orderComment2 = r.readString(35);
        t.iban = r.readString(35);
        t.currency = r.readString(3);
        t.amount = r.readBigDecimal(14, 3);
        t.purpose = r.readString(35);
        t.purpose2 = r.readString(35);
        t.purpose3 = r.readString(35);
        t.purpose4 = r.readString(35);
        t.instructionCode = r.readByte(2);
        t.instructionCode2 = r.readByte(2);
        t.instructionCode3 = r.readByte(2);
        t.instructionCode4 = r.readByte(2);
        t.instructions = r.readString(25);
        t.feeType = r.readByte(2);
        t.paymentType = r.readByte(2);
        t.reference = r.readString(27);
        t.contact = r.readString(35);
        char c = r.readChar();
        t.bundesbankReport = c != '0';
        r.skip(T_RESERVE.length);
        int m = r.readByte(2);
        byte[] buffer = new byte[5];
        for (int i = 0; i < m; ++i) {
            r.readFully(buffer);
            if (Arrays.equals(buffer, DTAZVCapitalMessage.W_HEADER)) {
                t.messages.add(DTAZVCapitalMessage.readFrom(r));
                continue;
            }
            if (Arrays.equals(buffer, DTAZVTransitMessage.V_HEADER)) {
                t.messages.add(DTAZVTransitMessage.readFrom(r));
                continue;
            }
            r.skip(256);
        }
        return t;
    }

    public void writeTo(DTAWriter w) throws IOException {
        w.write(T_HEADER);
        w.write(this.blz, 8);
        w.write(this.accountCurrency, 3);
        w.write(this.account, 10);
        if (this.executionDate == null) {
            w.write("000000", 6);
        } else {
            w.writeYYMMDD(this.executionDate);
        }
        w.write(this.feeBlz, 8);
        w.write(this.feeCurrency, 3);
        w.write(this.feeAccount, 10);
        w.write(this.bic, 11);
        w.write(this.bankCountry, 3);
        w.write(this.bank, 35);
        w.write(this.bank2, 35);
        w.write(this.bank3, 35);
        w.write(this.bank4, 35);
        w.write(this.recipientCountry, 3);
        w.write(this.recipient, 35);
        w.write(this.recipient2, 35);
        w.write(this.recipient3, 35);
        w.write(this.recipient4, 35);
        w.write(this.orderComment, 35);
        w.write(this.orderComment2, 35);
        w.write(this.iban, 35);
        w.write(this.currency, 3);
        w.write(this.amount, 14, 3);
        w.write(this.purpose, 35);
        w.write(this.purpose2, 35);
        w.write(this.purpose3, 35);
        w.write(this.purpose4, 35);
        w.write(this.instructionCode, 2);
        w.write(this.instructionCode2, 2);
        w.write(this.instructionCode3, 2);
        w.write(this.instructionCode4, 2);
        w.write(this.instructions, 25);
        w.write(this.feeType, 2);
        w.write(this.paymentType, 2);
        w.write(this.reference, 27);
        w.write(this.contact, 35);
        if (this.bundesbankReport) {
            w.write('1');
        } else {
            w.write('0');
        }
        w.write(T_RESERVE);
        w.write(this.messages.size(), 2);
        Iterator<DTAZVMessage> j = this.messages.iterator();
        for (int c = 0; j.hasNext() && c < 8; ++c) {
            j.next().writeTo(w);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

