/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVTransaction;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DTAZVPayment {
    private static byte[] Q_HEADER = "0256Q".getBytes();
    private static byte[] Z_HEADER = "0256Z".getBytes();
    private static byte[] Q_RESERVE = "                                                                    ".getBytes();
    private static byte[] Z_RESERVE = "                                                                                                                                                                                                                             ".getBytes();
    private Date creationDate = new Date();
    private Date executionDate = new Date();
    private List<DTAZVTransaction> transactions = new ArrayList<DTAZVTransaction>();
    private String originator;
    private String originator2;
    private String originator3;
    private String originator4;
    private boolean bundesbankReport;
    private byte countryCode;
    private byte sequentialNumber;
    private int blz;
    private int companyCode;
    private long customerNumber;
    private long sum = 0L;
    private int count = 0;
    private DTAWriter writer = null;

    public void setBlz(int blz) {
        this.blz = blz;
    }

    public int getBlz() {
        return this.blz;
    }

    public void setBundesbankReport(boolean bundesbankReport) {
        this.bundesbankReport = bundesbankReport;
    }

    public boolean isBundesbankReport() {
        return this.bundesbankReport;
    }

    public void setCompanyCode(int companyCode) {
        this.companyCode = companyCode;
    }

    public int getCompanyCode() {
        return this.companyCode;
    }

    public void setCountryCode(byte countryCode) {
        this.countryCode = countryCode;
    }

    public byte getCountryCode() {
        return this.countryCode;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCustomerNumber(long customerNumber) {
        this.customerNumber = customerNumber;
    }

    public long getCustomerNumber() {
        return this.customerNumber;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator2(String originator2) {
        this.originator2 = originator2;
    }

    public String getOriginator2() {
        return this.originator2;
    }

    public void setOriginator3(String originator3) {
        this.originator3 = originator3;
    }

    public String getOriginator3() {
        return this.originator3;
    }

    public void setOriginator4(String originator4) {
        this.originator4 = originator4;
    }

    public String getOriginator4() {
        return this.originator4;
    }

    public void setSequentialNumber(byte sequentialNumber) {
        this.sequentialNumber = sequentialNumber;
    }

    public byte getSequentialNumber() {
        return this.sequentialNumber;
    }

    public List<DTAZVTransaction> getTransactions() {
        return this.transactions;
    }

    public static DTAZVPayment readFrom(DTAReader r) throws IOException {
        DTAZVPayment p = new DTAZVPayment();
        byte[] t = new byte[5];
        try {
            r.readFully(t);
        }
        catch (EOFException eof) {
            return null;
        }
        if (!Arrays.equals(t, Q_HEADER)) {
            throw new IOException("invalid file");
        }
        p.blz = r.readInt(8);
        p.customerNumber = r.readLong(10);
        p.originator = r.readString(35);
        p.originator2 = r.readString(35);
        p.originator3 = r.readString(35);
        p.originator4 = r.readString(35);
        p.creationDate = r.readYYMMDDDate();
        p.sequentialNumber = r.readByte(2);
        p.executionDate = r.readYYMMDDDate();
        p.bundesbankReport = r.readBoolean();
        p.countryCode = r.readByte(2);
        p.companyCode = r.readInt(8);
        r.skip(Q_RESERVE.length);
        r.readFully(t);
        while (true) {
            if (Arrays.equals(t, DTAZVTransaction.T_HEADER)) {
                DTAZVTransaction trans = DTAZVTransaction.readFrom(r);
                if (trans.getExecutionDate() == null) {
                    trans.setExecutionDate(p.getExecutionDate());
                }
                p.transactions.add(trans);
            } else if (Arrays.equals(t, Z_HEADER)) break;
            r.readFully(t);
        }
        r.skip(251);
        return p;
    }

    private void writeQ(DTAWriter w) throws IOException {
        w.write(Q_HEADER);
        w.write(this.blz, 8);
        w.write(this.customerNumber, 10);
        w.write(this.originator, 35);
        w.write(this.originator2, 35);
        w.write(this.originator3, 35);
        w.write(this.originator4, 35);
        w.writeYYMMDD(this.creationDate);
        w.write(this.sequentialNumber, 2);
        w.writeYYMMDD(this.executionDate);
        w.write(this.bundesbankReport);
        w.write(this.countryCode, 2);
        w.write(this.companyCode, 8);
        w.write(Q_RESERVE);
    }

    private static void writeZ(DTAWriter w, long sum, int count) throws IOException {
        w.write(Z_HEADER);
        w.write(sum, 15);
        w.write(count, 15);
        w.write(Z_RESERVE);
    }

    public void writeTo(DTAWriter w) throws IOException {
        this.writeQ(w);
        long sum = 0L;
        int count = 0;
        for (DTAZVTransaction t : this.transactions) {
            t.writeTo(w);
            if (t.getAmount() != null) {
                sum += t.getAmount().longValue();
            }
            ++count;
        }
        DTAZVPayment.writeZ(w, sum, count);
    }

    public void writeToStreamed(DTAWriter w) throws IOException {
        this.writeQ(w);
        this.sum = 0L;
        this.count = 0;
        this.writer = w;
    }

    public void writeToStreamed(DTAZVTransaction t) throws IOException {
        t.writeTo(this.writer);
        if (t.getAmount() != null) {
            this.sum += t.getAmount().longValue();
        }
        ++this.count;
    }

    public void closeStreamed() throws IOException {
        DTAZVPayment.writeZ(this.writer, this.sum, this.count);
        this.writer = null;
        this.sum = 0L;
        this.count = 0;
    }
}

