/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.DTAZV_TBlock;
import de.businesslogics.format.dta.InvalidAccountNumberException;
import de.businesslogics.format.dta.InvalidBankcodeException;
import de.businesslogics.format.dta.InvalidDateException;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.InvalidNumberOfPaymentsException;
import de.businesslogics.format.dta.InvalidSumAmountException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DTAZVLogicalFile
implements Serializable {
    byte[] q_block;
    byte[] z_block;
    boolean warnRegulatoryBlock = false;
    private final Map<DTAZV_TBlock, Long> tBlocks = new HashMap<DTAZV_TBlock, Long>();
    private static final long serialVersionUID = 1L;

    DTAZVLogicalFile(byte[] block) {
        this.q_block = new byte[256];
        System.arraycopy(block, 0, this.q_block, 0, 256);
    }

    public String getQ3() {
        return DTAUtil.getString(this.q_block, 5, 8);
    }

    public String getQ4() {
        return DTAUtil.getString(this.q_block, 13, 10);
    }

    public String getQ6() {
        return DTAUtil.getString(this.q_block, 163, 6);
    }

    public String getQ7() {
        return DTAUtil.getString(this.q_block, 169, 2);
    }

    public String getQ8() {
        return DTAUtil.getString(this.q_block, 171, 6);
    }

    public String getQ9() {
        return DTAUtil.getString(this.q_block, 177, 1);
    }

    public String getQ10() {
        return DTAUtil.getString(this.q_block, 178, 2);
    }

    public String getQ11() {
        return DTAUtil.getString(this.q_block, 180, 8);
    }

    public String getZ3() {
        return DTAUtil.getString(this.z_block, 5, 15);
    }

    public String getZ4() {
        return DTAUtil.getString(this.z_block, 20, 15);
    }

    public YYMMDD getCreationDate() throws InvalidFileException {
        try {
            return YYMMDD.getInstance(DTAUtil.getString(this.q_block, 163, 6));
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidDateException(DTAUtil.getString(this.q_block, 5, 8));
        }
    }

    public long getNumberOfPayments() throws InvalidNumberOfPaymentsException {
        try {
            return DTAUtil.getNumericalField(this.z_block, 20, 15);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidNumberOfPaymentsException(DTAUtil.getString(this.z_block, 20, 15));
        }
    }

    public int getOrigBankcode() throws InvalidBankcodeException {
        try {
            return (int)DTAUtil.getNumericalField(this.q_block, 5, 8);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidBankcodeException(DTAUtil.getString(this.q_block, 5, 8));
        }
    }

    public long getOrigCustomerId() throws InvalidAccountNumberException {
        try {
            return DTAUtil.getNumericalField(this.q_block, 13, 10);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidAccountNumberException(DTAUtil.getString(this.q_block, 13, 10));
        }
    }

    public String getOriginatorAsString() {
        return this.getOriginatorLine(0) + "\n" + this.getOriginatorLine(1) + "\n" + this.getOriginatorLine(2) + "\n" + this.getOriginatorLine(3);
    }

    public String getOriginatorLine(int lineNumber) {
        return DTAUtil.getString(this.q_block, 23 + 35 * lineNumber, 35);
    }

    void setZBlock(byte[] b) {
        this.z_block = new byte[256];
        System.arraycopy(b, 0, this.z_block, 0, 256);
    }

    public long getSumAmount() throws InvalidSumAmountException {
        try {
            return DTAUtil.getNumericalField(this.z_block, 5, 15);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidSumAmountException(DTAUtil.getString(this.z_block, 5, 15));
        }
    }

    public boolean isWarnRegulatoryBlock() {
        return this.warnRegulatoryBlock;
    }

    public Map<DTAZV_TBlock, Long> getTBlocks() {
        return Collections.unmodifiableMap(this.tBlocks);
    }

    public void addTBlock(DTAZV_TBlock tBlock, long amount) {
        this.tBlocks.merge(tBlock, amount, Long::sum);
    }

    public byte[] getQ_block() {
        return this.q_block;
    }

    public byte[] getZ_block() {
        return this.z_block;
    }

    public String getUniqueCurrencyCode() {
        String uniqueCurrency = null;
        for (DTAZV_TBlock tBlock : this.tBlocks.keySet()) {
            if (uniqueCurrency == null) {
                uniqueCurrency = tBlock.getCurrencyThatCorrespondsToAmount();
                continue;
            }
            if (uniqueCurrency.equals(tBlock.getCurrencyThatCorrespondsToAmount())) continue;
            return null;
        }
        return uniqueCurrency;
    }

    public long getTotalAmount() {
        long totalAmount = 0L;
        for (DTAZV_TBlock tBlock : this.tBlocks.keySet()) {
            totalAmount += this.tBlocks.get(tBlock).longValue();
        }
        return totalAmount;
    }
}

