/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import de.businesslogics.format.dta.DTAZV_TBlock;
import java.io.Serializable;
import java.util.ArrayList;

public class DTAZVItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    byte[] tblock;

    DTAZVItem(byte[] tblock) {
        this.tblock = (byte[])tblock.clone();
    }

    public DTAZV_TBlock getTicketBlock(DTAZVLogicalFile logicalFile) {
        return new DTAZV_TBlock(logicalFile, this);
    }

    public int getOrigBlz() {
        return Integer.parseInt(new String(this.tblock, 5, 8));
    }

    public String getAccountCurrency() {
        return new String(this.tblock, 13, 3);
    }

    public long getOrigAccount() {
        return Long.parseLong(new String(this.tblock, 16, 10));
    }

    public String getExecutionDate() {
        return new String(this.tblock, 26, 6);
    }

    public int getChargesBlz() {
        return Integer.parseInt(new String(this.tblock, 32, 8));
    }

    public String getChargesCurrency() {
        return new String(this.tblock, 40, 3);
    }

    public long getChargesAccount() {
        return Long.parseLong(new String(this.tblock, 43, 10));
    }

    public String getBeneficiaryBIC() {
        return DTAUtil.getString(this.tblock, 53, 11);
    }

    public String getBeneficaryCountryCode() {
        return DTAUtil.getString(this.tblock, 207, 2);
    }

    public String getBeneficiaryAccount() {
        return DTAUtil.getString(this.tblock, 420, 35);
    }

    public String getCurrency() {
        return new String(this.tblock, 455, 3);
    }

    public long getAmount() {
        return Long.parseLong(new String(this.tblock, 458, 17));
    }

    public String[] getPurpose() {
        ArrayList<String> l = new ArrayList<String>();
        for (int p = 475; p < 615; p += 35) {
            String s = DTAUtil.getString(this.tblock, p, 35);
            if (s.length() <= 0) continue;
            l.add(s);
        }
        String[] toReturn = new String[l.size()];
        l.toArray(toReturn);
        return toReturn;
    }

    public String[] getBeneficiary() {
        String[] toReturn = new String[4];
        int p = 210;
        for (int i = 0; i < 4; ++i) {
            toReturn[i] = new String(this.tblock, p, 35).trim();
            p += 35;
        }
        return toReturn;
    }

    public String getInstructionCode1() {
        return new String(this.tblock, 615, 2);
    }

    public String getInstructionCode2() {
        return new String(this.tblock, 617, 2);
    }

    public String getInstructionCode3() {
        return new String(this.tblock, 619, 2);
    }

    public String getInstructionCode4() {
        return new String(this.tblock, 621, 2);
    }

    public String getFeeArrangement() {
        return new String(this.tblock, 648, 2);
    }

    public String getPaymentType() {
        return new String(this.tblock, 650, 2);
    }

    public String getOriginatorReference() {
        return DTAUtil.getString(this.tblock, 652, 27);
    }

    public void copyT3(byte[] dest, int offset) {
        System.arraycopy(this.tblock, 5, dest, offset, 8);
    }

    public void copyT4b(byte[] dest, int offset) {
        System.arraycopy(this.tblock, 16, dest, offset, 10);
    }

    public byte[] getTblock() {
        return this.tblock;
    }
}

