/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAExtractor;
import de.businesslogics.format.dta.DTAZVItem;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.InvalidHeaderException;
import de.businesslogics.format.dta.InvalidNumberOfPaymentsException;
import de.businesslogics.format.dta.InvalidSumAmountException;
import de.businesslogics.format.dta.RecordMissingException;

public class DTAZVExtractor
extends DTAExtractor {
    private boolean processingDone = false;
    private static final char BLOCK_Q = 'Q';
    private static final char BLOCK_T = 'T';
    private static final char BLOCK_U = 'U';
    private static final char BLOCK_V = 'V';
    private static final char BLOCK_W = 'W';
    private static final char BLOCK_Z = 'Z';
    private static final String ALL_HEADER = new String(new char[]{'Q', 'T', 'U', 'V', 'W', 'Z'});
    private static final long NOV2013 = 1383519600000L;
    protected byte[] amount = new byte[17];
    private DTAZVLogicalFile logicalFile;
    private long numberOfPayments;
    private long sumAmount;

    public DTAZVExtractor() {
        super(new MyNullFormatListener());
    }

    public DTAZVExtractor(DTAZVListener listener) {
        super(listener);
    }

    @Override
    protected void doBlock() throws InvalidFileException {
        switch (this.block[4]) {
            case 81: {
                this.doBlockQ();
                break;
            }
            case 84: {
                this.doBlockT();
                break;
            }
            case 90: {
                this.doBlockZ();
            }
        }
    }

    @Override
    protected int doNewBlock() throws InvalidHeaderException {
        switch (this.block[4]) {
            case 81: {
                if (this.logicalFile != null) {
                    throw new InvalidHeaderException('Q', "Z");
                }
                return 256;
            }
            case 84: {
                if (this.logicalFile == null) {
                    throw new InvalidHeaderException('T', "Q");
                }
                return 768;
            }
            case 90: {
                if (this.numberOfPayments == 0L) {
                    throw new InvalidHeaderException('Z', "T");
                }
                return 256;
            }
            case 85: 
            case 86: 
            case 87: {
                if (System.currentTimeMillis() > 1383519600000L) {
                    this.logicalFile.warnRegulatoryBlock = true;
                }
                return 256;
            }
        }
        throw new InvalidHeaderException((char)this.block[4], ALL_HEADER);
    }

    @Override
    protected void finish() throws InvalidFileException {
        if (!this.processingDone) {
            throw new RecordMissingException('Q');
        }
        if (this.logicalFile != null) {
            throw new RecordMissingException('Z');
        }
    }

    private void doBlockQ() {
        this.processingDone = true;
        this.logicalFile = new DTAZVLogicalFile(this.block);
        this.sumAmount = 0L;
        ((DTAZVListener)this.formatListener).startLogicalFile(this.logicalFile);
    }

    private void doBlockT() {
        DTAZVItem item = new DTAZVItem(this.block);
        ++this.numberOfPayments;
        this.sumAmount += item.getAmount() / 1000L;
        this.logicalFile.addTBlock(item.getTicketBlock(this.logicalFile), item.getAmount());
        ((DTAZVListener)this.formatListener).handleItem(item);
    }

    private void doBlockZ() throws InvalidFileException {
        this.logicalFile.setZBlock(this.block);
        if (this.numberOfPayments != this.logicalFile.getNumberOfPayments()) {
            this.handleWarning(new InvalidNumberOfPaymentsException(this.logicalFile.getNumberOfPayments(), this.numberOfPayments));
        }
        long shouldBe = this.sumAmount;
        long was = this.logicalFile.getSumAmount();
        if (was != shouldBe) {
            this.handleWarning(new InvalidSumAmountException(was, shouldBe));
        }
        ((DTAZVListener)this.formatListener).endLogicalFile(this.logicalFile);
        this.numberOfPayments = 0L;
        this.logicalFile = null;
    }

    private static class MyNullFormatListener
    extends DTAExtractor.NullFormatListener
    implements DTAZVListener {
        private MyNullFormatListener() {
        }

        @Override
        public void startLogicalFile(DTAZVLogicalFile logicalFile) {
        }

        @Override
        public void endLogicalFile(DTAZVLogicalFile logicalFile) {
        }

        @Override
        public void handleItem(DTAZVItem item) {
        }
    }

    public static interface DTAZVListener
    extends DTAExtractor.FormatListener {
        public void startLogicalFile(DTAZVLogicalFile var1);

        public void endLogicalFile(DTAZVLogicalFile var1);

        public void handleItem(DTAZVItem var1);
    }
}

